/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.http.admin;

import com.caucho.server.http.ResinServer;
import com.caucho.util.L10N;
import com.caucho.util.QDate;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.util.ArrayList;

public class PingThread
implements Runnable {
    static WriteStream dbg = LogStream.open("/caucho.com/http/ping");
    static L10N L = new L10N("com/caucho/server/http/messages");
    protected ResinServer resinServer;
    private String pingHost;
    private int pingPort;
    private ArrayList urlList = new ArrayList();
    private ArrayList pathList = new ArrayList();
    private long sleepTime = 900000L;
    private long retryTime = 1000L;
    private int tryCount = 3;
    private long socketTimeout = 10000L;

    public ResinServer getResinServer() {
        return this.resinServer;
    }

    public void setResinServer(ResinServer server) {
        this.resinServer = server;
    }

    public String getPingHost() {
        return this.pingHost;
    }

    public void setPingHost(String pingHost) {
        this.pingHost = pingHost;
    }

    public int getPingPort() {
        return this.pingPort;
    }

    public void setPingPort(int pingPort) {
        this.pingPort = pingPort;
    }

    public void addURL(String url) {
        this.urlList.add(url);
    }

    public long getSleepTime() {
        return this.sleepTime;
    }

    public void setSleepTime(long sleepTime) {
        this.sleepTime = sleepTime;
    }

    public long getRetryTime() {
        return this.retryTime;
    }

    public void setRetryTime(long retryTime) {
        this.retryTime = retryTime;
    }

    public int getTryCount() {
        return this.tryCount;
    }

    public void setTryCount(int tryCount) {
        this.tryCount = tryCount;
    }

    public long getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(long timeout) {
        this.socketTimeout = timeout;
    }

    public void init() {
        String host = this.pingHost;
        if (host == null) {
            host = "localhost";
        }
        for (int i = 0; i < this.urlList.size(); ++i) {
            String url = (String)this.urlList.get(i);
            if (url.startsWith("/")) {
                url = this.pingPort > 0 ? "http://" + host + ":" + this.pingPort + url : "http://" + host + url;
            }
            this.pathList.add(Vfs.lookup(url));
        }
    }

    public void run() {
        while (!this.resinServer.isClosed()) {
            if (this.sleepTime <= 0L || this.pathList.size() == 0) {
                return;
            }
            try {
                Thread.currentThread();
                Thread.sleep(this.sleepTime);
                for (int i = this.pathList.size() - 1; i >= 0; --i) {
                    Path url = (Path)this.pathList.get(i);
                    boolean isOkay = false;
                    for (int j = 0; !isOkay && j < this.tryCount; ++j) {
                        Object status = null;
                        try {
                            isOkay = this.checkPing(url, j);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        if (isOkay) continue;
                        Thread.currentThread();
                        Thread.sleep(this.retryTime);
                    }
                    if (isOkay) continue;
                    this.pingFailed(url);
                }
            }
            catch (Throwable e) {
                dbg.log(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkPing(Path url, int count) throws Exception {
        if (this.socketTimeout > 0L) {
            url.setAttribute("socket-timeout", new Integer((int)this.socketTimeout));
        }
        ReadStream is = url.openRead();
        try {
            String status = (String)is.getAttribute("status");
            if (dbg.canWrite()) {
                dbg.log("ping " + url + " " + status);
            }
            if (status != null && status.equals("200")) {
                boolean bl = true;
                return bl;
            }
            this.pingFailedOnce(url, count, is);
            boolean bl = false;
            return bl;
        }
        finally {
            is.close();
        }
    }

    protected void pingFailedOnce(Path url, int count, ReadStream is) throws Exception {
        String status = (String)is.getAttribute("status");
        System.err.println("ping " + url + " failed (" + count + ") status:" + status);
    }

    protected void pingFailed(Path url) throws Exception {
        if (dbg.canWrite()) {
            dbg.log(url + " failed.  Shutting down.");
        }
        System.err.println("pinging " + url + " failed.");
        System.err.println("Shutting down at " + QDate.formatLocal(System.currentTimeMillis()));
        this.resinServer.close();
    }
}

