/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.http.log;

import com.caucho.http.log.AbstractAccessLog;
import com.caucho.server.http.Request;
import com.caucho.server.http.Response;
import com.caucho.util.Alarm;
import com.caucho.util.ByteBuffer;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.util.CharSegment;
import com.caucho.util.QDate;
import com.caucho.util.RegistryNode;
import com.caucho.vfs.Path;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AccessLog
extends AbstractAccessLog {
    private static final int ROLLOVER_SIZE = 10000000;
    private static final long DAY = 86400000L;
    private static final long ROLLOVER_CHECK_TIME = 600000L;
    private static final int BUFFER_SIZE = 65536;
    private static final int BUFFER_GAP = 8192;
    private QDate calendar;
    private String timeFormat;
    private WriteStream os;
    private final byte[] _buffer = new byte[65536];
    private int _bufferLength;
    private String format;
    private Segment[] segments;
    private String rolloverPrefix;
    private String archiveFormat;
    private long rolloverPeriod = -1L;
    private int rolloverSize = 10000000;
    private long rolloverCheckTime = 600000L;
    private long nextTime = -1L;
    private CharBuffer cb = new CharBuffer();
    private CharBuffer timeCharBuffer = new CharBuffer();
    private ByteBuffer timeBuffer = new ByteBuffer();
    private long lastTime;

    public void setFormat(String format) {
        this.format = format;
    }

    public void setArchiveFormat(String format) {
        this.archiveFormat = format;
    }

    public void setRolloverPeriod(long period) {
        if (period > 0L) {
            this.rolloverPeriod = period;
            this.rolloverPeriod += 3599999L;
            this.rolloverPeriod -= this.rolloverPeriod % 3600000L;
        } else {
            this.rolloverPeriod = -1L;
        }
    }

    public void setRolloverSize(int size) {
        this.rolloverSize = size <= 0 ? 0x3FFFFFFF : size;
    }

    public void setRolloverCheckTime(long period) {
        if (period > 1000L) {
            this.rolloverCheckTime = period;
        } else if (period > 0L) {
            this.rolloverCheckTime = 1000L;
        }
    }

    public void init() throws ServletException, IOException {
        this.calendar = new QDate();
        this.path.getParent().mkdirs();
        this.rolloverPrefix = this.path.getTail();
        long now = Alarm.getCurrentTime();
        long lastModified = this.path.getLastModified();
        if (lastModified <= 0L) {
            lastModified = now;
        }
        this.calendar.setTime(lastModified);
        long zone = this.calendar.getZoneOffset();
        if (this.rolloverPeriod > 0L) {
            this.nextTime = RegistryNode.periodEnd(lastModified + zone, this.rolloverPeriod) - zone;
            if (dbg.canWrite()) {
                dbg.log(this.path + ": next rollover at " + QDate.formatLocal(this.nextTime));
            }
            if (this.nextTime < now) {
                this.rolloverLog(now);
            }
        } else {
            this.nextTime = now + this.rolloverCheckTime;
        }
        this.os = this.path.openAppend();
        if (this.format == null) {
            this.format = "%h %l %u %t \"%r\" %>s %b \"%{Referer}i\" \"%{User-Agent}i\"";
        }
        ArrayList segments = this.parseFormat(this.format);
        this.segments = new Segment[segments.size()];
        segments.toArray(this.segments);
        if (this.timeFormat == null || this.timeFormat.equals("")) {
            this.timeFormat = "[%d/%b/%Y:%H:%M:%S %z]";
        }
    }

    private ArrayList parseFormat(String format) {
        ArrayList<Segment> segments = new ArrayList<Segment>();
        CharBuffer cb = new CharBuffer();
        int i = 0;
        block4: while (i < format.length()) {
            char ch;
            if ((ch = format.charAt(i++)) != '%' || i >= format.length()) {
                cb.append(ch);
                continue;
            }
            String arg = null;
            if ((ch = format.charAt(i++)) == '>') {
                ch = format.charAt(i++);
            } else if (ch == '{') {
                if (cb.length() > 0) {
                    segments.add(new Segment(this, 0, cb.toString()));
                }
                cb.clear();
                while (i < format.length() && format.charAt(i++) != '}') {
                    cb.append(format.charAt(i - 1));
                }
                arg = cb.toString();
                cb.clear();
                ch = format.charAt(i++);
            }
            switch (ch) {
                case 'T': 
                case 'U': 
                case 'b': 
                case 'c': 
                case 'h': 
                case 'i': 
                case 'l': 
                case 'n': 
                case 'o': 
                case 'r': 
                case 's': 
                case 'u': {
                    if (cb.length() > 0) {
                        segments.add(new Segment(this, 0, cb.toString()));
                    }
                    cb.clear();
                    segments.add(new Segment(this, ch, arg));
                    continue block4;
                }
                case 't': {
                    if (cb.length() > 0) {
                        segments.add(new Segment(this, 0, cb.toString()));
                    }
                    cb.clear();
                    if (arg != null) {
                        this.timeFormat = arg;
                    }
                    segments.add(new Segment(this, ch, arg));
                    continue block4;
                }
            }
            cb.append('%');
            --i;
        }
        cb.append(CauchoSystem.getNewlineString());
        segments.add(new Segment(this, 0, cb.toString()));
        return segments;
    }

    public synchronized void log(HttpServletRequest req, HttpServletResponse res, ServletContext application) throws IOException {
        Request request = (Request)req;
        Response response = (Response)res;
        long now = Alarm.getCurrentTime();
        if (this.nextTime < now) {
            if (this.os.getBufferOffset() > 0) {
                this.os.flush();
            }
            this.rolloverLog(now);
        }
        if (this.os == null) {
            return;
        }
        byte[] buffer = this._buffer;
        int offset = this._bufferLength;
        if (buffer == null) {
            return;
        }
        if (buffer.length - offset < 8192) {
            this.os.write(buffer, 0, offset);
            this.os.flush();
            offset = 0;
        }
        this._bufferLength = offset = this.log(request, response, buffer, offset, buffer.length - offset);
    }

    private int log(Request request, Response response, byte[] buffer, int offset, int length) throws IOException {
        int len = this.segments.length;
        block18: for (int i = 0; i < len; ++i) {
            Segment segment = this.segments[i];
            String value = null;
            Object cbValue = null;
            CharSegment csValue = null;
            switch (segment.code) {
                case 0: {
                    int sublen = segment.data.length;
                    byte[] data = segment.data;
                    for (int j = 0; j < sublen; ++j) {
                        buffer[offset++] = data[j];
                    }
                    continue block18;
                }
                case 1: {
                    buffer[offset++] = segment.ch;
                    continue block18;
                }
                case 98: {
                    if (response.getStatusCode() == 304) {
                        buffer[offset++] = 45;
                        continue block18;
                    }
                    offset = this.print(buffer, offset, response.getContentLength());
                    continue block18;
                }
                case 99: {
                    Cookie cookie = request.getCookie(segment.string);
                    if (cookie == null) {
                        cookie = response.getCookie(segment.string);
                    }
                    if (cookie == null) {
                        buffer[offset++] = 45;
                        continue block18;
                    }
                    offset = this.print(buffer, offset, cookie.getValue());
                    continue block18;
                }
                case 2: {
                    ArrayList cookies = response.getCookies();
                    if (cookies == null || cookies.size() == 0) {
                        buffer[offset++] = 45;
                        continue block18;
                    }
                    this.cb.clear();
                    response.fillCookie(this.cb, (Cookie)cookies.get(0), 0L, 0);
                    offset = this.print(buffer, offset, this.cb.getBuffer(), 0, this.cb.getLength());
                    continue block18;
                }
                case 104: {
                    offset = request.printRemoteAddr(buffer, offset);
                    continue block18;
                }
                case 105: {
                    csValue = request.getHeaderBuffer(segment.string);
                    if (csValue == null) {
                        buffer[offset++] = 45;
                        continue block18;
                    }
                    offset = this.print(buffer, offset, csValue);
                    continue block18;
                }
                case 108: {
                    buffer[offset++] = 45;
                    continue block18;
                }
                case 110: {
                    Object oValue = request.getAttribute(segment.string);
                    if (oValue == null) {
                        buffer[offset++] = 45;
                        continue block18;
                    }
                    offset = this.print(buffer, offset, String.valueOf(oValue));
                    continue block18;
                }
                case 111: {
                    value = response.getHeader(segment.string);
                    if (value == null) {
                        buffer[offset++] = 45;
                        continue block18;
                    }
                    offset = this.print(buffer, offset, value);
                    continue block18;
                }
                case 114: {
                    offset = this.print(buffer, offset, request.getMethodBuffer());
                    buffer[offset++] = 32;
                    byte[] data = request.getUriBuffer();
                    int sublen = request.getUriLength();
                    for (int j = sublen - 1; j >= 0; --j) {
                        buffer[offset + j] = data[j];
                    }
                    offset += sublen;
                    buffer[offset++] = 32;
                    offset = this.print(buffer, offset, request.getProtocolBuffer());
                    continue block18;
                }
                case 115: {
                    int status = response.getStatusCode();
                    buffer[offset++] = (byte)(48 + status / 100 % 10);
                    buffer[offset++] = (byte)(48 + status / 10 % 10);
                    buffer[offset++] = (byte)(48 + status % 10);
                    continue block18;
                }
                case 116: {
                    long date = Alarm.getCurrentTime();
                    if (date / 1000L != this.lastTime / 1000L) {
                        this.fillTime(date);
                    }
                    int sublen = this.timeBuffer.getLength();
                    byte[] data = this.timeBuffer.getBuffer();
                    System.arraycopy(data, 0, buffer, offset, sublen);
                    offset += sublen;
                    continue block18;
                }
                case 84: {
                    long finishDate = request.getDate();
                    long now = Alarm.getCurrentTime();
                    offset = this.print(buffer, offset, (int)((now - finishDate + 500L) / 1000L));
                    continue block18;
                }
                case 117: {
                    value = request.getRemoteUser(false);
                    if (value == null) {
                        buffer[offset++] = 45;
                        continue block18;
                    }
                    buffer[offset++] = 34;
                    offset = this.print(buffer, offset, value);
                    buffer[offset++] = 34;
                    continue block18;
                }
                case 85: {
                    offset = this.print(buffer, offset, request.getRequestURI());
                    continue block18;
                }
                default: {
                    throw new IOException();
                }
            }
        }
        return offset;
    }

    private synchronized void rolloverLog(long now) {
        String savedName = null;
        this.calendar.setTime(now);
        long zone = this.calendar.getZoneOffset();
        long time = now + zone;
        if (this.rolloverPeriod > 0L) {
            savedName = this.getArchiveName(this.nextTime - 1L);
        } else if ((long)this.rolloverSize < this.path.getLength()) {
            savedName = this.getArchiveName(this.nextTime - 1L);
        }
        if (this.rolloverPeriod > 0L) {
            this.nextTime = RegistryNode.periodEnd(now + zone, this.rolloverPeriod) - zone;
            if (dbg.canWrite()) {
                dbg.log(this.path + ": next rollover at " + QDate.formatLocal(this.nextTime));
            }
        } else {
            this.nextTime = now + this.rolloverCheckTime;
        }
        if (savedName != null) {
            try {
                if (this.os != null) {
                    this.os.write(this._buffer, 0, this._bufferLength);
                    this._bufferLength = 0;
                    this.os.close();
                }
                this.os = null;
                String tail = this.path.getTail();
                Path newPath = this.path.getParent().lookup(savedName);
                try {
                    newPath.remove();
                }
                catch (Throwable e) {
                    dbg.log(e);
                }
                this.path.renameTo(newPath);
            }
            catch (IOException e) {
                dbg.log(e);
            }
            for (int i = 0; i < 3 && this.os == null; ++i) {
                try {
                    this.os = this.path.openAppend();
                    continue;
                }
                catch (IOException e) {
                    dbg.log(e);
                }
            }
        }
    }

    protected String getArchiveName(long time) {
        if (time <= 0L) {
            time = Alarm.getCurrentTime();
        }
        if (this.archiveFormat != null) {
            return QDate.formatLocal(time, this.archiveFormat);
        }
        if (this.rolloverPeriod % 86400000L == 0L) {
            return this.rolloverPrefix + "." + QDate.formatLocal(time, "%Y%m%d");
        }
        return this.rolloverPrefix + "." + QDate.formatLocal(time, "%Y%m%d.%H");
    }

    private int print(byte[] buffer, int offset, CharSegment cb) {
        char[] charBuffer = cb.getBuffer();
        int cbOffset = cb.getOffset();
        int length = cb.getLength();
        if (buffer.length - offset - 256 < length) {
            length = buffer.length - offset - 256;
        }
        for (int i = length - 1; i >= 0; --i) {
            buffer[offset + i] = (byte)charBuffer[cbOffset + i];
        }
        return offset + length;
    }

    private int print(byte[] buffer, int offset, String s) {
        int length = s.length();
        for (int i = length - 1; i >= 0; --i) {
            buffer[offset + i] = (byte)s.charAt(i);
        }
        return offset + length;
    }

    private int print(byte[] buffer, int offset, char[] cb, int cbOff, int length) {
        for (int i = length - 1; i >= 0; --i) {
            buffer[offset + i] = (byte)cb[cbOff + i];
        }
        return offset + length;
    }

    private int print(byte[] buffer, int offset, int v) {
        if (v == 0) {
            buffer[offset] = 48;
            return offset + 1;
        }
        if (v < 0) {
            buffer[offset++] = 45;
            v = -v;
        }
        int length = 0;
        int exp = 10;
        while (v >= exp) {
            exp = 10 * exp;
            ++length;
        }
        offset += length;
        for (int i = 0; i <= length; ++i) {
            buffer[offset - i] = (byte)(v % 10 + 48);
            v /= 10;
        }
        return offset + 1;
    }

    public synchronized void flush() throws IOException {
        this.os.write(this._buffer, 0, this._bufferLength);
        this._bufferLength = 0;
        this.os.flush();
    }

    public synchronized void destroy() throws IOException {
        this.flush();
        this.os.close();
    }

    void fillTime(long date) throws IOException {
        if (date / 1000L == this.lastTime / 1000L) {
            return;
        }
        this.timeCharBuffer.clear();
        QDate.formatLocal(this.timeCharBuffer, date, this.timeFormat);
        this.timeBuffer.clear();
        this.timeBuffer.add(this.timeCharBuffer.getBuffer(), 0, this.timeCharBuffer.getLength());
        this.lastTime = date;
    }

    static class Segment {
        static final int TEXT = 0;
        static final int CHAR = 1;
        static final int SET_COOKIE = 2;
        int code;
        byte[] data;
        byte ch;
        String string;
        AccessLog log;

        Segment(AccessLog log, int code, String string) {
            this.log = log;
            this.code = code;
            this.string = string;
            if (string != null) {
                if (code == 111 && string.equalsIgnoreCase("Set-Cookie")) {
                    this.code = 2;
                }
                this.data = string.getBytes();
                if (code == 0 && string.length() == 1) {
                    this.ch = (byte)string.charAt(0);
                    code = 1;
                }
            }
        }
    }
}

