/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.http.security;

import com.caucho.http.security.AbstractAuthenticator;
import com.caucho.http.session.SessionManager;
import com.caucho.security.BasicPrincipal;
import com.caucho.server.http.Application;
import com.caucho.server.http.CauchoRequest;
import com.caucho.sql.DBPool;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.WriteStream;
import java.security.Principal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;

public class JdbcAuthenticator
extends AbstractAuthenticator {
    private static WriteStream dbg = LogStream.open("/caucho.com/http/auth");
    static L10N L = new L10N("com/caucho/server/http/messages");
    private String poolName;
    private DataSource dataSource;
    private String passwordQuery = "SELECT password FROM LOGIN WHERE username=?";
    private String cookieUpdate;
    private String cookieQuery;
    private boolean cookieLogout;
    private String roleQuery;
    protected boolean useCookie;
    protected int cookieVersion = -1;
    protected String cookieDomain;
    protected long cookieMaxAge = 31536000000L;
    private CharBuffer cb;

    public String getPoolName() {
        return this.poolName;
    }

    public void setPoolName(String name) {
        this.poolName = name;
    }

    public String getPasswordQuery() {
        return this.passwordQuery;
    }

    public void setPasswordQuery(String query) {
        this.passwordQuery = query;
    }

    public String getCookieAuthQuery() {
        return this.cookieQuery;
    }

    public void setCookieAuthQuery(String query) {
        this.cookieQuery = query;
    }

    public String getCookieAuthUpdate() {
        return this.cookieUpdate;
    }

    public void setCookieAuthUpdate(String query) {
        this.cookieUpdate = query;
    }

    public void setCookieLogout(boolean cookieLogout) {
        this.cookieLogout = cookieLogout;
    }

    public String getRoleQuery() {
        return this.roleQuery;
    }

    public void setRoleQuery(String query) {
        this.roleQuery = query;
    }

    public boolean getUseCookie() {
        return this.useCookie;
    }

    public void setUseCookie(boolean useCookie) {
        this.useCookie = useCookie;
    }

    public int getCookieVersion() {
        return this.cookieVersion;
    }

    public void setCookieVersion(int version) {
        this.cookieVersion = version;
    }

    public String getCookieDomain() {
        return this.cookieDomain;
    }

    public void setCookieDomain(String cookieDomain) {
        this.cookieDomain = cookieDomain;
    }

    public long getCookieMaxAge() {
        return this.cookieMaxAge;
    }

    public void setCookieMaxAge(long cookieMaxAge) {
        this.cookieMaxAge = cookieMaxAge;
    }

    public void init() throws ServletException {
        block13: {
            super.init();
            this.cb = new CharBuffer();
            try {
                Context env = (Context)new InitialContext().lookup("java:comp/env");
                this.dataSource = this.poolName == null ? (DataSource)env.lookup("jdbc/db-pool") : (DataSource)env.lookup(this.poolName);
            }
            catch (Exception e) {
                if (!dbg.canWrite()) break block13;
                dbg.log(e);
            }
        }
        try {
            if (this.dataSource == null) {
                this.dataSource = this.poolName != null ? DBPool.getPool(this.poolName) : DBPool.getPool("db-pool");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.dataSource == null) {
            this.poolName = this.poolName == null ? "jdbc/db-pool" : this.poolName;
            throw new ServletException(L.l("Unknown database pool `{0}'", this.poolName));
        }
        int i = this.passwordQuery.indexOf(63);
        if (i < 0) {
            throw new ServletException(L.l("`{0}' expects a parameter", "password-query"));
        }
        if (this.cookieQuery != null && (i = this.cookieQuery.indexOf(63)) < 0) {
            throw new ServletException(L.l("`{0}' expects a parameter", "cookie-auth-query"));
        }
        if (this.cookieUpdate != null) {
            i = this.cookieUpdate.indexOf(63);
            if (i < 0) {
                throw new ServletException(L.l("`{0}' expects two parameters", "cookie-auth-update"));
            }
            int j = this.cookieUpdate.indexOf(63, i + 1);
            if (j < 0) {
                throw new ServletException(L.l("`{0}' expects two parameters", "cookie-auth-update"));
            }
        }
        if (this.cookieUpdate != null && this.cookieQuery == null) {
            throw new ServletException(L.l("<{0}> expects `{1}'", (Object)"cookie-auth-update", "cookie-query"));
        }
        if (this.roleQuery != null && (i = this.roleQuery.indexOf(63)) < 0) {
            throw new ServletException(L.l("`{0}' expects a parameter", "role-query"));
        }
    }

    public Principal loginImpl(HttpServletRequest request, HttpServletResponse response, ServletContext application, String username, String password) throws ServletException {
        Principal user = this.loginImpl(username, password);
        if (this.cookieQuery == null || user == null) {
            return user;
        }
        String cookieAuth = (String)request.getAttribute("j_use_cookie_auth");
        if (cookieAuth == null) {
            cookieAuth = request.getParameter("j_use_cookie_auth");
        }
        if ("true".equals(cookieAuth) || this.useCookie && cookieAuth == null) {
            this.addAuthCookie(request, response, application, user);
        }
        return user;
    }

    protected void addAuthCookie(HttpServletRequest request, HttpServletResponse response, ServletContext application, Principal user) {
        Application app = (Application)application;
        SessionManager sm = app.getSessionManager();
        String id = sm.createSessionId(0, request);
        if (this.updateCookie(user, id)) {
            Cookie cookie = new Cookie("resinauthid", id);
            cookie.setPath("/");
            if (this.getCookieVersion() >= 0) {
                cookie.setVersion(this.getCookieVersion());
            } else {
                cookie.setVersion(sm.getCookieVersion());
            }
            if (this.cookieDomain != null) {
                cookie.setDomain(this.cookieDomain);
            } else if (this.getCookieDomain() != null) {
                cookie.setDomain(this.getCookieDomain());
            } else {
                cookie.setDomain(sm.getCookieDomain());
            }
            if (this.cookieMaxAge > 0L) {
                cookie.setMaxAge((int)(this.cookieMaxAge / 1000L));
            }
            response.addCookie(cookie);
        }
    }

    /*
     * Loose catch block
     */
    public Principal loginImpl(String username, String password) throws ServletException {
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        block39: {
            block35: {
                conn = null;
                stmt = null;
                rs = null;
                conn = this.dataSource.getConnection();
                stmt = conn.prepareStatement(this.passwordQuery);
                stmt.setString(1, username);
                rs = stmt.executeQuery();
                if (rs.next()) break block35;
                if (dbg.canWrite()) {
                    dbg.log("no such user:" + username);
                }
                Principal principal = null;
                Object var9_9 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                return principal;
            }
            String dbPassword = rs.getString(1);
            if (dbPassword == null || !dbPassword.equals(password)) break block39;
            BasicPrincipal basicPrincipal = new BasicPrincipal(username);
            Object var9_10 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e2) {
                // empty catch block
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e2) {
                // empty catch block
            }
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e2) {
                // empty catch block
            }
            return basicPrincipal;
        }
        if (dbg.canWrite()) {
            dbg.log("mismatched password:" + username);
        }
        Principal principal = null;
        Object var9_11 = null;
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e2) {
            // empty catch block
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException e2) {
            // empty catch block
        }
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e2) {
            // empty catch block
        }
        return principal;
        catch (Exception e) {
            try {
                throw new ServletException((Throwable)e);
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e2) {}
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    protected String getDigestPassword(HttpServletRequest request, HttpServletResponse response, ServletContext application, String username, String realm) throws ServletException {
        String dbPassword;
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        block27: {
            conn = null;
            stmt = null;
            rs = null;
            conn = this.dataSource.getConnection();
            stmt = conn.prepareStatement(this.passwordQuery);
            stmt.setString(1, username);
            rs = stmt.executeQuery();
            if (rs.next()) break block27;
            if (dbg.canWrite()) {
                dbg.log("no such user:" + username);
            }
            String string = null;
            Object var12_12 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e2) {
                // empty catch block
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e2) {
                // empty catch block
            }
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e2) {
                // empty catch block
            }
            return string;
        }
        String string = dbPassword = rs.getString(1);
        Object var12_13 = null;
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e2) {
            // empty catch block
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException e2) {
            // empty catch block
        }
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e2) {
            // empty catch block
        }
        return string;
        catch (Exception e) {
            try {
                throw new ServletException((Throwable)e);
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e2) {}
                throw throwable;
            }
        }
    }

    protected Principal getUserPrincipalImpl(HttpServletRequest request, ServletContext application) throws ServletException {
        if (this.cookieQuery == null) {
            return null;
        }
        Cookie cookie = null;
        if (request instanceof CauchoRequest) {
            cookie = ((CauchoRequest)request).getCookie("resinauthid");
        } else {
            Cookie[] cookies = request.getCookies();
            for (int i = 0; cookies != null && i < cookies.length; ++i) {
                if (!cookies[i].getName().equals("resinauthid")) continue;
                cookie = cookies[i];
                break;
            }
        }
        if (cookie == null) {
            return null;
        }
        return this.authenticateCookie(cookie.getValue());
    }

    /*
     * Loose catch block
     */
    public Principal authenticateCookie(String cookieValue) throws ServletException {
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        block38: {
            block34: {
                if (this.cookieQuery == null) {
                    return null;
                }
                conn = null;
                stmt = null;
                rs = null;
                conn = this.dataSource.getConnection();
                stmt = conn.prepareStatement(this.cookieQuery);
                stmt.setString(1, cookieValue);
                rs = stmt.executeQuery();
                if (rs.next()) break block34;
                Principal principal = null;
                Object var8_8 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                return principal;
            }
            String user = rs.getString(1);
            if (user == null) break block38;
            BasicPrincipal basicPrincipal = new BasicPrincipal(user);
            Object var8_9 = null;
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e2) {
                // empty catch block
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e2) {
                // empty catch block
            }
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e2) {
                // empty catch block
            }
            return basicPrincipal;
        }
        Principal principal = null;
        Object var8_10 = null;
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e2) {
            // empty catch block
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException e2) {
            // empty catch block
        }
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e2) {
            // empty catch block
        }
        return principal;
        catch (Exception e) {
            try {
                throw new ServletException((Throwable)e);
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e2) {}
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean updateCookie(Principal user, String cookieValue) {
        block21: {
            if (this.cookieUpdate == null || user == null || cookieValue == null) {
                return true;
            }
            Connection conn = null;
            PreparedStatement stmt = null;
            conn = this.dataSource.getConnection();
            stmt = conn.prepareStatement(this.cookieUpdate);
            stmt.setString(1, cookieValue);
            stmt.setString(2, user.getName());
            stmt.executeUpdate();
            Object var7_5 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e2) {
                // empty catch block
            }
            try {
                if (conn != null) {
                    conn.close();
                }
                break block21;
            }
            catch (SQLException e2) {}
            break block21;
            {
                catch (Exception e) {
                    if (dbg.canWrite()) {
                        dbg.log(e);
                    }
                    Object var7_6 = null;
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (SQLException e2) {
                        // empty catch block
                    }
                    try {
                        if (conn != null) {
                            conn.close();
                        }
                        break block21;
                    }
                    catch (SQLException e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isUserInRole(HttpServletRequest request, HttpServletResponse response, ServletContext application, Principal principal, String role) {
        block40: {
            block39: {
                block32: {
                    block38: {
                        block37: {
                            block31: {
                                if (principal == null) return false;
                                if (role == null) {
                                    return false;
                                }
                                if (this.roleQuery == null) {
                                    return "user".equals(role);
                                }
                                conn = null;
                                stmt = null;
                                rs = null;
                                try {
                                    try {
                                        conn = this.dataSource.getConnection();
                                        stmt = conn.prepareStatement(this.roleQuery);
                                        stmt.setString(1, principal.getName());
                                        rs = stmt.executeQuery();
                                        while (rs.next()) {
                                            dbRole = rs.getString(1);
                                            if (!role.equals(dbRole)) continue;
                                            var10_12 = true;
                                            var12_14 = null;
                                            break block31;
                                        }
                                        dbRole = false;
                                        break block32;
                                    }
                                    catch (Exception e) {
                                        JdbcAuthenticator.dbg.log(e);
                                        var10_13 = false;
                                        var12_16 = null;
                                        try {
                                            if (rs != null) {
                                                rs.close();
                                            }
                                        }
                                        catch (SQLException e) {
                                            // empty catch block
                                        }
                                        try {
                                            if (stmt != null) {
                                                stmt.close();
                                            }
                                        }
                                        catch (SQLException e) {
                                            // empty catch block
                                        }
                                        try {
                                            if (conn == null) return var10_13;
                                            conn.close();
                                            return var10_13;
                                        }
                                        catch (SQLException e) {
                                            // empty catch block
                                        }
                                        return var10_13;
                                    }
                                }
                                catch (Throwable var11_22) {
                                    block36: {
                                        block35: {
                                            var12_17 = null;
                                            ** try [egrp 2[TRYBLOCK] [6 : 164->179)] { 
lbl55:
                                            // 1 sources

                                            if (rs != null) {
                                                rs.close();
                                            }
                                            break block35;
lbl58:
                                            // 1 sources

                                            catch (SQLException e) {
                                                // empty catch block
                                            }
                                        }
                                        ** try [egrp 3[TRYBLOCK] [7 : 181->196)] { 
lbl62:
                                        // 1 sources

                                        if (stmt != null) {
                                            stmt.close();
                                        }
                                        break block36;
lbl65:
                                        // 1 sources

                                        catch (SQLException e) {
                                            // empty catch block
                                        }
                                    }
                                    try {}
                                    catch (SQLException e) {
                                        throw var11_22;
                                    }
                                    if (conn == null) throw var11_22;
                                    conn.close();
                                    throw var11_22;
                                }
                            }
                            ** try [egrp 2[TRYBLOCK] [6 : 164->179)] { 
lbl76:
                            // 1 sources

                            if (rs != null) {
                                rs.close();
                            }
                            break block37;
lbl79:
                            // 1 sources

                            catch (SQLException e) {
                                // empty catch block
                            }
                        }
                        ** try [egrp 3[TRYBLOCK] [7 : 181->196)] { 
lbl83:
                        // 1 sources

                        if (stmt != null) {
                            stmt.close();
                        }
                        break block38;
lbl86:
                        // 1 sources

                        catch (SQLException e) {
                            // empty catch block
                        }
                    }
                    ** try [egrp 4[TRYBLOCK] [8 : 198->213)] { 
lbl90:
                    // 1 sources

                    if (conn == null) return var10_12;
                    conn.close();
                    return var10_12;
lbl93:
                    // 1 sources

                    catch (SQLException e) {
                        // empty catch block
                    }
                    return var10_12;
                }
                var12_15 = null;
                ** try [egrp 2[TRYBLOCK] [6 : 164->179)] { 
lbl99:
                // 1 sources

                if (rs != null) {
                    rs.close();
                }
                break block39;
lbl102:
                // 1 sources

                catch (SQLException e) {
                    // empty catch block
                }
            }
            ** try [egrp 3[TRYBLOCK] [7 : 181->196)] { 
lbl106:
            // 1 sources

            if (stmt != null) {
                stmt.close();
            }
            break block40;
lbl109:
            // 1 sources

            catch (SQLException e) {
                // empty catch block
            }
        }
        try {}
        catch (SQLException e) {
            // empty catch block
            return dbRole;
        }
        if (conn == null) return dbRole;
        conn.close();
        return dbRole;
    }

    public void logout(HttpServletRequest request, HttpServletResponse response, ServletContext application, Principal user) throws ServletException {
        super.logout(request, response, application, user);
        if (this.cookieLogout) {
            this.updateCookie(user, "");
        }
    }
}

