/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server;

import com.caucho.server.Connection;
import com.caucho.server.ServerRequest;
import com.caucho.server.TcpServer;
import com.caucho.util.Alarm;
import com.caucho.util.CpuUsage;
import com.caucho.vfs.ClientDisconnectException;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.QSocket;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.net.InetAddress;

public class TcpConnection
extends Connection
implements Runnable {
    private static WriteStream dbg = LogStream.open("/caucho.com/tcp-server");
    private static WriteStream dbgPipe = LogStream.open("/caucho.com/server-disconnect");
    private Thread thread;
    private TcpServer server;
    private String virtualHost;
    private ServerRequest request;
    private QSocket _socket;
    private ReadStream readStream;
    private WriteStream writeStream;
    private int interruptCount;
    private boolean isClosed;
    private boolean isKeepalive;
    private CpuUsage cpuUsage;
    private CpuUsage baseUsage;
    private long accessTime;
    private long lastUsageTime;
    public static int connOpened;
    public static int connClosed;

    TcpConnection(TcpServer server, ServerRequest request) {
        this.server = server;
        this.request = request;
        this.readStream = new ReadStream();
        this.readStream.setReuseBuffer(true);
        this.writeStream = new WriteStream();
        this.writeStream.setReuseBuffer(true);
    }

    void setThread(Thread thread) {
        this.thread = thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block48: {
            Exception e4222;
            WriteStream ws;
            block46: {
                this.server.connectionHasStarted();
                this.thread = Thread.currentThread();
                this.isClosed = false;
                this.isKeepalive = false;
                this.request.init();
                QSocket socket = null;
                while (!this.isClosed && (socket = this.accept(socket)) != null) {
                    StreamImpl streamImpl = socket.getStream();
                    this.writeStream.init(streamImpl);
                    this.readStream.init(streamImpl, this.writeStream);
                    this._socket = socket;
                    this.request.handleConnection(this);
                    Object var4_7 = null;
                    this._socket = null;
                    try {
                        this.writeStream.close();
                        this.readStream.close();
                        continue;
                    }
                    finally {
                        socket.close();
                        continue;
                    }
                    {
                        catch (ClientDisconnectException e2) {
                            dbgPipe.log("[" + this.getId() + "] " + e2);
                            var4_7 = null;
                            this._socket = null;
                            try {
                                this.writeStream.close();
                                this.readStream.close();
                                continue;
                            }
                            finally {
                                socket.close();
                                continue;
                            }
                        }
                        catch (IOException e3) {
                            this.isClosed = true;
                            dbg.log("[" + this.getId() + "] " + e3);
                            dbg.log(e3);
                            var4_7 = null;
                            this._socket = null;
                            try {
                                this.writeStream.close();
                                this.readStream.close();
                                continue;
                            }
                            finally {
                                socket.close();
                                continue;
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        var4_7 = null;
                        this._socket = null;
                        try {
                            this.writeStream.close();
                            this.readStream.close();
                        }
                        finally {
                            socket.close();
                        }
                        throw throwable;
                    }
                }
                Object var7_13 = null;
                if (this.thread != null) {
                    this.thread.setContextClassLoader(null);
                }
                this.thread = null;
                if (this.isKeepalive) {
                    this.isKeepalive = false;
                    this.server.freeKeepalive();
                }
                this.server.stopConnection(this);
                this.request = null;
                this.server = null;
                ReadStream rs = this.readStream;
                this.readStream = null;
                ws = this.writeStream;
                this.writeStream = null;
                if (rs == null) break block46;
                rs.setReuseBuffer(false);
                try {
                    rs.close();
                }
                catch (Exception e4222) {
                    // empty catch block
                }
            }
            if (ws != null) {
                ws.setReuseBuffer(false);
                try {
                    ws.close();
                }
                catch (Exception e4222) {}
            }
            break block48;
            {
                catch (OutOfMemoryError e5) {
                    Exception e4222;
                    dbg.log(e5);
                    e5.printStackTrace(System.err);
                    this.server.close();
                    Object var7_14 = null;
                    if (this.thread != null) {
                        this.thread.setContextClassLoader(null);
                    }
                    this.thread = null;
                    if (this.isKeepalive) {
                        this.isKeepalive = false;
                        this.server.freeKeepalive();
                    }
                    this.server.stopConnection(this);
                    this.request = null;
                    this.server = null;
                    ReadStream rs = this.readStream;
                    this.readStream = null;
                    ws = this.writeStream;
                    this.writeStream = null;
                    if (rs != null) {
                        rs.setReuseBuffer(false);
                        try {
                            rs.close();
                        }
                        catch (Exception e4222) {
                            // empty catch block
                        }
                    }
                    if (ws != null) {
                        ws.setReuseBuffer(false);
                        try {
                            ws.close();
                        }
                        catch (Exception e4222) {}
                    }
                    break block48;
                }
                catch (Throwable e6) {
                    Exception e4222;
                    dbg.log(e6);
                    this.isClosed = true;
                    Object var7_15 = null;
                    if (this.thread != null) {
                        this.thread.setContextClassLoader(null);
                    }
                    this.thread = null;
                    if (this.isKeepalive) {
                        this.isKeepalive = false;
                        this.server.freeKeepalive();
                    }
                    this.server.stopConnection(this);
                    this.request = null;
                    this.server = null;
                    ReadStream rs = this.readStream;
                    this.readStream = null;
                    ws = this.writeStream;
                    this.writeStream = null;
                    if (rs != null) {
                        rs.setReuseBuffer(false);
                        try {
                            rs.close();
                        }
                        catch (Exception e4222) {
                            // empty catch block
                        }
                    }
                    if (ws != null) {
                        ws.setReuseBuffer(false);
                        try {
                            ws.close();
                        }
                        catch (Exception e4222) {}
                    }
                }
            }
            catch (Throwable throwable) {
                Exception e4222;
                Object var7_16 = null;
                if (this.thread != null) {
                    this.thread.setContextClassLoader(null);
                }
                this.thread = null;
                if (this.isKeepalive) {
                    this.isKeepalive = false;
                    this.server.freeKeepalive();
                }
                this.server.stopConnection(this);
                this.request = null;
                this.server = null;
                ReadStream rs = this.readStream;
                this.readStream = null;
                ws = this.writeStream;
                this.writeStream = null;
                if (rs != null) {
                    rs.setReuseBuffer(false);
                    try {
                        rs.close();
                    }
                    catch (Exception e4222) {
                        // empty catch block
                    }
                }
                if (ws != null) {
                    ws.setReuseBuffer(false);
                    try {
                        ws.close();
                    }
                    catch (Exception e4222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    private QSocket accept(QSocket oldSocket) {
        if (this.isKeepalive) {
            this.isKeepalive = false;
            this.server.freeKeepalive();
        }
        this.setAccessTime(-1L);
        long timeout = this.server.getSocketTimeout();
        QSocket socket = this.server.accept(oldSocket);
        try {
            if (socket != null && timeout > 0L) {
                socket.setSoTimeout((int)timeout);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.setAccessTime(Alarm.getCurrentTime());
        return socket;
    }

    public boolean isBusy() {
        return this.server.isBusy();
    }

    public int getBusyCount() {
        return this.server.getBusyCount();
    }

    public boolean allocateKeepalive() {
        if (!this.isKeepalive) {
            this.isKeepalive = this.server.allocateKeepalive();
        }
        return this.isKeepalive;
    }

    public void setAccessTime(long now) {
        super.setAccessTime(now);
        if (this.isKeepalive) {
            this.isKeepalive = false;
            this.server.freeKeepalive();
        }
    }

    void setSocket(QSocket socket) throws IOException {
        this._socket = socket;
    }

    public QSocket getSocket() {
        return this._socket;
    }

    void updateUsage(CpuUsage usage) {
    }

    public ServerRequest getRequest() {
        return this.request;
    }

    public ReadStream getReadStream() throws IOException {
        return this.readStream;
    }

    public WriteStream getWriteStream() throws IOException {
        return this.writeStream;
    }

    public boolean isSecure() {
        if (this._socket == null) {
            return false;
        }
        return this._socket.isSecure();
    }

    void setVirtualHost(String virtualHost) {
        this.virtualHost = virtualHost;
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    public InetAddress getLocalAddress() {
        try {
            return this._socket.getLocalAddress();
        }
        catch (Exception e) {
            try {
                return InetAddress.getLocalHost();
            }
            catch (Exception e1) {
                try {
                    return InetAddress.getByName("127.0.0.1");
                }
                catch (Exception e2) {
                    return null;
                }
            }
        }
    }

    public int getLocalPort() {
        return this._socket.getLocalPort();
    }

    public InetAddress getRemoteAddress() {
        return this._socket.getRemoteAddress();
    }

    public int getRemotePort() {
        return this._socket.getRemotePort();
    }

    Thread getThread() {
        return this.thread;
    }
}

