/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.server.http.VirtualHost;
import com.caucho.util.L10N;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class EarExpansion {
    static L10N L = new L10N(class$com$caucho$server$http$WarExpansion == null ? (class$com$caucho$server$http$WarExpansion = EarExpansion.class$("com.caucho.server.http.WarExpansion")) : class$com$caucho$server$http$WarExpansion);
    static WriteStream dbg = LogStream.open("/caucho.com/http/host/ear");
    static WriteStream earLog = LogStream.open("/log/http/ear");
    static WriteStream dbgLife = LogStream.open("/caucho.com/http/lifecycle");
    private VirtualHost host;
    private String[] earExpandFileNames = new String[0];
    static /* synthetic */ Class class$com$caucho$server$http$WarExpansion;

    EarExpansion(VirtualHost host) {
        this.host = host;
    }

    public Path getEarDir() {
        return this.host.getWarDir();
    }

    public Path getEarExpandDir() {
        return this.host.getWarExpandDir();
    }

    ArrayList initEarDir() throws Exception {
        ArrayList earNames = new ArrayList();
        Path earDir = this.getEarDir();
        if (!earDir.isDirectory()) {
            return earNames;
        }
        String[] list = earDir.list();
        for (int i = 0; i < list.length; ++i) {
            if (!list[i].endsWith(".ear")) continue;
            Path ear = earDir.lookup(list[i]);
            String tail = ear.getTail();
            int p = tail.lastIndexOf(46);
            if (p >= 0) {
                tail = tail.substring(0, p);
            }
            try {
                EarExpansion.expandEar(ear, earDir, tail);
                continue;
            }
            catch (Exception e) {
                this.host.log(e);
            }
        }
        return earNames;
    }

    static void expandEar(Path ear, Path warDir, String subpath) throws IOException {
        if (subpath == null) {
            subpath = ear.getTail();
            ear = ear.getParent();
        }
        String earName = subpath;
        Path expandDir = warDir;
        Path dependPath = warDir.lookup("WEB-INF/" + earName + "-ear.timestamp");
        Path earDir = expandDir.lookup("_" + earName);
        earDir.mkdirs();
        if (dependPath.canRead()) {
            try {
                ReadStream is = dependPath.openRead();
                ObjectInputStream ois = new ObjectInputStream(is);
                long lastModified = ois.readLong();
                long length = ois.readLong();
                ois.close();
                is.close();
                if (lastModified == ear.getLastModified() && length == ear.getLength()) {
                    return;
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        try {
            ZipEntry entry;
            earLog.log("expanding ear " + ear);
            expandDir.mkdirs();
            ReadStream rs = ear.openRead();
            ZipInputStream zis = new ZipInputStream(rs);
            byte[] buffer = new byte[1024];
            while ((entry = zis.getNextEntry()) != null) {
                int len;
                String name = entry.getName();
                Path path = null;
                if (name.equalsIgnoreCase("meta-inf/sun-j2ee-ri.xml")) {
                    path = expandDir.lookup("WEB-INF/" + earName + ".sun-j2ee-ri");
                } else if (name.equalsIgnoreCase("meta-inf/application.xml")) {
                    path = expandDir.lookup("WEB-INF/" + earName + ".ear");
                } else if (name.toLowerCase().endsWith(".war")) {
                    path = expandDir.lookup(name);
                } else if (name.toLowerCase().endsWith(".jar")) {
                    path = earDir.lookup("WEB-INF/lib").lookup(name);
                }
                if (path == null) continue;
                long length = entry.getSize();
                path.getParent().mkdirs();
                WriteStream os = path.openWrite();
                while ((len = zis.read(buffer, 0, buffer.length)) > 0) {
                    os.write(buffer, 0, len);
                }
                os.close();
            }
            zis.close();
            rs.close();
        }
        catch (IOException e) {
            dbg.log(e);
            return;
        }
        try {
            dependPath.getParent().mkdirs();
            WriteStream os = dependPath.openWrite();
            ObjectOutputStream oos = new ObjectOutputStream(os);
            oos.writeLong(ear.getLastModified());
            oos.writeLong(ear.getLength());
            oos.close();
            os.close();
        }
        catch (Throwable e) {
            dbg.log(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

