/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.Version;
import com.caucho.server.http.HttpRequest;
import com.caucho.server.http.Request;
import com.caucho.server.http.Response;
import com.caucho.util.Alarm;
import com.caucho.util.CharBuffer;
import com.caucho.util.CharSegment;
import com.caucho.util.QDate;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import javax.servlet.http.Cookie;

public class HttpResponse
extends Response {
    static byte[] http10ok = "HTTP/1.0 200 OK".getBytes();
    static byte[] http11ok = "HTTP/1.1 200 OK".getBytes();
    static byte[] contentLengthBytes = "\r\nContent-Length: ".getBytes();
    static byte[] headContentLengthBytes = "Content-Length: ".getBytes();
    static byte[] contentTypeBytes = "\r\nContent-Type: ".getBytes();
    static byte[] textHtmlBytes = "\r\nContent-Type: text/html".getBytes();
    static byte[] connectionCloseBytes = "\r\nConnection: close".getBytes();
    static byte[] resinServerBytes = ("\r\nServer: Resin/" + Version.VERSION).getBytes();
    static byte[] crlf = "\r\n".getBytes();
    static byte[] crlfcrlf = "\r\n\r\n".getBytes();
    static char[] connectionCb = "Connection".toCharArray();
    static CharBuffer closeCb = new CharBuffer("Close");
    HttpRequest req;
    private byte[] dateBuffer = new byte[256];
    private int dateBufferLength;
    private CharBuffer dateCharBuffer = new CharBuffer();
    private long lastDate;

    HttpResponse(Request request) {
        super(request);
        this.req = (HttpRequest)request;
    }

    public void switchToRaw() throws IOException {
        this.clearBuffer();
        this.setStatus(101);
        this.finish(false);
    }

    public WriteStream getRawOutput() throws IOException {
        return this.rawStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean writeHeadersInt(WriteStream os, int length) throws IOException {
        boolean isChunked = false;
        int version = this.req.getVersion();
        boolean debug = dbg.canWrite();
        if (version < 256) {
            this.allowKeepalive = false;
            return false;
        }
        int statusMajor = 2;
        if (this.statusCode == 200) {
            if (version >= 257) {
                os.write(http11ok, 0, http11ok.length);
            } else {
                os.write(http10ok, 0, http10ok.length);
            }
        } else {
            if (version >= 257) {
                os.print("HTTP/1.1 ");
            } else {
                os.print("HTTP/1.0 ");
            }
            statusMajor = this.statusCode / 100 % 10;
            os.write(statusMajor + 48);
            os.write(this.statusCode / 10 % 10 + 48);
            os.write(this.statusCode % 10 + 48);
            os.write(32);
            os.print(this.statusMessage);
        }
        if (debug) {
            if (version >= 257) {
                dbg.log(this.req.dbgId() + "HTTP/1.1 " + this.statusCode + " " + this.statusMessage);
            } else {
                dbg.log(this.req.dbgId() + "HTTP/1.0 " + this.statusCode + " " + this.statusMessage);
            }
        }
        if (!this.containsHeader("Server")) {
            os.write(resinServerBytes, 0, resinServerBytes.length);
        }
        if (this.isNoCache) {
            this.removeHeader("ETag");
            this.removeHeader("Last-Modified");
            this.setHeader("Expires", "Thu, 01 Dec 1994 16:00:00 GMT");
            os.print("\r\nCache-Control: no-cache");
            if (debug) {
                dbg.log(this.req.dbgId() + "" + "Expires: Thu, 01 Dec 1994 16:00:00 GMT");
            }
        } else if (this.isPrivateCache() && version == 257) {
            os.print("\r\nCache-Control: private");
            if (debug) {
                dbg.log(this.req.dbgId() + "Cache-Control: private");
            }
        }
        int size = this.headerKeys.size();
        for (int i = 0; i < size; ++i) {
            String key = (String)this.headerKeys.get(i);
            os.write(13);
            os.write(10);
            os.print(key);
            os.write(58);
            os.write(32);
            os.print((String)this.headerValues.get(i));
            if (!debug) continue;
            dbg.log(this.req.dbgId() + "" + key + ": " + this.headerValues.get(i));
        }
        long date = Alarm.getCurrentTime();
        for (int i = 0; i < this.cookiesOut.size(); ++i) {
            Cookie cookie = (Cookie)this.cookiesOut.get(i);
            int cookieVersion = cookie.getVersion();
            this.fillCookie(this.cb, cookie, date, 0);
            os.print("\r\nSet-Cookie: ");
            os.print(this.cb.getBuffer(), 0, this.cb.getLength());
            if (cookieVersion > 0) {
                this.fillCookie(this.cb, cookie, date, cookieVersion);
                os.print("\r\nSet-Cookie2: ");
                os.print(this.cb.getBuffer(), 0, this.cb.getLength());
            }
            if (!debug) continue;
            dbg.log(this.req.dbgId() + "Set-Cookie: " + this.cb);
        }
        if (this.contentType == "text/html") {
            os.write(textHtmlBytes, 0, textHtmlBytes.length);
            if (debug) {
                dbg.log(this.req.dbgId() + "Content-Type: text/html");
            }
        } else if (this.contentType != null) {
            os.write(contentTypeBytes, 0, contentTypeBytes.length);
            os.print(this.contentType);
            if (debug) {
                dbg.log(this.req.dbgId() + "Content-Type: " + this.contentType);
            }
        }
        boolean isHead = this.getResponseStream().isHead();
        boolean hasContentLength = false;
        if (this.statusCode == 204 || this.statusCode == 304) {
            hasContentLength = true;
        } else if (this.contentLength >= 0L) {
            os.write(contentLengthBytes, 0, contentLengthBytes.length);
            os.print(this.contentLength);
            hasContentLength = true;
            if (debug) {
                dbg.log(this.req.dbgId() + "Content-Length: " + this.contentLength);
            }
        } else if (length >= 0) {
            os.write(contentLengthBytes, 0, contentLengthBytes.length);
            os.print(length);
            hasContentLength = true;
            this.contentLength = length;
            if (debug) {
                dbg.log(this.req.dbgId() + "Content-Length: " + length);
            }
        }
        if (version < 257) {
            this.allowKeepalive = false;
        } else {
            CharSegment conn = this.req.getHeaderBuffer(connectionCb, connectionCb.length);
            if (conn != null && conn.equalsIgnoreCase(closeCb)) {
                this.allowKeepalive = false;
            } else if (!this.allowKeepalive || !this.req.conn.allocateKeepalive() && this.req.rawStream.getOffset() >= this.req.rawStream.getLength()) {
                os.write(connectionCloseBytes, 0, connectionCloseBytes.length);
                this.allowKeepalive = false;
                if (debug) {
                    dbg.log(this.req.dbgId() + "Connection: close");
                }
            }
        }
        if (version >= 257 && !hasContentLength) {
            os.print("\r\nTransfer-Encoding: chunked");
            isChunked = true;
            if (debug) {
                dbg.log(this.req.dbgId() + "Transfer-Encoding: chunked");
            }
        }
        if (this.lastDate + 1000L < date) {
            QDate qDate = this.calendar;
            synchronized (qDate) {
                if (this.lastDate + 1000L < date) {
                    this.lastDate = date;
                    this.calendar.calculate(date, false);
                    this.dateCharBuffer.clear();
                    this.dateCharBuffer.append("\r\nDate: ");
                    this.calendar.printDate(this.dateCharBuffer);
                    char[] cb = this.dateCharBuffer.getBuffer();
                    int len = this.dateCharBuffer.getLength();
                    for (int i = len - 1; i >= 0; --i) {
                        this.dateBuffer[i] = (byte)cb[i];
                    }
                    this.dateBuffer[len] = 13;
                    this.dateBuffer[len + 1] = 10;
                    this.dateBufferLength = len + 2;
                }
            }
        }
        os.write(this.dateBuffer, 0, this.dateBufferLength);
        if (!isHead || this.contentLength >= 0L) {
            os.write(crlf, 0, 2);
        }
        return isChunked;
    }

    protected void writeHeadFinish(WriteStream os, int length) throws IOException {
        os.write(headContentLengthBytes, 0, headContentLengthBytes.length);
        os.print(length);
        os.write(crlfcrlf, 0, 4);
    }
}

