/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.sql;

import com.caucho.sql.DBPool;
import com.caucho.sql.QPooledConnection;
import com.caucho.sql.XAExceptionWrapper;
import com.caucho.util.L10N;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.WriteStream;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class QXAConnection
extends QPooledConnection
implements XAConnection,
XAResource {
    protected static WriteStream dbg = LogStream.open("/caucho.com/sql/pool");
    protected static L10N L = new L10N("com/caucho/sql/messages");
    private boolean _autoCommit;
    private int _transactionUseCount;

    QXAConnection(DBPool pool, Connection conn) {
        super(pool, conn);
    }

    public XAResource getXAResource() {
        return this;
    }

    public boolean isSameRM(XAResource resource) throws XAException {
        return resource == this;
    }

    public void start(Xid xid, int flags) throws XAException {
        try {
            if (this._conn != null) {
                this._conn.setAutoCommit(false);
            }
            this._autoCommit = false;
        }
        catch (SQLException e) {
            throw new XAException(e.getLocalizedMessage());
        }
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        return false;
    }

    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    public void forget(Xid xid) throws XAException {
    }

    public int prepare(Xid xid) throws XAException {
        if (this._conn == null) {
            throw new XAException("invalid or broken connection");
        }
        return 0;
    }

    public void rollback(Xid xid) throws XAException {
        if (this._conn == null) {
            return;
        }
        XAExceptionWrapper xaExn = null;
        try {
            this._conn.rollback();
        }
        catch (SQLException e) {
            xaExn = new XAExceptionWrapper(e);
        }
        try {
            this._conn.setAutoCommit(true);
            this._autoCommit = true;
        }
        catch (SQLException e) {
            throw new XAExceptionWrapper(e);
        }
        if (xaExn != null) {
            throw xaExn;
        }
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        Connection conn = this._conn;
        if (conn == null) {
            return;
        }
        XAExceptionWrapper xaExn = null;
        try {
            conn.commit();
        }
        catch (SQLException e) {
            dbg.log(e);
            xaExn = new XAExceptionWrapper(e);
        }
        try {
            if (this._transactionUseCount == 0) {
                conn.setAutoCommit(true);
                this._autoCommit = true;
            } else {
                conn.setAutoCommit(true);
                this._autoCommit = true;
            }
        }
        catch (SQLException e) {
            throw new XAExceptionWrapper(e);
        }
        if (xaExn != null) {
            throw xaExn;
        }
    }

    public Xid[] recover(int flag) throws XAException {
        return null;
    }

    public void end(Xid xid, int flags) throws XAException {
    }
}

