/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.sql;

import com.caucho.sql.SQLExceptionWrapper;
import com.caucho.sql.UserConnectionAdapter;
import com.caucho.sql.XADataSourceAdapter;
import com.caucho.sql.XAExceptionWrapper;
import com.caucho.util.L10N;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.WriteStream;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class XAConnectionAdapter
implements XAConnection,
XAResource {
    protected static WriteStream dbg = LogStream.open("/caucho.com/sql/pool");
    protected static L10N L = new L10N("com/caucho/sql/messages");
    private XADataSourceAdapter _xaDataSource;
    private XAConnectionAdapter _xaDelegate;
    private XAConnectionAdapter _xaDelegateNext;
    private Connection _conn;
    private ConnectionEventListener _listener;
    private UserConnectionAdapter _userConn;
    private int _oldIsolation = -1;
    private int _isolation = -1;
    private Xid _xid;
    private boolean _autoCommit = true;
    private boolean _oldAutoCommit = true;

    XAConnectionAdapter(XADataSourceAdapter xaDataSource, Connection conn) {
        this._xaDataSource = xaDataSource;
        this._xaDelegate = this;
        this._conn = conn;
    }

    public XADataSourceAdapter getDataSource() {
        return this._xaDataSource;
    }

    public XAResource getXAResource() {
        return this;
    }

    Xid getXid() {
        return this._xid;
    }

    public Connection getConnection() throws SQLException {
        if (this._conn == null) {
            throw new SQLException("connection is closed");
        }
        UserConnectionAdapter userConn = this._userConn;
        this._userConn = null;
        try {
            if (userConn != null) {
                userConn.close();
            }
        }
        catch (SQLException e) {
            dbg.log(e);
        }
        this._userConn = new UserConnectionAdapter(this);
        return this._userConn;
    }

    final Connection getDriverConnection() {
        return this._xaDelegate._conn;
    }

    public void setIsolation(int isolation) throws SQLException {
        if (this._oldIsolation < 0) {
            this._oldIsolation = this._conn.getTransactionIsolation();
            this._isolation = isolation;
            this._conn.setTransactionIsolation(isolation);
        } else if (this._autoCommit) {
            this._isolation = isolation;
            this._conn.setTransactionIsolation(isolation);
        } else if (this._isolation < isolation) {
            throw new SQLException(L.l("can't change to more restrictive isolation in the middle of a transaction."));
        }
    }

    public void resetIsolation() throws SQLException {
        int oldIsolation = this._oldIsolation;
        this._isolation = -1;
        this._oldIsolation = -1;
        if (oldIsolation >= 0) {
            this._conn.setTransactionIsolation(oldIsolation);
        }
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        this._listener = listener;
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this._listener = null;
    }

    void fatalEvent() {
        if (this._listener != null) {
            ConnectionEvent event = new ConnectionEvent(this, new SQLException("foo"));
            this._listener.connectionErrorOccurred(event);
        }
    }

    void fatalEvent(Throwable exn) {
        if (this._listener != null) {
            ConnectionEvent event = new ConnectionEvent(this, SQLExceptionWrapper.create(exn));
            this._listener.connectionErrorOccurred(event);
        }
    }

    void closeEvent() {
        if (this._listener != null) {
            ConnectionEvent event = new ConnectionEvent(this);
            this._listener.connectionClosed(event);
        }
    }

    public boolean isSameRM(XAResource resource) throws XAException {
        if (!(resource instanceof XAConnectionAdapter)) {
            return false;
        }
        if (this._conn == null) {
            return false;
        }
        XAConnectionAdapter xaConn = (XAConnectionAdapter)resource;
        return this._xaDataSource.equals(xaConn._xaDataSource);
    }

    public void start(Xid xid, int flags) throws XAException {
        if (flags == 0x200000 && this._xid == null) {
            if (this._xaDelegate != this) {
                throw new IllegalStateException("pool delegate state exception");
            }
            XAConnectionAdapter delegate = this._xaDataSource.getXADelegate(xid);
            this._xaDelegate = delegate._xaDelegate;
            this._xaDelegateNext = this._xaDelegate._xaDelegateNext;
            this._xaDelegate._xaDelegateNext = this;
            if (dbg.canWrite()) {
                dbg.log("XA start: using delegate " + this._xaDelegate + " for XID " + xid);
            }
        }
        this._xid = xid;
        if (this._xaDelegate == this) {
            if (this._conn == null) {
                throw new XAException(L.l("Can't call XAResource.start on closed connection."));
            }
            try {
                if (this._autoCommit) {
                    this._conn.setAutoCommit(false);
                }
                this._autoCommit = false;
            }
            catch (SQLException e) {
                throw new XAException(e.getLocalizedMessage());
            }
        }
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        return false;
    }

    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    public void forget(Xid xid) throws XAException {
        if (this._xaDelegate != this) {
            this._xaDelegate.forget(xid);
            return;
        }
        this.clearXid();
    }

    public int prepare(Xid xid) throws XAException {
        if (this._xaDelegate != this) {
            return this._xaDelegate.prepare(xid);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(Xid xid) throws XAException {
        if (this._xaDelegate != this) {
            this._xaDelegate.rollback(xid);
            return;
        }
        try {
            if (this._conn == null) {
                return;
            }
            XAExceptionWrapper xaExn = null;
            try {
                this._conn.rollback();
            }
            catch (SQLException e) {
                xaExn = new XAExceptionWrapper(e);
            }
            try {
                this._conn.setAutoCommit(true);
                this._autoCommit = true;
            }
            catch (SQLException e) {
                throw new XAExceptionWrapper(e);
            }
            try {
                this.resetIsolation();
            }
            catch (SQLException e) {
                throw new XAExceptionWrapper(e);
            }
            if (xaExn != null) {
                throw xaExn;
            }
        }
        finally {
            this.clearXid();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (this._xaDelegate != this) {
            this._xaDelegate.commit(xid, onePhase);
            return;
        }
        try {
            if (this._conn == null) {
                return;
            }
            XAExceptionWrapper xaExn = null;
            try {
                this._conn.commit();
            }
            catch (SQLException e) {
                dbg.log(e);
                xaExn = new XAExceptionWrapper(e);
            }
            try {
                this._conn.setAutoCommit(this._oldAutoCommit);
                this._autoCommit = this._oldAutoCommit;
            }
            catch (SQLException e) {
                throw new XAExceptionWrapper(e);
            }
            try {
                this.resetIsolation();
            }
            catch (SQLException e) {
                throw new XAExceptionWrapper(e);
            }
            if (xaExn != null) {
                throw xaExn;
            }
        }
        finally {
            this.clearXid();
        }
    }

    private void clearXid() {
        XAConnectionAdapter ptr = this;
        while (ptr != null) {
            XAConnectionAdapter next = this._xaDelegateNext;
            ptr._xaDelegateNext = null;
            ptr._xaDelegate = ptr;
            ptr._xid = null;
            ptr = next;
        }
    }

    public Xid[] recover(int flag) throws XAException {
        return null;
    }

    public void end(Xid xid, int flags) throws XAException {
    }

    public void close() throws SQLException {
        this._xaDataSource.remove(this);
        Connection conn = this._conn;
        this._conn = null;
        if (conn != null) {
            conn.close();
        }
    }
}

