/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.el.ELParser;
import com.caucho.el.Expr;
import com.caucho.el.MapVariableResolver;
import com.caucho.el.StringLiteral;
import com.caucho.el.VariableResolver;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.util.InetNetwork;
import com.caucho.util.L10N;
import com.caucho.util.RegistryException;
import com.caucho.util.RegistryNode;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.beans.BeanInfo;
import java.beans.Beans;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public class BeanUtil {
    static WriteStream dbg = LogStream.open("/caucho.com/bean/util");
    static L10N L = new L10N(class$com$caucho$util$BeanUtil == null ? (class$com$caucho$util$BeanUtil = BeanUtil.class$("com.caucho.util.BeanUtil")) : class$com$caucho$util$BeanUtil);
    static /* synthetic */ Class class$com$caucho$util$BeanUtil;
    static /* synthetic */ Class class$com$caucho$util$RegistryNode;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$com$caucho$vfs$Path;
    static /* synthetic */ Class class$java$lang$String;

    public static Object createBean(RegistryNode node, HashMap variableMap, Path pwd) throws RegistryException {
        String className = node.getString("class-name", null);
        if (className == null) {
            throw BeanUtil.error(node, L.l("Bean create needs a `class-name' attribute"));
        }
        return BeanUtil.createBean(node, variableMap, pwd, className);
    }

    public static Object createBean(RegistryNode node, VariableResolver env) throws RegistryException {
        String className = node.getELString("class-name", null, env);
        if (className == null) {
            throw BeanUtil.error(node, L.l("Bean create needs a `class-name' attribute"));
        }
        Object obj = BeanUtil.instantiate(node, className);
        return BeanUtil.configure(obj, node, env, true, true, true);
    }

    public static Object createBean(RegistryNode node, VariableResolver env, boolean init) throws RegistryException {
        String className = node.getELString("class-name", null, env);
        if (className == null) {
            throw BeanUtil.error(node, L.l("Bean create needs a `class-name' attribute"));
        }
        Object obj = BeanUtil.instantiate(node, className);
        return BeanUtil.configure(obj, node, env, true, true, init);
    }

    public static Object createBean(RegistryNode node, HashMap variableMap, Path pwd, boolean init) throws RegistryException {
        String className = node.getString("class-name", null);
        if (className == null) {
            throw BeanUtil.error(node, L.l("Bean create needs a `class-name' attribute"));
        }
        return BeanUtil.createBean(node, variableMap, pwd, className, init);
    }

    public static Object createBean(RegistryNode node, HashMap variableMap, Path pwd, String className) throws RegistryException {
        if (className == null) {
            throw new NullPointerException();
        }
        Object obj = BeanUtil.instantiate(node, className);
        return BeanUtil.configure(obj, node, variableMap, pwd, true, true, true);
    }

    public static Object createBean(RegistryNode node, VariableResolver env, String className) throws RegistryException {
        if (className == null) {
            throw new NullPointerException();
        }
        Object obj = BeanUtil.instantiate(node, className);
        return BeanUtil.configure(obj, node, env, true, true, true);
    }

    public static Object createBean(RegistryNode node, HashMap variableMap, Path pwd, String className, boolean callInit) throws RegistryException {
        if (className == null) {
            throw new NullPointerException();
        }
        Object obj = BeanUtil.instantiate(node, className);
        return BeanUtil.configure(obj, node, variableMap, pwd, true, true, callInit);
    }

    public static Object createBean(RegistryNode node, VariableResolver env, String className, boolean callInit) throws RegistryException {
        if (className == null) {
            throw new NullPointerException();
        }
        Object obj = BeanUtil.instantiate(node, className);
        return BeanUtil.configure(obj, node, env, true, true, callInit);
    }

    public static Object instantiate(RegistryNode node, String className) throws RegistryException {
        Class cl;
        try {
            cl = CauchoSystem.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw BeanUtil.error(node, e);
        }
        if (!Modifier.isPublic(cl.getModifiers())) {
            throw BeanUtil.error(node, L.l("Custom bean `{0}' must be public.", className));
        }
        if (Modifier.isAbstract(cl.getModifiers())) {
            throw BeanUtil.error(node, L.l("Custom bean `{0}' must not be abstract.", className));
        }
        Object obj = null;
        try {
            return cl.newInstance();
        }
        catch (InstantiationException e) {
            throw BeanUtil.error(node, L.l("Can't create custom bean `{0}'.  The class must implement a public zero-arg constructor.", className));
        }
        catch (IllegalAccessException e) {
            throw BeanUtil.error(node, L.l("Can't create custom bean `{0}'.  Access denied.", className));
        }
        catch (Throwable e) {
            throw BeanUtil.error(node, L.l("Can't create custom bean `{0}'.  {1}.", (Object)className, e));
        }
    }

    public static Object configure(Object obj, RegistryNode config) throws RegistryException {
        return BeanUtil.configure(obj, config, null, null, true, true, true);
    }

    public static Object configureOptional(Object obj, RegistryNode config) throws RegistryException {
        return BeanUtil.configure(obj, config, null, null, true, false, true);
    }

    public static Object configure(Object obj, RegistryNode config, HashMap pathVariableMap, Path pwd, boolean allowImplicit, boolean isRequired, boolean callInit) throws RegistryException {
        if (pathVariableMap == null) {
            pathVariableMap = new HashMap<String, Path>();
        }
        MapVariableResolver resolver = new MapVariableResolver(pathVariableMap);
        Object oldPwd = pathVariableMap.get("resin:pwd");
        if (pwd != null) {
            pathVariableMap.put("resin:pwd", pwd);
        } else if (oldPwd == null) {
            pathVariableMap.put("resin:pwd", Vfs.lookup("."));
        }
        BeanUtil.configure(obj, config, resolver, allowImplicit, isRequired, callInit);
        if (oldPwd == null) {
            pathVariableMap.remove("resin:pwd");
        } else {
            pathVariableMap.put("resin:pwd", (Path)oldPwd);
        }
        return obj;
    }

    public static Object configure(Object obj, RegistryNode config, VariableResolver env, boolean callInit) throws RegistryException {
        return BeanUtil.configure(obj, config, env, true, true, callInit);
    }

    public static Object configure(Object obj, RegistryNode config, VariableResolver env, boolean allowImplicit, boolean isRequired, boolean callInit) throws RegistryException {
        block22: {
            try {
                BeanInfo info = Introspector.getBeanInfo(obj.getClass());
                if (config == null) {
                    return obj;
                }
                String initClass = config.getELString("init-class", null, env);
                if (initClass != null) {
                    String value;
                    String name;
                    Object names;
                    Map map;
                    RegistryNode initNode = config.lookup("init-class");
                    ClassLoader loader = CauchoSystem.getContextClassLoader();
                    Object initObject = Beans.instantiate(loader, initClass);
                    if (initObject instanceof Map) {
                        map = (Map)initObject;
                        names = map.keySet().iterator();
                        while (names.hasNext()) {
                            name = (String)names.next();
                            value = (String)map.get(name);
                            BeanUtil.setBeanProperty(obj, name, value, info, initNode, env, isRequired);
                        }
                    } else if (initObject instanceof Hashtable) {
                        map = (Hashtable)initObject;
                        names = ((Hashtable)map).keys();
                        while (names.hasMoreElements()) {
                            name = (String)names.nextElement();
                            value = (String)((Hashtable)map).get(name);
                            BeanUtil.setBeanProperty(obj, name, value, info, initNode, env, isRequired);
                        }
                    } else {
                        throw BeanUtil.error(initNode, L.l("`{0}' must be a Map", initClass));
                    }
                }
                Iterator iter = config.iterator();
                while (iter.hasNext()) {
                    String value;
                    RegistryNode subnode = (RegistryNode)iter.next();
                    String name = subnode.getName();
                    if (name.equals("init-param")) {
                        name = subnode.getString("param-name", null);
                        value = subnode.getString("param-value", null);
                        if (name != null || value != null) {
                            BeanUtil.setBeanProperty(obj, name, value, info, subnode, env, isRequired);
                            continue;
                        }
                        Iterator subiter = subnode.iterator();
                        while (subiter.hasNext()) {
                            RegistryNode paramNode = (RegistryNode)subiter.next();
                            BeanUtil.setBeanProperty(obj, paramNode.getName(), paramNode.getValue(), info, paramNode, env, isRequired);
                        }
                        continue;
                    }
                    if (!allowImplicit) continue;
                    value = subnode.getValue();
                    BeanUtil.setBeanProperty(obj, name, value, info, subnode, env, false);
                }
                try {
                    Class<?> cl = obj.getClass();
                    Method method = cl.getMethod("setRegistry", class$com$caucho$util$RegistryNode == null ? (class$com$caucho$util$RegistryNode = BeanUtil.class$("com.caucho.util.RegistryNode")) : class$com$caucho$util$RegistryNode);
                    if (method != null) {
                        method.invoke(obj, config);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (!callInit) break block22;
                Method method = null;
                try {
                    Class<?> cl = obj.getClass();
                    method = cl.getMethod("init", new Class[0]);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (method != null) {
                    method.invoke(obj, new Object[0]);
                }
            }
            catch (RegistryException e) {
                throw e;
            }
            catch (InvocationTargetException e) {
                throw BeanUtil.error(config, e.getTargetException());
            }
            catch (Exception e) {
                throw BeanUtil.error(config, e);
            }
        }
        return obj;
    }

    public static void setBeanProperty(Object obj, String name, String value) throws RegistryException {
        try {
            BeanInfo info = Introspector.getBeanInfo(obj.getClass());
            BeanUtil.setBeanProperty(obj, name, value, info, null, null, null, true);
        }
        catch (RegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RegistryException(e);
        }
    }

    public static void setBeanProperty(Object obj, String name, String stringValue, BeanInfo info, RegistryNode config, HashMap pathVariableMap, Path pwd, boolean isRequired) throws RegistryException {
        MapVariableResolver resolver = new MapVariableResolver(pathVariableMap);
        Object oldPwd = pathVariableMap.get("resin:pwd");
        if (pwd != null) {
            pathVariableMap.put("resin:pwd", pwd);
        } else if (oldPwd == null) {
            pathVariableMap.put("resin:pwd", Vfs.lookup("."));
        }
        BeanUtil.setBeanProperty(obj, name, stringValue, info, config, resolver, isRequired);
        pathVariableMap.put("resin:pwd", oldPwd);
    }

    public static void setBeanProperty(Object obj, String name, String stringValue, BeanInfo info, RegistryNode config, VariableResolver env, boolean isRequired) throws RegistryException {
        Expr expr;
        if (name == null) {
            throw BeanUtil.error(config, L.l("unknown name", name));
        }
        if (stringValue == null) {
            stringValue = "";
        }
        if (name.equals("res-ref-name") || name.equals("res-type")) {
            return;
        }
        String value = stringValue;
        try {
            expr = new ELParser(stringValue).parse();
        }
        catch (Exception e) {
            dbg.log(e);
            expr = new StringLiteral(stringValue);
        }
        try {
            name = BeanUtil.configToBeanName(name);
            Method method = BeanUtil.getSetMethod(info, name);
            if (method == null) {
                method = BeanUtil.getAddMethod(info.getBeanDescriptor().getBeanClass(), name);
            }
            if (method == null) {
                BeanUtil.setBeanPropertyMethod(obj, name, expr.evalString(env), config, isRequired);
                return;
            }
            Class<?> type = method.getParameterTypes()[0];
            String typeName = type.getName();
            if (typeName.equals("boolean") || typeName.equals("java.lang.Boolean")) {
                if (stringValue.equals("")) {
                    method.invoke(obj, Boolean.TRUE);
                } else {
                    method.invoke(obj, new Boolean(expr.evalBoolean(env)));
                }
            } else if (typeName.equals("int") || typeName.equals("java.lang.Integer")) {
                method.invoke(obj, new Integer((int)expr.evalLong(env)));
            } else if (typeName.equals("double") || typeName.equals("java.lang.Double")) {
                method.invoke(obj, new Double(expr.evalDouble(env)));
            } else if (Long.TYPE.equals(type) || (class$java$lang$Long == null ? (class$java$lang$Long = BeanUtil.class$("java.lang.Long")) : class$java$lang$Long).equals(type)) {
                long period = expr.evalPeriod(env);
                method.invoke(obj, new Long(period));
            } else if (typeName.equals("com.caucho.util.InetNetwork")) {
                InetNetwork network = RegistryNode.parseNetwork(expr.evalString(env));
                method.invoke(obj, network);
            } else if ((class$com$caucho$vfs$Path == null ? (class$com$caucho$vfs$Path = BeanUtil.class$("com.caucho.vfs.Path")) : class$com$caucho$vfs$Path).equals(type)) {
                Path pwd = (Path)env.get("resin:pwd");
                if (pwd == null) {
                    pwd = Vfs.lookup(".");
                }
                Path path = pwd.lookup(expr.evalString(env));
                method.invoke(obj, path);
            } else if ((class$java$lang$String == null ? (class$java$lang$String = BeanUtil.class$("java.lang.String")) : class$java$lang$String).equals(type)) {
                method.invoke(obj, expr.evalString(env));
            } else {
                method.invoke(obj, expr.evalObject(env));
            }
        }
        catch (RegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw BeanUtil.error(config, e);
        }
    }

    public static Path lookupPath(String pathName, HashMap varMap, Path pwd) {
        if (pwd == null) {
            pwd = Vfs.lookup();
        }
        if (pathName.startsWith("$")) {
            Object value;
            String suffix;
            String prefix;
            int p = pathName.indexOf(47);
            if (p > 0) {
                prefix = pathName.substring(1, p);
                suffix = pathName.substring(p + 1);
            } else {
                prefix = pathName.substring(1);
                suffix = null;
            }
            Object v0 = value = varMap != null ? varMap.get(prefix) : null;
            if (value instanceof Path) {
                pwd = value;
                pathName = suffix;
            }
        }
        if (pathName == null) {
            return pwd;
        }
        if (pathName.indexOf(36) < 0) {
            return pwd.lookup(pathName);
        }
        CharBuffer cb = CharBuffer.allocate();
        int head = 0;
        int tail = 0;
        while ((tail = pathName.indexOf(36, head)) >= 0) {
            String value;
            cb.append(pathName.substring(head, tail));
            if (tail + 1 == pathName.length()) {
                cb.append('$');
                continue;
            }
            char ch = pathName.charAt(tail + 1);
            if (ch >= '0' && ch <= '9') {
                for (head = tail + 1; head < pathName.length() && (ch = pathName.charAt(head)) >= '0' && ch <= '9'; ++head) {
                }
            } else {
                for (head = tail + 1; head < pathName.length() && (ch = pathName.charAt(head)) != '/' && ch != '\\' && ch != '$' && ch != ' '; ++head) {
                }
            }
            String key = pathName.substring(tail + 1, head);
            String string = value = varMap != null ? (String)varMap.get(key) : null;
            if (value == null) {
                value = System.getProperty(key);
            }
            if (value != null) {
                cb.append((Object)value);
                continue;
            }
            cb.append(pathName.substring(tail, head));
        }
        if (head > 0 && head < pathName.length()) {
            cb.append(pathName.substring(head));
        }
        return pwd.lookupNative(cb.close());
    }

    private static String configToBeanName(String name) {
        CharBuffer cb = CharBuffer.allocate();
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (ch == '-') {
                cb.append(Character.toUpperCase(name.charAt(++i)));
                continue;
            }
            cb.append(ch);
        }
        return cb.close();
    }

    private static Method getAddMethod(Class cl, String name) {
        name = "add" + name;
        Method[] methods = cl.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!Modifier.isPublic(methods[i].getModifiers()) || !name.equalsIgnoreCase(methods[i].getName()) || methods[i].getParameterTypes().length != 1) continue;
            return methods[i];
        }
        return null;
    }

    private static void setBeanPropertyMethod(Object obj, String name, String value, RegistryNode node, boolean isRequired) throws Exception {
        Method[] methods = obj.getClass().getMethods();
        Class[] params = new Class[]{class$java$lang$String == null ? (class$java$lang$String = BeanUtil.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = BeanUtil.class$("java.lang.String")) : class$java$lang$String};
        Method method = BeanUtil.getMethod(methods, "setProperty", params);
        if (method == null) {
            method = BeanUtil.getMethod(methods, "setAttribute", params);
        }
        if (method == null) {
            method = BeanUtil.getMethod(methods, "put", params);
        }
        if (method == null) {
            method = BeanUtil.getMethod(methods, "set", params);
        }
        if (method != null) {
            method.invoke(obj, name, value);
        } else if (isRequired) {
            throw BeanUtil.error(node, L.l("can't set property {0} on {1}", (Object)name, obj.getClass()));
        }
    }

    private static Method getMethod(Method[] methods, String name) {
        Method method = null;
        for (int i = 0; i < methods.length; ++i) {
            method = methods[i];
            if (!Modifier.isPublic(method.getModifiers()) || !Modifier.isPublic(method.getDeclaringClass().getModifiers()) || !method.getName().equals(name)) continue;
            return method;
        }
        return null;
    }

    private static Method getMethod(Method[] methods, String name, Class[] params) {
        Method method = null;
        block0: for (int i = 0; i < methods.length; ++i) {
            Class<?>[] actual;
            method = methods[i];
            if (!Modifier.isPublic(method.getModifiers()) || !Modifier.isPublic(method.getDeclaringClass().getModifiers()) || !method.getName().equals(name) || (actual = method.getParameterTypes()).length != params.length) continue;
            for (int j = 0; j < actual.length; ++j) {
                if (!actual[j].isAssignableFrom(params[j])) continue block0;
            }
            return method;
        }
        return null;
    }

    public static Method getSetMethod(BeanInfo info, String propertyName) {
        PropertyDescriptor[] pds = info.getPropertyDescriptors();
        Method method = null;
        for (int i = 0; i < pds.length; ++i) {
            if (!pds[i].getName().equals(propertyName) || pds[i].getWriteMethod() == null || !(method = pds[i].getWriteMethod()).getParameterTypes()[0].equals(class$java$lang$String == null ? BeanUtil.class$("java.lang.String") : class$java$lang$String)) continue;
            return method;
        }
        if (method != null) {
            return method;
        }
        return BeanUtil.getSetMethod(info.getBeanDescriptor().getBeanClass(), propertyName);
    }

    public static Method getSetMethod(Class cl, String propertyName) {
        Method method = BeanUtil.getSetMethod(cl, propertyName, false);
        if (method != null) {
            return method;
        }
        return BeanUtil.getSetMethod(cl, propertyName, true);
    }

    public static Method getSetMethod(Class cl, String propertyName, boolean ignoreCase) {
        String setName = "set" + BeanUtil.propertyNameToMethodName(propertyName);
        Method bestMethod = null;
        for (Class ptrCl = cl; ptrCl != null; ptrCl = ptrCl.getSuperclass()) {
            Method method = BeanUtil.getSetMethod(ptrCl.getMethods(), setName, ignoreCase);
            if (method != null && method.getParameterTypes()[0].equals(class$java$lang$String == null ? BeanUtil.class$("java.lang.String") : class$java$lang$String)) {
                return method;
            }
            if (method == null) continue;
            bestMethod = method;
        }
        if (bestMethod != null) {
            return bestMethod;
        }
        Class<?>[] interfaces = cl.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Method method = BeanUtil.getSetMethod(interfaces[i].getMethods(), setName, ignoreCase);
            if (method != null && method.getParameterTypes()[0].equals(class$java$lang$String == null ? BeanUtil.class$("java.lang.String") : class$java$lang$String)) {
                return method;
            }
            if (method == null) continue;
            bestMethod = method;
        }
        if (bestMethod != null) {
            return bestMethod;
        }
        return null;
    }

    private static Method getSetMethod(Method[] methods, String setName, boolean ignoreCase) {
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!ignoreCase && !method.getName().equals(setName) || ignoreCase && !method.getName().equalsIgnoreCase(setName) || !Modifier.isPublic(method.getModifiers()) || !Modifier.isPublic(method.getDeclaringClass().getModifiers()) || method.getParameterTypes().length != 1 || !method.getReturnType().equals(Void.TYPE)) continue;
            return method;
        }
        return null;
    }

    public static Method getGetMethod(BeanInfo info, String propertyName) {
        PropertyDescriptor[] pds = info.getPropertyDescriptors();
        for (int i = 0; i < pds.length; ++i) {
            if (!pds[i].getName().equals(propertyName) || pds[i].getReadMethod() == null || !Modifier.isPublic(pds[i].getReadMethod().getDeclaringClass().getModifiers())) continue;
            return pds[i].getReadMethod();
        }
        return BeanUtil.getGetMethod(info.getBeanDescriptor().getBeanClass(), propertyName);
    }

    public static Method getGetMethod(Class cl, String propertyName) {
        Method method = BeanUtil.getGetMethod(cl, propertyName, false);
        if (method != null) {
            return method;
        }
        return BeanUtil.getGetMethod(cl, propertyName, true);
    }

    public static Method getGetMethod(Class cl, String propertyName, boolean ignoreCase) {
        String getName = "get" + BeanUtil.propertyNameToMethodName(propertyName);
        String isName = "is" + BeanUtil.propertyNameToMethodName(propertyName);
        for (Class ptrCl = cl; ptrCl != null; ptrCl = ptrCl.getSuperclass()) {
            Method method = BeanUtil.getGetMethod(ptrCl.getMethods(), getName, isName, ignoreCase);
            if (method == null) continue;
            return method;
        }
        Class<?>[] interfaces = cl.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Method method = BeanUtil.getGetMethod(interfaces[i].getMethods(), getName, isName, ignoreCase);
            if (method == null) continue;
            return method;
        }
        return null;
    }

    private static Method getGetMethod(Method[] methods, String getName, String isName, boolean ignoreCase) {
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!Modifier.isPublic(method.getModifiers()) || !Modifier.isPublic(method.getDeclaringClass().getModifiers()) || method.getParameterTypes().length != 0 || method.getReturnType().equals(Void.TYPE)) continue;
            if (!ignoreCase && methods[i].getName().equals(getName)) {
                return methods[i];
            }
            if (ignoreCase && methods[i].getName().equalsIgnoreCase(getName)) {
                return methods[i];
            }
            if (!methods[i].getReturnType().equals(Boolean.TYPE)) continue;
            if (!ignoreCase && methods[i].getName().equals(isName)) {
                return methods[i];
            }
            if (!ignoreCase || !methods[i].getName().equalsIgnoreCase(isName)) continue;
            return methods[i];
        }
        return null;
    }

    public static String propertyNameToMethodName(String propertyName) {
        char ch = propertyName.charAt(0);
        if (Character.isLowerCase(ch)) {
            propertyName = Character.toUpperCase(ch) + propertyName.substring(1);
        }
        return propertyName;
    }

    public static String methodNameToPropertyName(BeanInfo info, String methodName) {
        PropertyDescriptor[] pds = info.getPropertyDescriptors();
        for (int i = 0; i < pds.length; ++i) {
            if (pds[i].getReadMethod() != null && pds[i].getReadMethod().getName().equals(methodName)) {
                return pds[i].getName();
            }
            if (pds[i].getWriteMethod() == null || !pds[i].getWriteMethod().getName().equals(methodName)) continue;
            return pds[i].getName();
        }
        return BeanUtil.methodNameToPropertyName(methodName);
    }

    public static String methodNameToPropertyName(String methodName) {
        if (methodName.startsWith("get")) {
            methodName = methodName.substring(3);
        } else if (methodName.startsWith("set")) {
            methodName = methodName.substring(3);
        } else if (methodName.startsWith("is")) {
            methodName = methodName.substring(2);
        }
        if (methodName.length() == 0) {
            return null;
        }
        char ch = methodName.charAt(0);
        if (Character.isUpperCase(ch) && (methodName.length() == 1 || !Character.isUpperCase(methodName.charAt(1)))) {
            methodName = Character.toLowerCase(ch) + methodName.substring(1);
        }
        return methodName;
    }

    private static RegistryException error(RegistryNode node, String msg) {
        if (node == null) {
            return new RegistryException(msg);
        }
        return new RegistryException(node.getFilename() + ":" + node.getLine() + ": " + msg);
    }

    private static RegistryException error(RegistryNode node, Throwable e) {
        if (e instanceof RegistryException) {
            return (RegistryException)e;
        }
        if (node == null) {
            return new RegistryException(String.valueOf(e), e);
        }
        return new RegistryException(node.getFilename() + ":" + node.getLine() + ": " + String.valueOf(e), e);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

