/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.DynamicClassLoader;

public class ClassLoaderLocal {
    private static int varCount;
    private String varName;
    private Object globalValue;
    private ClassLoader lastLoader;
    private Object lastValue;

    public ClassLoaderLocal() {
        this.varName = String.valueOf(varCount++);
    }

    public ClassLoaderLocal(String varName) {
        this.varName = varName;
    }

    public String getVariable() {
        return this.varName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get() {
        Thread thread = Thread.currentThread();
        ClassLoaderLocal classLoaderLocal = this;
        synchronized (classLoaderLocal) {
            ClassLoader loader;
            if (loader == this.lastLoader) {
                return this.lastValue;
            }
            this.lastLoader = loader;
            for (loader = thread.getContextClassLoader(); loader != null; loader = loader.getParent()) {
                if (!(loader instanceof DynamicClassLoader)) continue;
                DynamicClassLoader dynLoader = (DynamicClassLoader)loader;
                this.lastValue = dynLoader.getAttribute(this.varName);
                if (this.lastValue == null) continue;
                return this.lastValue;
            }
            this.lastValue = this.globalValue;
            return this.lastValue;
        }
    }

    public Object getLevel() {
        Thread thread = Thread.currentThread();
        for (ClassLoader loader = thread.getContextClassLoader(); loader != null; loader = loader.getParent()) {
            if (!(loader instanceof DynamicClassLoader)) continue;
            DynamicClassLoader dynLoader = (DynamicClassLoader)loader;
            return dynLoader.getLevelAttribute(this.varName);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(Object value) {
        Thread thread = Thread.currentThread();
        ClassLoaderLocal classLoaderLocal = this;
        synchronized (classLoaderLocal) {
            this.lastLoader = null;
            this.lastValue = null;
            for (ClassLoader loader = thread.getContextClassLoader(); loader != null; loader = loader.getParent()) {
                if (!(loader instanceof DynamicClassLoader)) continue;
                DynamicClassLoader dynLoader = (DynamicClassLoader)loader;
                dynLoader.setAttribute(this.varName, value);
                return;
            }
            this.globalValue = value;
        }
    }

    public void setGlobal(Object value) {
        this.globalValue = value;
    }

    public Object getGlobal() {
        return this.globalValue;
    }
}

