/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.Alarm;
import com.caucho.util.CronListener;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.WriteStream;
import java.util.ArrayList;

public class Cron {
    private static WriteStream dbg;
    private static CronThread cronThread;
    private static ArrayList waiting;
    private CronListener listener;
    private String name;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cron(CronListener listener, String name) {
        this.listener = listener;
        this.name = "cron";
        if (cronThread == null) {
            waiting = new ArrayList();
            ArrayList arrayList = waiting;
            synchronized (arrayList) {
                cronThread = new CronThread();
                cronThread.start();
            }
        }
        this.queue();
    }

    public Cron(CronListener listener) {
        this(listener, "cron");
    }

    public CronListener getListener() {
        return this.listener;
    }

    public void setListener(CronListener listener) {
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queue() {
        CronThread cronThread = Cron.cronThread;
        synchronized (cronThread) {
            waiting.remove(this);
            waiting.add(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dequeue() {
        CronThread cronThread = Cron.cronThread;
        synchronized (cronThread) {
            waiting.remove(this);
        }
    }

    public void close() {
        this.dequeue();
        this.listener = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setTestTime(long time) {
        if (cronThread != null) {
            CronThread cronThread = Cron.cronThread;
            synchronized (cronThread) {
                Cron.cronThread.evaluateCron(new ArrayList());
            }
        }
    }

    public String toString() {
        return "[Cron " + this.name + "]";
    }

    private static class CronThread
    extends Thread {
        public void run() {
            ArrayList runnable = new ArrayList();
            while (true) {
                this.evaluateCron(runnable);
                long now = Alarm.getCurrentTime();
                long delta = 61000L - now % 60000L;
                if (delta < 1000L || delta > 60000L) {
                    delta = 60000L;
                }
                try {
                    Thread.sleep(delta);
                }
                catch (Throwable e) {
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void evaluateCron(ArrayList runnable) {
            runnable.clear();
            CronThread cronThread = this;
            synchronized (cronThread) {
                for (int i = 0; i < waiting.size(); ++i) {
                    Cron cron = (Cron)waiting.get(i);
                    runnable.add(cron);
                }
                waiting.clear();
            }
            for (int i = 0; i < runnable.size(); ++i) {
                Cron cron = (Cron)runnable.get(i);
                if (cron == null || cron.listener == null) continue;
                try {
                    cron.listener.handleCron(cron);
                    continue;
                }
                catch (Throwable e) {
                    if (dbg == null) {
                        dbg = LogStream.open("/caucho.com/util/cron");
                    }
                    dbg.log(e);
                }
            }
        }

        CronThread() {
            super("resin-cron");
            this.setDaemon(true);
        }
    }
}

