/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.CharBuffer;
import com.caucho.vfs.i18n.EncodingReader;
import com.caucho.vfs.i18n.EncodingWriter;
import com.caucho.vfs.i18n.JDKReader;
import com.caucho.vfs.i18n.JDKWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;

public class Encoding {
    static HashMap javaName;
    static Hashtable mimeName;
    static HashMap localeName;
    static HashMap readEncodingFactories;
    static HashMap writeEncodingFactories;

    private Encoding() {
    }

    public static String getMimeName(String encoding) {
        if (encoding == null) {
            return null;
        }
        String value = (String)mimeName.get(encoding);
        if (value != null) {
            return value;
        }
        String upper = Encoding.normalize(encoding);
        String lookup = (String)mimeName.get(upper);
        value = lookup == null ? upper : lookup;
        mimeName.put(encoding, value);
        return value;
    }

    public static String getMimeName(Locale locale) {
        if (locale == null) {
            return "ISO-8859-1";
        }
        String mimeName = (String)localeName.get(locale.toString());
        if (mimeName == null) {
            mimeName = (String)localeName.get(locale.getLanguage());
        }
        if (mimeName == null) {
            return "ISO-8859-1";
        }
        return mimeName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Reader getReadEncoding(InputStream is, String encoding) throws UnsupportedEncodingException {
        EncodingReader factory = null;
        HashMap hashMap = readEncodingFactories;
        synchronized (hashMap) {
            factory = (EncodingReader)readEncodingFactories.get(encoding);
            if (factory == null) {
                String javaEncoding;
                try {
                    javaEncoding = Encoding.getJavaName(encoding);
                    if (javaEncoding == null) {
                        javaEncoding = "ISO8859_1";
                    }
                    String className = "com.caucho.vfs.i18n." + javaEncoding + "Reader";
                    Class<?> cl = Class.forName(className);
                    factory = (EncodingReader)cl.newInstance();
                    factory.setJavaEncoding(javaEncoding);
                }
                catch (Throwable e) {
                    // empty catch block
                }
                if (factory == null) {
                    javaEncoding = Encoding.getJavaName(encoding);
                    if (javaEncoding == null) {
                        javaEncoding = "ISO8859_1";
                    }
                    factory = new JDKReader();
                    factory.setJavaEncoding(javaEncoding);
                }
                readEncodingFactories.put(encoding, factory);
            }
        }
        return factory.create(is, factory.getJavaEncoding());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Writer getWriteEncoding(OutputStream os, String encoding) {
        EncodingWriter factory = null;
        HashMap hashMap = writeEncodingFactories;
        synchronized (hashMap) {
            factory = (EncodingWriter)writeEncodingFactories.get(encoding);
            if (factory == null) {
                String javaEncoding;
                try {
                    javaEncoding = Encoding.getJavaName(encoding);
                    if (javaEncoding == null) {
                        javaEncoding = "ISO8859_1";
                    }
                    String className = "com.caucho.vfs.i18n." + javaEncoding + "Writer";
                    Class<?> cl = Class.forName(className);
                    factory = (EncodingWriter)cl.newInstance();
                    factory.setJavaEncoding(javaEncoding);
                }
                catch (Throwable e) {
                    // empty catch block
                }
                if (factory == null) {
                    factory = new JDKWriter();
                    javaEncoding = Encoding.getJavaName(encoding);
                    if (javaEncoding == null) {
                        javaEncoding = "ISO8859_1";
                    }
                    factory.setJavaEncoding(javaEncoding);
                }
                writeEncodingFactories.put(encoding, factory);
            }
        }
        return factory.create(os, factory.getJavaEncoding());
    }

    public static String getJavaName(String encoding) {
        if (encoding == null) {
            return null;
        }
        String upper = Encoding.normalize(encoding);
        String javaName = null;
        javaName = (String)Encoding.javaName.get(upper);
        if (javaName != null) {
            return javaName;
        }
        String lookup = (String)mimeName.get(upper);
        if (lookup != null) {
            javaName = (String)Encoding.javaName.get(lookup);
        }
        return javaName == null ? upper : javaName;
    }

    public static String getJavaName(Locale locale) {
        if (locale == null) {
            return null;
        }
        return Encoding.getJavaName(Encoding.getMimeName(locale));
    }

    private static String normalize(String name) {
        CharBuffer cb = CharBuffer.allocate();
        int len = name.length();
        for (int i = 0; i < len; ++i) {
            char ch = name.charAt(i);
            if (Character.isLowerCase(ch)) {
                cb.append(Character.toUpperCase(ch));
                continue;
            }
            if (ch == '_') {
                cb.append('-');
                continue;
            }
            cb.append(ch);
        }
        return cb.close();
    }

    static {
        readEncodingFactories = new HashMap();
        writeEncodingFactories = new HashMap();
        javaName = new HashMap();
        mimeName = new Hashtable();
        localeName = new HashMap();
        mimeName.put("ANSI-X3.4-1968", "US-ASCII");
        mimeName.put("ISO-IR-6", "US-ASCII");
        mimeName.put("ISO-646.IRV:1991", "US-ASCII");
        mimeName.put("ASCII", "US-ASCII");
        mimeName.put("ISO646-US", "US-ASCII");
        mimeName.put("US-ASCII", "US-ASCII");
        mimeName.put("us", "US-ASCII");
        mimeName.put("IBM367", "US-ASCII");
        mimeName.put("CP367", "US-ASCII");
        mimeName.put("CSASCII", "US-ASCII");
        javaName.put("US-ASCII", "ISO8859_1");
        mimeName.put("ISO-2022-KR", "ISO-2022-KR");
        mimeName.put("CSISO2022KR", "ISO-2022-KR");
        mimeName.put("ISO2022-KR", "ISO-2022-KR");
        javaName.put("ISO-2022-KR", "ISO2022_KR");
        mimeName.put("EUC-KR", "EUC-KR");
        mimeName.put("CSEUCKR", "EUC-KR");
        javaName.put("EUC-KR", "EUC_KR");
        mimeName.put("ISO-2022-JP", "ISO-2022-JP");
        mimeName.put("CSISO2022JP", "ISO-2022-JP");
        mimeName.put("ISO2022-JP", "ISO-2022-JP");
        javaName.put("ISO-2022-JP", "ISO2022JP");
        mimeName.put("ISO-2022-JP-2", "ISO-2022-JP-2");
        mimeName.put("CSISO2022JP2", "ISO-2022-JP-2");
        mimeName.put("ISO2022-JP2", "ISO-2022-JP-2");
        javaName.put("ISO-2022-JP-2", "ISO2022_JP2");
        mimeName.put("ISO_8859-1:1987", "ISO-8859-1");
        mimeName.put("ISO-IR-100", "ISO-8859-1");
        mimeName.put("ISO-8859-1", "ISO-8859-1");
        mimeName.put("LATIN1", "ISO-8859-1");
        mimeName.put("LATIN-1", "ISO-8859-1");
        mimeName.put("L1", "ISO-8859-1");
        mimeName.put("IBM819", "ISO-8859-1");
        mimeName.put("CP819", "ISO-8859-1");
        mimeName.put("CSISOLATIN1", "ISO-8859-1");
        mimeName.put("ISO8859-1", "ISO-8859-1");
        mimeName.put("8859-1", "ISO-8859-1");
        mimeName.put("8859_1", "ISO-8859-1");
        javaName.put("ISO-8859-1", "ISO8859_1");
        mimeName.put("ISO-8859-2:1987", "ISO-8859-2");
        mimeName.put("ISO-IR-101", "ISO-8859-2");
        mimeName.put("ISO-8859-2", "ISO-8859-2");
        mimeName.put("LATIN2", "ISO-8859-2");
        mimeName.put("LATIN-2", "ISO-8859-2");
        mimeName.put("L2", "ISO-8859-2");
        mimeName.put("CSISOLATIN2", "ISO-8859-2");
        mimeName.put("ISO8859-2", "ISO-8859-2");
        javaName.put("ISO-8859-2", "ISO8859_2");
        mimeName.put("ISO-8859-3:1988", "ISO-8859-3");
        mimeName.put("ISO-IR-109", "ISO-8859-3");
        mimeName.put("ISO-8859-3", "ISO-8859-3");
        mimeName.put("ISO-8859-3", "ISO-8859-3");
        mimeName.put("LATIN3", "ISO-8859-3");
        mimeName.put("LATIN-3", "ISO-8859-3");
        mimeName.put("L3", "ISO-8859-3");
        mimeName.put("CSISOLATIN3", "ISO-8859-3");
        mimeName.put("ISO8859-3", "ISO-8859-3");
        javaName.put("ISO-8859-3", "ISO8859_3");
        mimeName.put("ISO-8859-4:1988", "ISO-8859-4");
        mimeName.put("ISO-IR-110", "ISO-8859-4");
        mimeName.put("ISO-8859-4", "ISO-8859-4");
        mimeName.put("ISO-8859-4", "ISO-8859-4");
        mimeName.put("LATIN4", "ISO-8859-4");
        mimeName.put("LATIN-4", "ISO-8859-4");
        mimeName.put("L4", "ISO-8859-4");
        mimeName.put("CSISOLATIN4", "ISO-8859-4");
        mimeName.put("ISO8859-4", "ISO-8859-4");
        javaName.put("ISO-8859-4", "ISO8859_4");
        mimeName.put("ISO-8859-5:1988", "ISO-8859-5");
        mimeName.put("ISO-IR-144", "ISO-8859-5");
        mimeName.put("ISO-8859-5", "ISO-8859-5");
        mimeName.put("ISO-8859-5", "ISO-8859-5");
        mimeName.put("CYRILLIC", "ISO-8859-5");
        mimeName.put("CSISOLATINCYRILLIC", "ISO-8859-5");
        mimeName.put("ISO8859-5", "ISO-8859-5");
        javaName.put("ISO-8859-5", "ISO8859_5");
        mimeName.put("ISO-8859-6:1987", "ISO-8859-6");
        mimeName.put("ISO-IR-127", "ISO-8859-6");
        mimeName.put("ISO-8859-6", "ISO-8859-6");
        mimeName.put("ISO-8859-6", "ISO-8859-6");
        mimeName.put("ECMA-114", "ISO-8859-6");
        mimeName.put("ASMO-708", "ISO-8859-6");
        mimeName.put("ARABIC", "ISO-8859-6");
        mimeName.put("CSISOLATINARABIC", "ISO-8859-6");
        mimeName.put("ISO8859-6", "ISO-8859-6");
        javaName.put("ISO-8859-6", "ISO8859_6");
        mimeName.put("ISO-8859-7:1987", "ISO-8859-7");
        mimeName.put("ISO-IR-126", "ISO-8859-7");
        mimeName.put("ISO-8859-7", "ISO-8859-7");
        mimeName.put("ISO-8859-7", "ISO-8859-7");
        mimeName.put("ELOT-928", "ISO-8859-7");
        mimeName.put("ECMA-118", "ISO-8859-7");
        mimeName.put("GREEK", "ISO-8859-7");
        mimeName.put("GREEK8", "ISO-8859-7");
        mimeName.put("CSISOLATINGREEN", "ISO-8859-7");
        mimeName.put("ISO8859-7", "ISO-8859-7");
        javaName.put("ISO-8859-7", "ISO8859_7");
        mimeName.put("ISO-8859-8:1988", "ISO-8859-8");
        mimeName.put("ISO-IR-138", "ISO-8859-8");
        mimeName.put("ISO-8859-8", "ISO-8859-8");
        mimeName.put("ISO-8859-8", "ISO-8859-8");
        mimeName.put("HEBREW", "ISO-8859-8");
        mimeName.put("CSISOLATINHEBREW", "ISO-8859-8");
        mimeName.put("ISO8859-8", "ISO-8859-8");
        javaName.put("ISO-8859-8", "ISO8859_8");
        mimeName.put("ISO-8859-9:1989", "ISO-8859-9");
        mimeName.put("ISO-IR-148", "ISO-8859-9");
        mimeName.put("ISO-8859-9", "ISO-8859-9");
        mimeName.put("ISO-8859-9", "ISO-8859-9");
        mimeName.put("LATIN5", "ISO-8859-9");
        mimeName.put("LATIN-5", "ISO-8859-9");
        mimeName.put("L5", "ISO-8859-9");
        mimeName.put("CSISOLATIN5", "ISO-8859-9");
        mimeName.put("ISO8859-9", "ISO-8859-9");
        javaName.put("ISO-8859-9", "ISO8859_9");
        mimeName.put("UTF-7", "UTF-7");
        mimeName.put("UTF7", "UTF-7");
        javaName.put("UTF-7", "UTF7");
        mimeName.put("UTF-8", "UTF-8");
        mimeName.put("UTF8", "UTF-8");
        javaName.put("UTF-8", "UTF8");
        mimeName.put("UTF-16", "UTF-16");
        mimeName.put("UTF16", "UTF-16");
        javaName.put("UTF-16", "UTF16");
        mimeName.put("UTF-16-REV", "UTF-16-REV");
        mimeName.put("UTF16-REV", "UTF-16-REV");
        javaName.put("UTF-16-REV", "UTF16_REV");
        mimeName.put("JIS-ENCODING", "JIS_Encoding");
        mimeName.put("JIS-ENCODING", "JIS_Encoding");
        mimeName.put("CSJISENCODING", "JIS_Encoding");
        javaName.put("JIS_Encoding", "JIS_ENCODING");
        mimeName.put("SHIFT-JIS", "Shift_JIS");
        mimeName.put("SHIFT_JIS", "Shift_JIS");
        mimeName.put("CSSHIFTJIS", "Shift_JIS");
        mimeName.put("SJIS", "Shift_JIS");
        javaName.put("Shift_JIS", "SJIS");
        mimeName.put("EUC-JP", "EUC-JP");
        mimeName.put("EUC-JP", "EUC-JP");
        mimeName.put("EUCJP", "EUC-JP");
        mimeName.put("EUC-JP-LINUX", "EUC-JP");
        javaName.put("EUC-JP", "EUC_JP");
        mimeName.put("GB2312", "GB2312");
        mimeName.put("CSGB2312", "GB2312");
        javaName.put("GB2312", "GB2312");
        mimeName.put("GBK", "GBK");
        javaName.put("GBK", "GBK");
        mimeName.put("BIG5", "Big5");
        mimeName.put("BIG-5", "Big5");
        mimeName.put("CSBIG5", "Big5");
        javaName.put("Big5", "BIG5");
        mimeName.put("KOI8-R", "KOI8-R");
        mimeName.put("KOI-8-R", "KOI8-R");
        mimeName.put("KOI8-R", "KOI8-R");
        javaName.put("KOI8-R", "KOI8_R");
        mimeName.put("MS950", "ms950");
        javaName.put("ms950", "MS950");
        javaName.put("JAVA", "JAVA");
        mimeName.put("windows-hack", "ISO-8859-1");
        mimeName.put("WINDOWS-HACK", "ISO-8859-1");
        javaName.put("WINDOWS-HACK", "WindowsHack");
        mimeName.put("MACROMAN", "MacRoman");
        javaName.put("MacRoman", "MacRoman");
        String[] cp = new String[]{"037", "1006", "1025", "1026", "1046", "1097", "1098", "1112", "1122", "1123", "1124", "1250", "1251", "1252", "1253", "1254", "1255", "1256", "1257", "1258", "1381", "273", "277", "278", "280", "284", "285", "297", "33722", "420", "424", "437", "500", "737", "775", "838", "850", "852", "855", "857", "860", "861", "862", "863", "864", "865", "866", "868", "869", "870", "871", "874", "875", "918", "921", "922", "930", "933", "935", "937", "939", "942", "948", "949", "964", "970"};
        for (int i = 0; i < cp.length; ++i) {
            mimeName.put("CP" + cp[i], "windows-" + cp[i]);
            mimeName.put("WINDOWS-" + cp[i], "windows-" + cp[i]);
            javaName.put("windows-" + cp[i], "Cp" + cp[i]);
        }
        localeName = new HashMap();
        localeName.put("af", "ISO-8859-1");
        localeName.put("sq", "ISO-8859-1");
        localeName.put("ar", "ISO-8859-6");
        localeName.put("eu", "ISO-8859-1");
        localeName.put("bg", "ISO-8859-5");
        localeName.put("be", "ISO-8859-5");
        localeName.put("ca", "ISO-8859-1");
        localeName.put("hr", "ISO-8859-2");
        localeName.put("cs", "ISO-8859-2");
        localeName.put("da", "ISO-8859-1");
        localeName.put("nl", "ISO-8859-1");
        localeName.put("en", "ISO-8859-1");
        localeName.put("eo", "ISO-8859-3");
        localeName.put("et", "ISO-8859-10");
        localeName.put("fo", "ISO-8859-1");
        localeName.put("fi", "ISO-8859-1");
        localeName.put("fr", "ISO-8859-1");
        localeName.put("gl", "ISO-8859-1");
        localeName.put("de", "ISO-8859-1");
        localeName.put("el", "ISO-8859-7");
        localeName.put("iw", "ISO-8859-8");
        localeName.put("hu", "ISO-8859-2");
        localeName.put("is", "ISO-8859-1");
        localeName.put("ga", "ISO-8859-1");
        localeName.put("it", "ISO-8859-1");
        localeName.put("ja", "Shift_JIS");
        localeName.put("lv", "ISO-8859-10");
        localeName.put("lt", "ISO-8859-10");
        localeName.put("mk", "ISO-8859-5");
        localeName.put("mt", "ISO-8859-3");
        localeName.put("no", "ISO-8859-1");
        localeName.put("pl", "ISO-8859-2");
        localeName.put("pt", "ISO-8859-1");
        localeName.put("ro", "ISO-8859-2");
        localeName.put("ru", "KOI8-R");
        localeName.put("gd", "ISO-8859-1");
        localeName.put("sr", "ISO-8859-5");
        localeName.put("sk", "ISO-8859-2");
        localeName.put("sl", "ISO-8859-2");
        localeName.put("es", "ISO-8859-1");
        localeName.put("sv", "ISO-8859-1");
        localeName.put("tr", "ISO-8859-9");
        localeName.put("uk", "ISO-8859-5");
        localeName.put("ko", "EUC-KR");
        localeName.put("zh", "GB2312");
        localeName.put("zh_TW", "Big5");
    }
}

