/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.vfs.FilesystemPath;
import com.caucho.vfs.Jar;
import com.caucho.vfs.Path;
import com.caucho.vfs.StreamImpl;
import java.io.IOException;
import java.util.Map;
import java.util.jar.Manifest;

public class JarPath
extends FilesystemPath {
    private Path backing;

    protected JarPath(FilesystemPath root, String userPath, String path, Path backing) {
        super(root, userPath, path);
        this.backing = backing;
    }

    public JarPath(Path backing) {
        this(null, "/", "/", backing);
        this._root = this;
    }

    protected Path fsWalk(String userPath, Map attributes, String path) {
        return new JarPath(this._root, userPath, path, this.backing);
    }

    public String getScheme() {
        return "jar";
    }

    public String getURL() {
        return this.getScheme() + ":" + this.getContainer().getURL() + "!" + this.getFullPath();
    }

    public Path getContainer() {
        return this.getJar().getBacking();
    }

    public boolean exists() {
        return this.getJar().exists(this.getPath());
    }

    public boolean isDirectory() {
        return this.getJar().isDirectory(this.getPath());
    }

    public boolean isFile() {
        return this.getJar().isFile(this.getPath());
    }

    public long getLength() {
        return this.getJar().getLength(this);
    }

    public long getLastModified() {
        return this.getJar().getLastModified(this.getPath());
    }

    public boolean canRead() {
        return this.getJar().canRead(this.getPath());
    }

    public boolean canWrite() {
        return this.getJar().canWrite(this.getPath());
    }

    public String[] list() throws IOException {
        return this.getJar().list(this.getPath());
    }

    public Manifest getManifest() throws IOException {
        return this.getJar().getManifest();
    }

    public StreamImpl openReadImpl() throws IOException {
        return this.getJar().openReadImpl(this);
    }

    protected Jar getJar() {
        return Jar.create(this.backing);
    }

    public String toString() {
        return "jar:(" + this.backing + ")" + this.getPath();
    }

    public int hashCode() {
        return 65531 * super.hashCode() + this.backing.hashCode();
    }
}

