/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.vfs.NullPath;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import java.io.IOException;

public class StringStream
extends StreamImpl {
    private String string;
    private int length;
    private int index;

    private StringStream(String string) {
        this.string = string;
        this.length = string.length();
        this.index = 0;
    }

    public static ReadStream open(String string) {
        StringStream ss = new StringStream(string);
        return new ReadStream(ss);
    }

    public Path getPath() {
        return new NullPath("string:");
    }

    public boolean canRead() {
        return true;
    }

    public int read(byte[] buf, int offset, int length) throws IOException {
        if (this.length - this.index < length) {
            length = this.length - this.index;
        }
        for (int i = 0; i < length; ++i) {
            char ch = this.string.charAt(this.index + i);
            if (ch < '\u0080') {
                buf[offset++] = (byte)ch;
                continue;
            }
            if (ch < '\u0800') {
                buf[offset++] = (byte)(0xC0 | ch >> 6);
                buf[offset++] = (byte)(0x80 | ch & 0x3F);
                continue;
            }
            if (ch >= '\u8000') continue;
            buf[offset++] = (byte)(0xE0 | ch >> 12);
            buf[offset++] = (byte)(0x80 | ch >> 6 & 0x3F);
            buf[offset++] = (byte)(0x80 | ch >> 6 & 0x3F);
        }
        this.index += length;
        return length;
    }

    public int getAvailable() throws IOException {
        return this.length - this.index;
    }
}

