/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.CharBuffer;
import com.caucho.vfs.Path;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.TcpStream;
import java.io.IOException;
import java.util.Map;

public class TcpPath
extends Path {
    protected String host;
    protected int port;
    protected long timeout;

    TcpPath(TcpPath root, Map newAttributes, String host, int port) {
        super(root);
        this.host = host;
        this.port = port == 0 ? 80 : port;
    }

    protected Path schemeWalk(String userPath, Map newAttributes, String uri, int offset) {
        int i;
        int length = uri.length();
        if (length < 2 + offset || uri.charAt(offset) != '/' || uri.charAt(1 + offset) != '/') {
            throw new RuntimeException("bad scheme");
        }
        CharBuffer buf = new CharBuffer();
        char ch = '\u0000';
        for (i = 2 + offset; i < length && (ch = uri.charAt(i)) != ':' && ch != '/' && ch != '?'; ++i) {
            buf.append(ch);
        }
        String host = buf.toString();
        if (host.length() == 0) {
            throw new RuntimeException("bad host");
        }
        int port = 0;
        if (ch == ':') {
            ++i;
            while (i < length && (ch = uri.charAt(i)) >= '0' && ch <= '9') {
                port = 10 * port + uri.charAt(i) - 48;
                ++i;
            }
        }
        return new TcpPath(this, newAttributes, host, port);
    }

    public String getScheme() {
        return "tcp";
    }

    public String getURL() {
        int port = this.getPort();
        return this.getScheme() + "://" + this.getHost() + ":" + this.getPort();
    }

    public String getPath() {
        return "";
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public void setAttribute(String attr, Object value) throws IOException {
        if (attr.equals("timeout")) {
            Long timeout = (Long)value;
            this.timeout = timeout;
        } else {
            super.setAttribute(attr, value);
        }
    }

    public StreamImpl openReadImpl() throws IOException {
        return TcpStream.openRead(this, this.timeout);
    }

    public StreamImpl openReadWriteImpl() throws IOException {
        return TcpStream.openReadWrite(this, this.timeout);
    }

    public String toString() {
        return this.getURL();
    }
}

