/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.TempBuffer;
import java.io.IOException;

public class TempReadStream
extends StreamImpl {
    private TempBuffer cursor;
    private int offset;
    private Path backingDir;
    private Path backingFile;
    private ReadStream backingStream;
    private boolean freeWhenDone = true;

    public TempReadStream(TempBuffer cursor) {
        this.init(cursor, null);
    }

    TempReadStream(TempBuffer cursor, Path path) {
        this.init(cursor, path);
    }

    public void init(TempBuffer cursor, Path path) {
        this.setPath(path);
        this.cursor = cursor;
        this.offset = 0;
        this.freeWhenDone = true;
        this.backingFile = null;
        this.backingStream = null;
    }

    public void init(TempBuffer cursor) {
        this.init(cursor, null);
    }

    public void setFreeWhenDone(boolean free) {
        this.freeWhenDone = free;
    }

    public boolean canRead() {
        return true;
    }

    public int read(byte[] buf, int offset, int length) throws IOException {
        if (this.cursor == null) {
            return -1;
        }
        if (this.cursor.length - this.offset < length) {
            length = this.cursor.length - this.offset;
        }
        System.arraycopy(this.cursor.buf, this.offset, buf, offset, length);
        if (this.offset + length >= this.cursor.length) {
            TempBuffer next = this.cursor.next;
            if (this.freeWhenDone) {
                TempBuffer.free(this.cursor);
            }
            this.cursor = next;
            this.offset = 0;
        } else {
            this.offset += length;
        }
        return length;
    }

    public int getAvailable() throws IOException {
        if (this.cursor != null) {
            return this.cursor.length - this.offset;
        }
        return 0;
    }

    public void close() throws IOException {
        if (this.freeWhenDone && this.cursor != null) {
            TempBuffer.freeAll(this.cursor);
        }
        this.cursor = null;
    }
}

