/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.TempReadStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;

public class TempStream
extends StreamImpl {
    private TempBuffer head;
    private TempBuffer tail;
    private Path backingDir;
    private Path backingFile;
    private WriteStream backingStream;
    private boolean useBackingFile;

    public TempStream(Path backingDir) {
        this.backingDir = backingDir;
    }

    public void openWrite() {
        TempBuffer ptr = this.head;
        this.head = null;
        this.tail = null;
        TempBuffer.freeAll(ptr);
        this.useBackingFile = false;
        if (this.backingStream != null) {
            try {
                this.backingStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.backingStream = null;
        }
    }

    public void changeToBackingFile(int index) throws IOException {
        if (this.backingFile == null) {
            this.backingFile = this.backingDir.createTempFile("tmp", ".tmp");
        }
        this.backingStream = this.backingFile.openWrite();
        this.useBackingFile = true;
        while (this.head != null) {
            TempBuffer next = this.head.next;
            this.backingStream.write(this.head.buf, 0, this.head.length);
            TempBuffer.free(this.head);
            this.head = next;
        }
    }

    public boolean canWrite() {
        return true;
    }

    public void write(byte[] buf, int offset, int length, boolean isEnd) throws IOException {
        if (this.backingStream != null) {
            this.backingStream.write(buf, offset, length);
        } else {
            int index = 0;
            while (index < length) {
                if (this.tail == null) {
                    this.addBuffer(TempBuffer.allocate());
                } else if (this.tail.length >= this.tail.buf.length) {
                    if (this.head.bufferCount < 8 || this.backingDir == null) {
                        this.addBuffer(TempBuffer.allocate());
                    } else {
                        this.changeToBackingFile(index);
                        this.backingStream.write(buf, offset, length);
                        return;
                    }
                }
                int sublen = this.tail.buf.length - this.tail.length;
                if (sublen > length - index) {
                    sublen = length - index;
                }
                System.arraycopy(buf, index + offset, this.tail.buf, this.tail.length, sublen);
                index += sublen;
                this.tail.length += sublen;
            }
        }
    }

    private void addBuffer(TempBuffer buf) {
        buf.next = null;
        if (this.tail != null) {
            this.tail.next = buf;
            this.tail = buf;
        } else {
            this.tail = buf;
            this.head = buf;
        }
        ++this.head.bufferCount;
    }

    public void flush() throws IOException {
        if (this.backingStream != null) {
            this.backingStream.flush();
        }
    }

    public void close() throws IOException {
        if (this.backingStream != null) {
            this.backingStream.close();
            this.backingStream = null;
        }
        super.close();
    }

    public ReadStream openRead() throws IOException {
        return this.openRead(false);
    }

    public ReadStream openRead(boolean free) throws IOException {
        this.close();
        if (this.useBackingFile) {
            return this.backingFile.openRead();
        }
        TempReadStream read = new TempReadStream(this.head);
        read.setFreeWhenDone(free);
        if (free) {
            this.head = null;
            this.tail = null;
        }
        read.setPath(this.getPath());
        return new ReadStream(read);
    }

    public void openRead(ReadStream rs, boolean free) throws IOException {
        this.close();
        if (this.useBackingFile) {
            StreamImpl impl = this.backingFile.openReadImpl();
            rs.init(impl, null);
        } else {
            TempReadStream read = new TempReadStream(this.head);
            read.setFreeWhenDone(free);
            if (free) {
                this.head = null;
                this.tail = null;
            }
            read.setPath(this.getPath());
            rs.init(read, null);
        }
    }

    public int getLength() {
        int length = 0;
        TempBuffer ptr = this.head;
        while (ptr != null) {
            length += ptr.getLength();
            ptr = ptr.next;
        }
        return length;
    }

    public ReadStream openRead(ReadStream s) throws IOException {
        this.close();
        if (this.useBackingFile) {
            return this.backingFile.openRead();
        }
        TempReadStream read = new TempReadStream(this.head);
        read.setFreeWhenDone(false);
        read.setPath(this.getPath());
        s.init(read, null);
        return s;
    }

    public void clearWrite() {
        TempBuffer ptr = this.head;
        this.head = null;
        this.tail = null;
        TempBuffer.freeAll(ptr);
        if (this.backingStream != null) {
            try {
                this.backingStream.close();
                this.backingStream = this.backingFile.openWrite();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.useBackingFile = false;
    }

    public void discard() {
        this.head = null;
        this.tail = null;
        if (this.backingStream != null) {
            try {
                this.backingStream.close();
                this.backingStream = this.backingFile.openWrite();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.useBackingFile = false;
    }

    public void destroy() {
        try {
            this.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            if (this.backingFile != null) {
                this.backingFile.remove();
            }
            this.backingFile = null;
        }
        catch (IOException e) {
            // empty catch block
        }
        TempBuffer ptr = this.head;
        this.head = null;
        this.tail = null;
        TempBuffer.freeAll(ptr);
    }
}

