/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml.readers;

import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.xml.XmlChar;
import com.caucho.xml.XmlParser;
import java.io.IOException;
import org.xml.sax.SAXException;

public class XmlReader {
    static L10N L = new L10N("com/caucho/xml/reader/messages");
    protected static boolean[] isAsciiNameChar = XmlChar.getAsciiNameCharArray();
    protected XmlParser parser;
    protected XmlReader next;
    protected Path searchPath;
    protected ReadStream is;
    protected String filename;
    protected int line;
    protected String systemId;
    protected String publicId;

    public XmlReader() {
    }

    public XmlReader(XmlParser parser, ReadStream is) {
        this.init(parser, is);
    }

    public void init(XmlParser parser, ReadStream is) {
        this.parser = parser;
        this.is = is;
        this.filename = is.getUserPath();
        this.line = 1;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public int getLine() {
        return this.line;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setPublicId(String publicId) {
        this.publicId = publicId;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public void setSearchPath(Path searchPath) {
        this.searchPath = searchPath;
    }

    public Path getSearchPath() {
        return this.searchPath;
    }

    public void setNext(XmlReader next) {
        this.next = next;
    }

    public XmlReader getNext() {
        return this.next;
    }

    public ReadStream getReadStream() {
        return this.is;
    }

    public int read() throws IOException {
        int ch = this.is.readChar();
        if (ch == 10) {
            this.parser.setLine(++this.line);
        }
        return ch;
    }

    public int parseName(CharBuffer name, int ch) throws IOException, SAXException {
        char[] buffer = name.getBuffer();
        int capacity = buffer.length;
        int offset = 0;
        buffer[offset++] = (char)ch;
        ch = this.read();
        while (ch > 0 && ch < 128 && isAsciiNameChar[ch] || XmlChar.isNameChar(ch)) {
            if (offset >= capacity) {
                name.setLength(offset);
                name.append((char)ch);
                ++offset;
                buffer = name.getBuffer();
                capacity = buffer.length;
            } else {
                buffer[offset++] = (char)ch;
            }
            ch = this.read();
        }
        name.setLength(offset);
        return ch;
    }

    public void finish() {
        this.is = null;
    }
}

