/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath.pattern;

import com.caucho.util.CharBuffer;
import com.caucho.xpath.Env;
import com.caucho.xpath.ExprEnvironment;
import com.caucho.xpath.pattern.AbstractPattern;
import com.caucho.xpath.pattern.Axis;
import org.w3c.dom.Node;

public class FromContext
extends Axis {
    int ancestorCount;

    public FromContext() {
        super(null);
    }

    public FromContext(int ancestorCount) {
        super(null);
        this.ancestorCount = ancestorCount;
    }

    public int getCount() {
        return this.ancestorCount;
    }

    public boolean match(Node node, ExprEnvironment env) {
        Node context = env.getContextNode();
        for (int i = 0; i < this.ancestorCount && context != null; context = context.getParentNode(), ++i) {
        }
        return node == context;
    }

    public boolean isStrictlyAscending() {
        return true;
    }

    boolean isSingleSelect() {
        return true;
    }

    public int position(Node node, Env env, AbstractPattern pattern) {
        return 1;
    }

    public int count(Node node, Env env, AbstractPattern pattern) {
        return 1;
    }

    public Node firstNode(Node node, ExprEnvironment env) {
        for (int i = 0; node != null && i < this.ancestorCount; node = node.getParentNode(), ++i) {
        }
        return node;
    }

    public Node nextNode(Node node, Node lastNode) {
        return null;
    }

    public boolean equals(Object b) {
        return b instanceof FromContext && this.ancestorCount == ((FromContext)b).ancestorCount;
    }

    public String toString() {
        if (this.ancestorCount == 0) {
            return "context()";
        }
        CharBuffer cb = CharBuffer.allocate();
        cb.append("..");
        for (int i = 1; i < this.ancestorCount; ++i) {
            cb.append("/..");
        }
        return cb.close();
    }
}

