/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq;

import java.util.Enumeration;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.codehaus.activemq.message.ActiveMQBytesMessage;
import org.codehaus.activemq.message.ActiveMQDestination;
import org.codehaus.activemq.message.ActiveMQMapMessage;
import org.codehaus.activemq.message.ActiveMQMessage;
import org.codehaus.activemq.message.ActiveMQObjectMessage;
import org.codehaus.activemq.message.ActiveMQQueue;
import org.codehaus.activemq.message.ActiveMQStreamMessage;
import org.codehaus.activemq.message.ActiveMQTemporaryQueue;
import org.codehaus.activemq.message.ActiveMQTemporaryTopic;
import org.codehaus.activemq.message.ActiveMQTextMessage;
import org.codehaus.activemq.message.ActiveMQTopic;

class ActiveMQMessageTransformation {
    ActiveMQMessageTransformation() {
    }

    static ActiveMQDestination transformDestination(Destination destination) throws JMSException {
        ActiveMQDestination result = null;
        if (destination != null) {
            if (destination instanceof ActiveMQDestination) {
                result = (ActiveMQDestination)destination;
            } else if (destination instanceof TemporaryQueue) {
                result = new ActiveMQTemporaryQueue(((Queue)destination).getQueueName());
            } else if (destination instanceof TemporaryTopic) {
                result = new ActiveMQTemporaryTopic(((Topic)destination).getTopicName());
            } else if (destination instanceof Queue) {
                result = new ActiveMQQueue(((Queue)destination).getQueueName());
            } else if (destination instanceof Topic) {
                result = new ActiveMQTopic(((Topic)destination).getTopicName());
            }
        }
        return result;
    }

    public static final ActiveMQMessage transformMessage(Message message) throws JMSException {
        Object obj;
        ActiveMQMessage msg;
        if (message instanceof ActiveMQMessage) {
            ActiveMQMessage answer = ((ActiveMQMessage)message).shallowCopy();
            answer.setJMSMessageIdentity(null);
            return answer;
        }
        ActiveMQMessage activeMessage = null;
        if (message instanceof ObjectMessage) {
            ObjectMessage objMsg = (ObjectMessage)message;
            msg = new ActiveMQObjectMessage();
            ((ActiveMQObjectMessage)msg).setObject(objMsg.getObject());
            activeMessage = msg;
        } else if (message instanceof TextMessage) {
            TextMessage textMsg = (TextMessage)message;
            msg = new ActiveMQTextMessage();
            ((ActiveMQTextMessage)msg).setText(textMsg.getText());
            activeMessage = msg;
        } else if (message instanceof MapMessage) {
            MapMessage mapMsg = (MapMessage)message;
            msg = new ActiveMQMapMessage();
            Enumeration iter = mapMsg.getMapNames();
            while (iter.hasMoreElements()) {
                String name = iter.nextElement().toString();
                ((ActiveMQMapMessage)msg).setObject(name, mapMsg.getObject(name));
            }
            activeMessage = msg;
        } else if (message instanceof BytesMessage) {
            BytesMessage bytesMsg = (BytesMessage)message;
            bytesMsg.reset();
            msg = new ActiveMQBytesMessage();
            try {
                while (true) {
                    ((ActiveMQBytesMessage)msg).writeByte(bytesMsg.readByte());
                }
            }
            catch (JMSException e) {
                activeMessage = msg;
            }
        } else if (message instanceof StreamMessage) {
            StreamMessage streamMessage = (StreamMessage)message;
            streamMessage.reset();
            msg = new ActiveMQStreamMessage();
            obj = null;
            try {
                while ((obj = streamMessage.readObject()) != null) {
                    ((ActiveMQStreamMessage)msg).writeObject(obj);
                }
            }
            catch (JMSException e) {
                // empty catch block
            }
            activeMessage = msg;
        } else {
            activeMessage = new ActiveMQMessage();
        }
        activeMessage.setJMSMessageID(message.getJMSMessageID());
        activeMessage.setJMSCorrelationID(message.getJMSCorrelationID());
        activeMessage.setJMSReplyTo(ActiveMQMessageTransformation.transformDestination(message.getJMSReplyTo()));
        activeMessage.setJMSDestination(ActiveMQMessageTransformation.transformDestination(message.getJMSDestination()));
        activeMessage.setJMSDeliveryMode(message.getJMSDeliveryMode());
        activeMessage.setJMSRedelivered(message.getJMSRedelivered());
        activeMessage.setJMSType(message.getJMSType());
        activeMessage.setJMSExpiration(message.getJMSExpiration());
        activeMessage.setJMSPriority(message.getJMSPriority());
        activeMessage.setJMSTimestamp(message.getJMSTimestamp());
        Enumeration propertyNames = message.getPropertyNames();
        while (propertyNames.hasMoreElements()) {
            String name = propertyNames.nextElement().toString();
            obj = message.getObjectProperty(name);
            activeMessage.setObjectProperty(name, obj);
        }
        return activeMessage;
    }
}

