/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.mapping;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.dialect.HSQLDialect;
import net.sf.hibernate.engine.Mapping;
import net.sf.hibernate.id.IdentityGenerator;
import net.sf.hibernate.mapping.Column;
import net.sf.hibernate.mapping.ForeignKey;
import net.sf.hibernate.mapping.Index;
import net.sf.hibernate.mapping.PrimaryKey;
import net.sf.hibernate.mapping.RelationalModel;
import net.sf.hibernate.mapping.SimpleValue;
import net.sf.hibernate.mapping.UniqueKey;
import net.sf.hibernate.tool.hbm2ddl.ColumnMetadata;
import net.sf.hibernate.tool.hbm2ddl.TableMetadata;
import org.apache.commons.collections.SequencedHashMap;

public class Table
implements RelationalModel {
    private String name;
    private String schema;
    private Map columns = new SequencedHashMap();
    private SimpleValue idValue;
    private PrimaryKey primaryKey;
    private Map indexes = new HashMap();
    private Map foreignKeys = new HashMap();
    private Map uniqueKeys = new HashMap();
    private final int uniqueInteger;
    private boolean quoted;
    private static int tableCounter = 0;
    private List checkConstraints = new ArrayList();

    public Table() {
        this.uniqueInteger = tableCounter++;
    }

    public String getQualifiedName(Dialect dialect) {
        String quotedName = this.getQuotedName(dialect);
        return this.schema == null ? quotedName : this.schema + dialect.getSchemaSeparator() + quotedName;
    }

    public String getQualifiedName(Dialect dialect, String defaultQualifier) {
        String quotedName = this.getQuotedName(dialect);
        return this.schema == null ? (defaultQualifier == null ? quotedName : defaultQualifier + dialect.getSchemaSeparator() + quotedName) : this.getQualifiedName(dialect);
    }

    public String getName() {
        return this.name;
    }

    public String getQuotedName(Dialect dialect) {
        return this.quoted ? dialect.openQuote() + this.name + dialect.closeQuote() : this.name;
    }

    public void setName(String name) {
        if (name.charAt(0) == '`') {
            this.quoted = true;
            this.name = name.substring(1, name.length() - 1);
        } else {
            this.name = name;
        }
    }

    public Column getColumn(int n) {
        Iterator iter = this.columns.values().iterator();
        for (int i = 0; i < n - 1; ++i) {
            iter.next();
        }
        return (Column)iter.next();
    }

    public void addColumn(Column column) {
        Column old = (Column)this.columns.get(column.getName());
        if (old == null) {
            this.columns.put(column.getName(), column);
            column.uniqueInteger = this.columns.size();
        } else {
            column.uniqueInteger = old.uniqueInteger;
        }
    }

    public int getColumnSpan() {
        return this.columns.size();
    }

    public Iterator getColumnIterator() {
        return this.columns.values().iterator();
    }

    public Iterator getIndexIterator() {
        return this.indexes.values().iterator();
    }

    public Iterator getForeignKeyIterator() {
        return this.foreignKeys.values().iterator();
    }

    public Iterator getUniqueKeyIterator() {
        return this.uniqueKeys.values().iterator();
    }

    public Iterator sqlAlterStrings(Dialect dialect, Mapping p, TableMetadata tableInfo) throws HibernateException {
        StringBuffer root = new StringBuffer("alter table ").append(this.getQualifiedName(dialect)).append(' ').append(dialect.getAddColumnString());
        Iterator iter = this.getColumnIterator();
        ArrayList<String> results = new ArrayList<String>();
        while (iter.hasNext()) {
            Column col = (Column)iter.next();
            ColumnMetadata columnInfo = tableInfo.getColumnMetadata(col.getName());
            if (columnInfo != null) continue;
            StringBuffer alter = new StringBuffer(root.toString()).append(' ').append(col.getQuotedName(dialect)).append(' ').append(col.getSqlType(dialect, p));
            if (col.isUnique() && dialect.supportsUnique()) {
                alter.append(" unique");
            }
            if (col.hasCheckConstraint()) {
                alter.append(" check(").append(col.getCheckConstraint()).append(")");
            }
            results.add(alter.toString());
        }
        return results.iterator();
    }

    public String sqlCreateString(Dialect dialect, Mapping p) throws HibernateException {
        UniqueKey uk;
        StringBuffer buf = new StringBuffer("create table ").append(this.getQualifiedName(dialect)).append(" (");
        boolean identityColumn = this.idValue != null && this.idValue.createIdentifierGenerator(dialect) instanceof IdentityGenerator;
        String pkname = null;
        if (this.primaryKey != null && identityColumn) {
            pkname = ((Column)this.primaryKey.getColumnIterator().next()).getQuotedName(dialect);
        }
        Iterator iter = this.getColumnIterator();
        while (iter.hasNext()) {
            Column col = (Column)iter.next();
            buf.append(col.getQuotedName(dialect)).append(' ');
            if (identityColumn && col.getQuotedName(dialect).equals(pkname)) {
                if (dialect.hasDataTypeInIdentityColumn()) {
                    buf.append(col.getSqlType(dialect, p));
                }
                buf.append(' ').append(dialect.getIdentityColumnString());
            } else {
                buf.append(col.getSqlType(dialect, p));
                if (col.isNullable()) {
                    buf.append(dialect.getNullColumnString());
                } else {
                    buf.append(" not null");
                }
            }
            if (col.isUnique()) {
                if (dialect.supportsUnique()) {
                    buf.append(" unique");
                } else {
                    uk = this.getUniqueKey(col.getQuotedName(dialect) + '_');
                    uk.addColumn(col);
                }
            }
            if (col.hasCheckConstraint() && dialect.supportsCheck()) {
                buf.append(" check(").append(col.getCheckConstraint()).append(")");
            }
            if (!iter.hasNext()) continue;
            buf.append(", ");
        }
        if (!(this.primaryKey == null || dialect instanceof HSQLDialect && identityColumn)) {
            buf.append(", ").append(this.primaryKey.sqlConstraintString(dialect));
        }
        Iterator ukiter = this.getUniqueKeyIterator();
        while (ukiter.hasNext()) {
            uk = (UniqueKey)ukiter.next();
            buf.append(", ").append(uk.sqlConstraintString(dialect));
        }
        if (dialect.supportsCheck()) {
            Iterator chiter = this.checkConstraints.iterator();
            while (chiter.hasNext()) {
                buf.append(", check(").append(chiter.next()).append(")");
            }
        }
        buf.append(")");
        return buf.toString();
    }

    public String sqlDropString(Dialect dialect) {
        StringBuffer buf = new StringBuffer("drop table ");
        if (dialect.supportsIfExistsBeforeTableName()) {
            buf.append("if exists ");
        }
        buf.append(this.getQualifiedName(dialect)).append(dialect.getCascadeConstraintsString());
        if (dialect.supportsIfExistsAfterTableName()) {
            buf.append(" if exists");
        }
        return buf.toString();
    }

    public PrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(PrimaryKey primaryKey) {
        this.primaryKey = primaryKey;
    }

    public Index createIndex(String name, List indexColumns) {
        if (name == null) {
            name = "IX" + this.uniqueColumnString(indexColumns.iterator());
        }
        Index idx = this.getIndex(name);
        idx.addColumns(indexColumns.iterator());
        return idx;
    }

    public Index getIndex(String indexName) {
        Index index = (Index)this.indexes.get(indexName);
        if (index == null) {
            index = new Index();
            index.setName(indexName);
            index.setTable(this);
            this.indexes.put(indexName, index);
        }
        return index;
    }

    public UniqueKey createUniqueKey(List keyColumns) {
        String keyName = "UK" + this.uniqueColumnString(keyColumns.iterator());
        UniqueKey uk = this.getUniqueKey(keyName);
        uk.addColumns(keyColumns.iterator());
        return uk;
    }

    public UniqueKey getUniqueKey(String keyName) {
        UniqueKey uk = (UniqueKey)this.uniqueKeys.get(keyName);
        if (uk == null) {
            uk = new UniqueKey();
            uk.setName(keyName);
            uk.setTable(this);
            this.uniqueKeys.put(keyName, uk);
        }
        return uk;
    }

    public ForeignKey createForeignKey(String keyName, List keyColumns, Class referencedClass) {
        ForeignKey fk;
        if (keyName == null) {
            keyName = "FK" + this.uniqueColumnString(keyColumns.iterator());
        }
        if ((fk = (ForeignKey)this.foreignKeys.get(keyName)) == null) {
            fk = new ForeignKey();
            fk.setName(keyName);
            fk.setTable(this);
            this.foreignKeys.put(keyName, fk);
            fk.setReferencedClass(referencedClass);
        } else {
            keyName = keyName + Integer.toHexString(referencedClass.getName().hashCode()).toUpperCase();
            if (fk.getReferencedClass() != referencedClass) {
                fk = this.createForeignKey(keyName, keyColumns, referencedClass);
            }
        }
        fk.addColumns(keyColumns.iterator());
        return fk;
    }

    public String uniqueColumnString(Iterator iterator) {
        int result = 0;
        while (iterator.hasNext()) {
            result += iterator.next().hashCode();
        }
        return (Integer.toHexString(this.name.hashCode()) + Integer.toHexString(result)).toUpperCase();
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public int getUniqueInteger() {
        return this.uniqueInteger;
    }

    public void setIdentifierValue(SimpleValue idValue) {
        this.idValue = idValue;
    }

    public boolean isQuoted() {
        return this.quoted;
    }

    public void setQuoted(boolean quoted) {
        this.quoted = quoted;
    }

    public void addCheckConstraint(String constraint) {
        this.checkConstraints.add(constraint);
    }
}

