/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.hsqldb.CachedRow;
import org.hsqldb.Database;
import org.hsqldb.DiskNode;
import org.hsqldb.HsqlException;
import org.hsqldb.Index;
import org.hsqldb.Node;
import org.hsqldb.Table;
import org.hsqldb.Trace;
import org.hsqldb.lib.DoubleIntTable;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.StopWatch;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.rowio.RowOutputBinary;

class DataFileDefrag {
    BufferedOutputStream fileStreamOut;
    long filePos;
    StopWatch stopw = new StopWatch();

    DataFileDefrag() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    HsqlArrayList defrag(Database database, String string) throws IOException, HsqlException {
        RandomAccessFile randomAccessFile;
        HsqlArrayList hsqlArrayList;
        block11: {
            Trace.printSystemOut("Defrag Transfer begins");
            hsqlArrayList = new HsqlArrayList();
            HsqlArrayList hsqlArrayList2 = database.getTables();
            randomAccessFile = null;
            try {
                try {
                    Object object;
                    int n;
                    FileOutputStream fileOutputStream = new FileOutputStream(string + ".new", false);
                    this.fileStreamOut = new BufferedOutputStream(fileOutputStream, 4096);
                    for (n = 0; n < 32; ++n) {
                        this.fileStreamOut.write(0);
                    }
                    this.filePos = 32L;
                    int n2 = hsqlArrayList2.size();
                    for (n = 0; n < n2; ++n) {
                        object = (Table)hsqlArrayList2.get(n);
                        if (((Table)object).tableType == 4) {
                            int[] nArray = this.writeTableToDataFile((Table)object);
                            hsqlArrayList.add(nArray);
                        } else {
                            hsqlArrayList.add(null);
                        }
                        Trace.printSystemOut(((Table)object).getName().name + " complete");
                    }
                    this.fileStreamOut.close();
                    randomAccessFile = new RandomAccessFile(string + ".new", "rw");
                    randomAccessFile.seek(16L);
                    randomAccessFile.writeInt((int)this.filePos);
                    n2 = hsqlArrayList.size();
                    for (n = 0; n < n2; ++n) {
                        object = (int[])hsqlArrayList.get(n);
                        if (object == null) continue;
                        Trace.printSystemOut(StringUtil.getList((int[])object, ",", ""));
                    }
                    Object var12_12 = null;
                    if (this.fileStreamOut == null) break block11;
                }
                catch (IOException iOException) {
                    throw Trace.error(29, string + ".new");
                }
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                if (this.fileStreamOut != null) {
                    this.fileStreamOut.close();
                }
                if (randomAccessFile == null) throw throwable;
                randomAccessFile.close();
                throw throwable;
            }
            this.fileStreamOut.close();
        }
        if (randomAccessFile == null) return hsqlArrayList;
        randomAccessFile.close();
        return hsqlArrayList;
    }

    static void updateTableIndexRoots(HsqlArrayList hsqlArrayList, HsqlArrayList hsqlArrayList2) throws HsqlException {
        int n = hsqlArrayList.size();
        for (int i = 0; i < n; ++i) {
            Table table = (Table)hsqlArrayList.get(i);
            if (table.tableType != 4) continue;
            int[] nArray = (int[])hsqlArrayList2.get(i);
            table.setIndexRoots(nArray);
        }
    }

    int[] writeTableToDataFile(Table table) throws IOException, HsqlException {
        CachedRow cachedRow;
        RowOutputBinary rowOutputBinary = new RowOutputBinary();
        DoubleIntTable doubleIntTable = new DoubleIntTable(1000000);
        int[] nArray = table.getIndexRootsArray();
        Index index = table.getPrimaryIndex();
        long l = this.filePos;
        int n = 0;
        Trace.printSystemOut("lookup begins: " + this.stopw.elapsedTime());
        Node node = index.first();
        while (node != null) {
            cachedRow = (CachedRow)node.getRow();
            doubleIntTable.add(cachedRow.iPos, (int)l);
            if (n % 50000 == 0) {
                Trace.printSystemOut("pointer pair for row " + n + " " + cachedRow.iPos + " " + l);
            }
            l += (long)cachedRow.storageSize;
            node = index.next(node);
            ++n;
        }
        Trace.printSystemOut(table.getName().name + " list done ", this.stopw.elapsedTime());
        n = 0;
        node = index.first();
        while (node != null) {
            cachedRow = (CachedRow)node.getRow();
            rowOutputBinary.reset();
            rowOutputBinary.writeSize(cachedRow.storageSize);
            Node node2 = cachedRow.nPrimaryNode;
            while (node2 != null) {
                ((DiskNode)node2).writeTranslate(rowOutputBinary, doubleIntTable);
                node2 = node2.nNext;
            }
            rowOutputBinary.writeData(cachedRow.getData(), cachedRow.getTable());
            rowOutputBinary.writeEnd();
            this.fileStreamOut.write(rowOutputBinary.getOutputStream().getBuffer(), 0, rowOutputBinary.size());
            this.filePos += (long)cachedRow.storageSize;
            if (n % 50000 == 0) {
                Trace.printSystemOut(n + " rows " + this.stopw.elapsedTime());
            }
            node = index.next(node);
            ++n;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == -1) continue;
            int n2 = doubleIntTable.find(0, nArray[i]);
            if (n2 == -1) {
                throw Trace.error(129);
            }
            nArray[i] = doubleIntTable.get(n2, 1);
        }
        Trace.printSystemOut(table.getName().name + " : table converted");
        return nArray;
    }
}

