/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.journal.impl;

import EDU.oswego.cs.dl.util.concurrent.FutureResult;
import EDU.oswego.cs.dl.util.concurrent.QueuedExecutor;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactory;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.activemq.journal.InvalidRecordLocationException;
import org.codehaus.activemq.journal.JournalEventListener;
import org.codehaus.activemq.journal.impl.BatchedWrite;
import org.codehaus.activemq.journal.impl.ByteBufferPool;
import org.codehaus.activemq.journal.impl.LogFile;
import org.codehaus.activemq.journal.impl.Mark;
import org.codehaus.activemq.journal.impl.Record;
import org.codehaus.activemq.journal.impl.RecordLocationImpl;
import org.codehaus.activemq.util.LongSequenceGenerator;

public class LogFileManager {
    private static final Log log = LogFactory.getLog((Class)LogFileManager.class);
    private static final int LOG_HEADER_SIZE = 512;
    private static final int OVERFLOW_RENOTIFICATION_DELAY = 500;
    private final LongSequenceGenerator sequenceGenerator;
    private final byte fileManagerId;
    private boolean closed = false;
    private byte markedSegmentIndex = 0;
    private byte appendSegmentIndex = 0;
    private int appendSegmentOffset = 0;
    private BatchedWrite pendingBatchWrite;
    private RecordLocationImpl lastMarkedLocation;
    private LogFile file;
    private QueuedExecutor executor;
    private int rolloverFence;
    private JournalEventListener eventListener;
    private ByteBufferPool byteBufferPool;
    private long overflowNotificationTime = System.currentTimeMillis();

    public LogFileManager(byte fileManagerId, LongSequenceGenerator sequenceGenerator, File logDirectory) throws IOException {
        this(fileManagerId, sequenceGenerator, new LogFile(logDirectory));
    }

    public LogFileManager(byte fileManagerId, LongSequenceGenerator sequenceGenerator, LogFile logFile) {
        this.fileManagerId = fileManagerId;
        this.sequenceGenerator = sequenceGenerator;
        this.file = logFile;
        this.byteBufferPool = new ByteBufferPool();
        this.executor = new QueuedExecutor();
        this.executor.setThreadFactory(new ThreadFactory(){

            public Thread newThread(Runnable runnable) {
                Thread answer = new Thread(runnable, "Journal Writter");
                answer.setPriority(10);
                answer.setDaemon(true);
                return answer;
            }
        });
        this.lastMarkedLocation = this.file.getLastMarkedRecordLocation(fileManagerId);
        this.appendSegmentIndex = this.file.getAppendSegmentIndex();
        this.appendSegmentOffset = this.file.getAppendSegmentOffset();
        this.rolloverFence = this.file.getInitialSegmentSize() / 10 * 9;
    }

    public RecordLocationImpl write(byte[] data, boolean sync) throws IOException {
        return this.write((byte)1, data, sync, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RecordLocationImpl write(byte recordType, byte[] data, boolean sync, Mark mark) throws IOException {
        try {
            BatchedWrite writeCommand;
            RecordLocationImpl location;
            LogFileManager logFileManager = this;
            synchronized (logFileManager) {
                if (this.closed) {
                    throw new IOException("Journal has been closed.");
                }
                long sequenceId = this.sequenceGenerator.getNextSequenceId();
                location = new RecordLocationImpl(this.fileManagerId, this.appendSegmentIndex, this.appendSegmentOffset, sequenceId);
                Record record = new Record(sequenceId, recordType, data, mark);
                writeCommand = this.addToPendingWriteBatch(record);
                this.appendSegmentOffset += data.length + 35;
                this.rolloverCheck();
            }
            if (sync) {
                writeCommand.waitForForce();
            }
            return location;
        }
        catch (IOException e) {
            throw e;
        }
        catch (InterruptedException e) {
            throw (IOException)new InterruptedIOException().initCause(e);
        }
        catch (Throwable e) {
            throw (IOException)new IOException("Write failed: " + e).initCause(e);
        }
    }

    private BatchedWrite addToPendingWriteBatch(Record record) throws InterruptedException {
        BatchedWrite answer = null;
        while (record.remaining() > 0) {
            if (this.pendingBatchWrite == null) {
                BatchedWrite write;
                this.pendingBatchWrite = write = new BatchedWrite(this.byteBufferPool.getByteBuffer());
                this.executor.execute(new Runnable(){

                    public void run() {
                        try {
                            LogFileManager.this.queuedWrite(write);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                });
            }
            answer = this.pendingBatchWrite;
            if (this.pendingBatchWrite.append(record)) continue;
            this.pendingBatchWrite = null;
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queuedWrite(BatchedWrite write) throws InterruptedException {
        write.disableAppend();
        try {
            this.file.appendAndForce(write);
            write.forced();
        }
        catch (Throwable e) {
            write.writeFailed(e);
        }
        finally {
            this.byteBufferPool.returnByteBuffer(write.getByteBuffer());
        }
    }

    private void rolloverCheck() throws IOException {
        if (this.eventListener != null && !this.file.canActivateNextSegment() && this.overflowNotificationTime + 500L < System.currentTimeMillis()) {
            RecordLocationImpl safeSpot = this.file.getFirstRecordLocationOfSecondActiveSegment(this.fileManagerId);
            this.eventListener.overflowNotification(safeSpot);
            this.overflowNotificationTime = System.currentTimeMillis();
        }
        if (this.appendSegmentOffset > this.rolloverFence && this.file.canActivateNextSegment()) {
            this.overflowNotificationTime -= 500L;
            final FutureResult result = new FutureResult();
            try {
                this.executor.execute(new Runnable(){

                    public void run() {
                        try {
                            result.set((Object)LogFileManager.this.queuedActivateNextSegment());
                        }
                        catch (Throwable e) {
                            result.setException(e);
                        }
                    }
                });
                this.appendSegmentIndex = (Byte)result.get();
                this.appendSegmentOffset = 256;
            }
            catch (InterruptedException e) {
                throw (IOException)new IOException("Interrupted.").initCause(e);
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof IOException) {
                    throw (IOException)new IOException(e.getTargetException().getMessage()).initCause(e.getTargetException());
                }
                throw (IOException)new IOException("Unexpected Exception: ").initCause(e.getTargetException());
            }
        }
    }

    private Byte queuedActivateNextSegment() throws IOException {
        this.file.activateNextSegment();
        return new Byte(this.file.getAppendSegmentIndex());
    }

    public synchronized void setMark(RecordLocationImpl recordLocator, boolean force) throws InvalidRecordLocationException, InterruptedException, IOException {
        if (recordLocator == null) {
            throw new InvalidRecordLocationException("The location cannot be null.");
        }
        if (this.lastMarkedLocation != null && recordLocator.compareTo(this.lastMarkedLocation) < 0) {
            throw new InvalidRecordLocationException("The location is less than the last mark.");
        }
        this.lastMarkedLocation = recordLocator;
        Mark mark = new Mark(recordLocator);
        byte[] data = mark.writeExternal();
        this.write((byte)2, data, force, mark);
    }

    public RecordLocationImpl getMark() {
        return this.lastMarkedLocation;
    }

    public RecordLocationImpl getNextRecordLocation(final RecordLocationImpl lastLocation) throws IOException, InvalidRecordLocationException {
        if (lastLocation == null) {
            if (this.lastMarkedLocation != null) {
                return this.lastMarkedLocation;
            }
            byte safeSeg = this.file.getFirstActiveSegmentIndex();
            try {
                return this.file.readRecordLocation(new RecordLocationImpl(this.fileManagerId, safeSeg, 256));
            }
            catch (InvalidRecordLocationException e1) {
                return null;
            }
        }
        final FutureResult result = new FutureResult();
        try {
            this.executor.execute(new Runnable(){

                public void run() {
                    try {
                        result.set((Object)LogFileManager.this.queuedGetNextRecordLocation(lastLocation));
                    }
                    catch (Throwable e) {
                        result.setException(e);
                    }
                }
            });
            return (RecordLocationImpl)result.get();
        }
        catch (InterruptedException e) {
            throw (IOException)new IOException("Interrupted.").initCause(e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof InvalidRecordLocationException) {
                throw new InvalidRecordLocationException(e.getTargetException().getMessage(), e.getTargetException());
            }
            if (e.getTargetException() instanceof IOException) {
                throw (IOException)new IOException(e.getTargetException().getMessage()).initCause(e.getTargetException());
            }
            throw (IOException)new IOException("Unexpected Exception: ").initCause(e.getTargetException());
        }
    }

    private RecordLocationImpl queuedGetNextRecordLocation(RecordLocationImpl location) throws IOException, InvalidRecordLocationException {
        return this.file.getNextDataRecordLocation(location);
    }

    public byte[] read(final RecordLocationImpl location) throws IOException, InvalidRecordLocationException {
        final FutureResult result = new FutureResult();
        try {
            this.executor.execute(new Runnable(){

                public void run() {
                    try {
                        result.set((Object)LogFileManager.this.queuedRead(location));
                    }
                    catch (Throwable e) {
                        result.setException(e);
                    }
                }
            });
            return (byte[])result.get();
        }
        catch (InterruptedException e) {
            throw (IOException)new IOException("Interrupted.").initCause(e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof InvalidRecordLocationException) {
                throw new InvalidRecordLocationException(e.getTargetException().getMessage(), e.getTargetException());
            }
            if (e.getTargetException() instanceof IOException) {
                throw (IOException)new IOException(e.getTargetException().getMessage()).initCause(e.getTargetException());
            }
            throw (IOException)new IOException("Unexpected Exception: ").initCause(e.getTargetException());
        }
    }

    private byte[] queuedRead(RecordLocationImpl newLocation) throws IOException, InvalidRecordLocationException {
        int segmentOffset;
        byte segmentIndex;
        if (newLocation == null) {
            segmentIndex = this.markedSegmentIndex;
            segmentOffset = 256;
        } else {
            segmentIndex = newLocation.getSegmentIndex();
            segmentOffset = newLocation.getSegmentOffset();
        }
        return this.file.readData(segmentIndex, segmentOffset);
    }

    public void setJournalEventListener(JournalEventListener eventListener) {
        this.eventListener = eventListener;
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.executor.shutdownAfterProcessingCurrentlyQueuedTasks();
        try {
            this.file.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.closed = true;
    }

    public long getLastSequenceId() {
        return this.file.getLastSequenceId();
    }

    public File getLogDirectory() {
        return this.file.getLogDirectory();
    }

    public int getTotalSegements() {
        return this.file.getTotalSegements();
    }

    public int getInitialSegmentSize() {
        return this.file.getInitialSegmentSize();
    }
}

