/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.management;

import javax.jms.Message;
import org.codehaus.activemq.management.CountStatisticImpl;
import org.codehaus.activemq.management.JMSDestinationStats;
import org.codehaus.activemq.management.JMSEndpointStatsImpl;
import org.codehaus.activemq.management.TimeStatisticImpl;

public class JMSQueueStatsImpl
extends JMSEndpointStatsImpl
implements JMSDestinationStats {
    protected TimeStatisticImpl sendMessageRateTime;

    public JMSQueueStatsImpl() {
        this.sendMessageRateTime = new TimeStatisticImpl("sendMessageRateTime", "Time taken to send a message (publish thoughtput rate)");
        this.addStatistic("sendMessageRateTime", this.sendMessageRateTime);
    }

    public JMSQueueStatsImpl(CountStatisticImpl messageCount, CountStatisticImpl pendingMessageCount, CountStatisticImpl expiredMessageCount, TimeStatisticImpl messageWaitTime, TimeStatisticImpl messageRateTime, TimeStatisticImpl sendMessageRateTime) {
        super(messageCount, pendingMessageCount, expiredMessageCount, messageWaitTime, messageRateTime);
        this.sendMessageRateTime = sendMessageRateTime;
        this.addStatistic("sendMessageRateTime", sendMessageRateTime);
    }

    public void setPendingMessageCountOnStartup(long count) {
        CountStatisticImpl messageCount = (CountStatisticImpl)this.getPendingMessageCount();
        messageCount.setCount(count);
    }

    public void onMessageSend(Message message) {
        long start = this.pendingMessageCount.getLastSampleTime();
        this.pendingMessageCount.increment();
        long end = this.pendingMessageCount.getLastSampleTime();
        this.sendMessageRateTime.addTime(end - start);
    }

    public void onMessageAck() {
        long start = this.messageCount.getLastSampleTime();
        this.messageCount.increment();
        long end = this.messageCount.getLastSampleTime();
        this.messageRateTime.addTime(end - start);
    }
}

