/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.activemq.transport.ember;

import java.io.IOException;
import java.net.URI;
import javax.jms.JMSException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.activemq.io.WireFormat;
import org.codehaus.activemq.transport.TransportChannel;
import org.codehaus.activemq.transport.TransportChannelFactory;
import org.codehaus.activemq.transport.ember.EmberSupport;
import org.codehaus.activemq.transport.ember.EmberTransportChannel;
import org.codehaus.activemq.util.IdGenerator;
import pyrasun.eio.EIOGlobalContext;
import pyrasun.eio.EIOPoolingStrategy;
import pyrasun.eio.services.EmberService;
import pyrasun.eio.services.EmberServiceController;
import pyrasun.eio.services.EmberServiceException;
import pyrasun.eio.services.bytearray.ByteArrayClientService;
import pyrasun.eio.services.bytearray.ByteArrayServerClient;

public class EmberTransportChannelFactory
extends EmberSupport
implements TransportChannelFactory {
    protected static final Log log = LogFactory.getLog((Class)EmberTransportChannelFactory.class);
    private IdGenerator idGenerator = new IdGenerator();

    public EmberTransportChannelFactory() {
    }

    public EmberTransportChannelFactory(EIOGlobalContext context, EIOPoolingStrategy ioPoolingStrategy) {
        super(context, ioPoolingStrategy);
    }

    public TransportChannel create(WireFormat wireFormat, URI remoteLocation) throws JMSException {
        try {
            String id = this.idGenerator.generateId();
            EmberServiceController controller = this.getController();
            ByteArrayServerClient client = this.createClient(controller, remoteLocation, id);
            return new EmberTransportChannel(wireFormat, this.getContext(), controller, client);
        }
        catch (IOException ioe) {
            JMSException jmsEx = new JMSException("Initialization of TransportChannel failed: " + ioe);
            jmsEx.setLinkedException((Exception)ioe);
            throw jmsEx;
        }
        catch (EmberServiceException e) {
            JMSException jmsEx = new JMSException("Initialization of TransportChannel failed: " + (Object)((Object)e));
            jmsEx.setLinkedException((Exception)((Object)e));
            throw jmsEx;
        }
    }

    public TransportChannel create(WireFormat wireFormat, URI remoteLocation, URI localLocation) throws JMSException {
        return this.create(wireFormat, remoteLocation);
    }

    public boolean requiresEmbeddedBroker() {
        return false;
    }

    protected ByteArrayServerClient createClient(EmberServiceController controller, URI remoteLocation, String id) throws JMSException, EmberServiceException, IOException {
        ByteArrayClientService service = this.createNioService(controller);
        ByteArrayServerClient client = service.createClient(remoteLocation.getHost(), remoteLocation.getPort(), id, null);
        return client;
    }

    protected ByteArrayClientService createNioService(EmberServiceController controller) throws JMSException {
        ByteArrayClientService service;
        try {
            service = new ByteArrayClientService(this.getContext(), this.getIoPoolingStrategy());
            controller.addService((EmberService)service);
        }
        catch (IOException e) {
            throw this.createJMSException("Creation of NIO service failed: ", e);
        }
        return service;
    }
}

