/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.support;

import java.lang.reflect.Constructor;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jms.JmsException;
import org.springframework.jms.JmsSecurityException;
import org.springframework.jms.UncategorizedJmsException;
import org.springframework.util.ClassUtils;

public abstract class JmsUtils {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$jms$support$JmsUtils == null ? (class$org$springframework$jms$support$JmsUtils = JmsUtils.class$("org.springframework.jms.support.JmsUtils")) : class$org$springframework$jms$support$JmsUtils));
    static /* synthetic */ Class class$org$springframework$jms$support$JmsUtils;
    static /* synthetic */ Class class$javax$jms$JMSException;
    static /* synthetic */ Class class$org$springframework$jms$JmsException;

    public static void closeConnection(Connection con) {
        if (con != null) {
            try {
                con.close();
            }
            catch (JMSException ex) {
                logger.warn((Object)"Failed to close the connection", (Throwable)ex);
            }
        }
    }

    public static void closeSession(Session session) {
        if (session != null) {
            try {
                session.close();
            }
            catch (JMSException ex) {
                logger.warn((Object)"Failed to close the session", (Throwable)ex);
            }
        }
    }

    public static void closeMessageConsumer(MessageConsumer consumer) {
        if (consumer != null) {
            try {
                consumer.close();
            }
            catch (JMSException ex) {
                logger.warn((Object)"Failed to close the consumer", (Throwable)ex);
            }
        }
    }

    public static JmsException convertJmsAccessException(JMSException ex) {
        if (ex instanceof JMSSecurityException) {
            return new JmsSecurityException((JMSSecurityException)ex);
        }
        if ((class$javax$jms$JMSException == null ? (class$javax$jms$JMSException = JmsUtils.class$("javax.jms.JMSException")) : class$javax$jms$JMSException).equals(((Object)((Object)ex)).getClass().getSuperclass())) {
            String shortName = ClassUtils.getShortName((String)((Object)((Object)ex)).getClass().getName());
            String longName = (class$org$springframework$jms$JmsException == null ? (class$org$springframework$jms$JmsException = JmsUtils.class$("org.springframework.jms.JmsException")) : class$org$springframework$jms$JmsException).getPackage().getName() + "." + shortName;
            try {
                Class<?> clazz = Class.forName(longName);
                Constructor<?> ctor = clazz.getConstructor(((Object)((Object)ex)).getClass());
                Object counterpart = ctor.newInstance(new Object[]{ex});
                return (JmsException)((Object)counterpart);
            }
            catch (Throwable ex2) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Couldn't resolve JmsException class [" + longName + "]"), ex2);
                }
                return new UncategorizedJmsException(ex);
            }
        }
        return new UncategorizedJmsException(ex);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

