/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.burlap.io;

import com.caucho.burlap.io.AbstractBurlapInput;
import com.caucho.burlap.io.ArrayDeserializer;
import com.caucho.burlap.io.ArraySerializer;
import com.caucho.burlap.io.BasicDeserializer;
import com.caucho.burlap.io.BasicSerializer;
import com.caucho.burlap.io.BurlapProtocolException;
import com.caucho.burlap.io.ClassDeserializer;
import com.caucho.burlap.io.ClassSerializer;
import com.caucho.burlap.io.CollectionDeserializer;
import com.caucho.burlap.io.CollectionSerializer;
import com.caucho.burlap.io.Deserializer;
import com.caucho.burlap.io.JavaDeserializer;
import com.caucho.burlap.io.JavaSerializer;
import com.caucho.burlap.io.MapDeserializer;
import com.caucho.burlap.io.MapSerializer;
import com.caucho.burlap.io.RemoteSerializer;
import com.caucho.burlap.io.Serializer;
import com.caucho.burlap.io.SqlDateDeserializer;
import com.caucho.burlap.io.SqlDateSerializer;
import com.caucho.burlap.io.StackTraceElementDeserializer;
import com.caucho.burlap.io.StringValueDeserializer;
import com.caucho.burlap.io.StringValueSerializer;
import java.io.IOException;
import java.util.HashMap;

public class SerializerFactory {
    private static HashMap serializerMap = new HashMap();
    private static HashMap deserializerMap = new HashMap();
    private static HashMap typeMap = new HashMap();
    private Serializer defaultSerializer;
    static /* synthetic */ Class class$com$caucho$burlap$io$BurlapRemoteObject;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$util$ArrayList;
    static /* synthetic */ Class class$java$util$HashMap;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class array$Z;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class array$S;
    static /* synthetic */ Class array$I;
    static /* synthetic */ Class array$J;
    static /* synthetic */ Class array$F;
    static /* synthetic */ Class array$D;
    static /* synthetic */ Class array$C;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class array$Ljava$lang$Object;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;

    public Serializer getSerializer(Class cl) throws BurlapProtocolException {
        Serializer serializer = (Serializer)serializerMap.get(cl);
        if (serializer != null) {
            return serializer;
        }
        if ((class$com$caucho$burlap$io$BurlapRemoteObject == null ? (class$com$caucho$burlap$io$BurlapRemoteObject = SerializerFactory.class$("com.caucho.burlap.io.BurlapRemoteObject")) : class$com$caucho$burlap$io$BurlapRemoteObject).isAssignableFrom(cl)) {
            return new RemoteSerializer();
        }
        if ((class$java$util$Map == null ? (class$java$util$Map = SerializerFactory.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(cl)) {
            return new MapSerializer();
        }
        if ((class$java$util$Collection == null ? (class$java$util$Collection = SerializerFactory.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(cl)) {
            return new CollectionSerializer();
        }
        if (cl.isArray()) {
            return new ArraySerializer();
        }
        return this.getDefaultSerializer(cl);
    }

    public Serializer getDefaultSerializer(Class cl) {
        if (this.defaultSerializer == null) {
            this.defaultSerializer = new JavaSerializer();
        }
        return this.defaultSerializer;
    }

    public Deserializer getDeserializer(Class cl) throws BurlapProtocolException {
        Deserializer deserializer = (Deserializer)deserializerMap.get(cl);
        if (deserializer != null) {
            return deserializer;
        }
        if (cl == null || (class$java$lang$Object == null ? (class$java$lang$Object = SerializerFactory.class$("java.lang.Object")) : class$java$lang$Object).equals(cl)) {
            return new MapDeserializer(null);
        }
        if ((class$java$util$Collection == null ? (class$java$util$Collection = SerializerFactory.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(cl)) {
            return new CollectionDeserializer(cl);
        }
        if ((class$java$util$Map == null ? (class$java$util$Map = SerializerFactory.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(cl)) {
            return new MapDeserializer(cl);
        }
        if (cl.isArray()) {
            return new ArrayDeserializer(this.getDeserializer(cl.getComponentType()));
        }
        return new JavaDeserializer(cl);
    }

    public Object readList(AbstractBurlapInput in, int length, String type) throws BurlapProtocolException, IOException {
        Deserializer deserializer = this.getDeserializer(type);
        if (deserializer != null) {
            return deserializer.readList(in, length);
        }
        return new CollectionDeserializer(class$java$util$ArrayList == null ? (class$java$util$ArrayList = SerializerFactory.class$("java.util.ArrayList")) : class$java$util$ArrayList).readList(in, length);
    }

    public Object readMap(AbstractBurlapInput in, String type) throws BurlapProtocolException, IOException {
        Deserializer deserializer = this.getDeserializer(type);
        if (deserializer != null) {
            return deserializer.readMap(in);
        }
        return new MapDeserializer(class$java$util$HashMap == null ? (class$java$util$HashMap = SerializerFactory.class$("java.util.HashMap")) : class$java$util$HashMap).readMap(in);
    }

    public Deserializer getObjectDeserializer(String type) throws BurlapProtocolException {
        Deserializer deserializer = this.getDeserializer(type);
        if (deserializer != null) {
            return deserializer;
        }
        return new MapDeserializer(class$java$util$HashMap == null ? (class$java$util$HashMap = SerializerFactory.class$("java.util.HashMap")) : class$java$util$HashMap);
    }

    public Deserializer getDeserializer(String type) throws BurlapProtocolException {
        if (type == null || type.equals("")) {
            return null;
        }
        Deserializer deserializer = (Deserializer)typeMap.get(type);
        if (deserializer != null) {
            return deserializer;
        }
        if (type.startsWith("[")) {
            Deserializer subDeserializer = this.getDeserializer(type.substring(1));
            return new ArrayDeserializer(subDeserializer);
        }
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> cl = Class.forName(type, false, loader);
            return this.getDeserializer(cl);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static void addBasic(Class cl, String typeName, int type) {
        serializerMap.put(cl, new BasicSerializer(type));
        BasicDeserializer deserializer = new BasicDeserializer(type);
        deserializerMap.put(cl, deserializer);
        typeMap.put(typeName, deserializer);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        SerializerFactory.addBasic(class$java$lang$Boolean == null ? (class$java$lang$Boolean = SerializerFactory.class$("java.lang.Boolean")) : class$java$lang$Boolean, "boolean", 1);
        SerializerFactory.addBasic(class$java$lang$Byte == null ? (class$java$lang$Byte = SerializerFactory.class$("java.lang.Byte")) : class$java$lang$Byte, "byte", 2);
        SerializerFactory.addBasic(class$java$lang$Short == null ? (class$java$lang$Short = SerializerFactory.class$("java.lang.Short")) : class$java$lang$Short, "short", 3);
        SerializerFactory.addBasic(class$java$lang$Integer == null ? (class$java$lang$Integer = SerializerFactory.class$("java.lang.Integer")) : class$java$lang$Integer, "int", 4);
        SerializerFactory.addBasic(class$java$lang$Long == null ? (class$java$lang$Long = SerializerFactory.class$("java.lang.Long")) : class$java$lang$Long, "long", 5);
        SerializerFactory.addBasic(class$java$lang$Float == null ? (class$java$lang$Float = SerializerFactory.class$("java.lang.Float")) : class$java$lang$Float, "float", 6);
        SerializerFactory.addBasic(class$java$lang$Double == null ? (class$java$lang$Double = SerializerFactory.class$("java.lang.Double")) : class$java$lang$Double, "double", 7);
        SerializerFactory.addBasic(class$java$lang$Character == null ? (class$java$lang$Character = SerializerFactory.class$("java.lang.Character")) : class$java$lang$Character, "char", 8);
        SerializerFactory.addBasic(class$java$lang$String == null ? (class$java$lang$String = SerializerFactory.class$("java.lang.String")) : class$java$lang$String, "string", 9);
        SerializerFactory.addBasic(class$java$util$Date == null ? (class$java$util$Date = SerializerFactory.class$("java.util.Date")) : class$java$util$Date, "date", 10);
        SerializerFactory.addBasic(Boolean.TYPE, "boolean", 1);
        SerializerFactory.addBasic(Byte.TYPE, "byte", 2);
        SerializerFactory.addBasic(Short.TYPE, "short", 3);
        SerializerFactory.addBasic(Integer.TYPE, "int", 4);
        SerializerFactory.addBasic(Long.TYPE, "long", 5);
        SerializerFactory.addBasic(Float.TYPE, "float", 6);
        SerializerFactory.addBasic(Double.TYPE, "double", 7);
        SerializerFactory.addBasic(Character.TYPE, "char", 8);
        SerializerFactory.addBasic(array$Z == null ? (array$Z = SerializerFactory.class$("[Z")) : array$Z, "[boolean", 11);
        SerializerFactory.addBasic(array$B == null ? (array$B = SerializerFactory.class$("[B")) : array$B, "[byte", 12);
        SerializerFactory.addBasic(array$S == null ? (array$S = SerializerFactory.class$("[S")) : array$S, "[short", 13);
        SerializerFactory.addBasic(array$I == null ? (array$I = SerializerFactory.class$("[I")) : array$I, "[int", 14);
        SerializerFactory.addBasic(array$J == null ? (array$J = SerializerFactory.class$("[J")) : array$J, "[long", 15);
        SerializerFactory.addBasic(array$F == null ? (array$F = SerializerFactory.class$("[F")) : array$F, "[float", 16);
        SerializerFactory.addBasic(array$D == null ? (array$D = SerializerFactory.class$("[D")) : array$D, "[double", 17);
        SerializerFactory.addBasic(array$C == null ? (array$C = SerializerFactory.class$("[C")) : array$C, "[char", 18);
        SerializerFactory.addBasic(array$Ljava$lang$String == null ? (array$Ljava$lang$String = SerializerFactory.class$("[Ljava.lang.String;")) : array$Ljava$lang$String, "[string", 19);
        SerializerFactory.addBasic(array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = SerializerFactory.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object, "[object", 20);
        serializerMap.put(class$java$lang$Class == null ? (class$java$lang$Class = SerializerFactory.class$("java.lang.Class")) : class$java$lang$Class, new ClassSerializer());
        deserializerMap.put(class$java$lang$Class == null ? (class$java$lang$Class = SerializerFactory.class$("java.lang.Class")) : class$java$lang$Class, new ClassDeserializer());
        serializerMap.put(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = SerializerFactory.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, new StringValueSerializer());
        try {
            deserializerMap.put(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = SerializerFactory.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, new StringValueDeserializer(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = SerializerFactory.class$("java.math.BigDecimal")) : class$java$math$BigDecimal));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        serializerMap.put(class$java$sql$Date == null ? (class$java$sql$Date = SerializerFactory.class$("java.sql.Date")) : class$java$sql$Date, new SqlDateSerializer());
        serializerMap.put(class$java$sql$Time == null ? (class$java$sql$Time = SerializerFactory.class$("java.sql.Time")) : class$java$sql$Time, new SqlDateSerializer());
        serializerMap.put(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = SerializerFactory.class$("java.sql.Timestamp")) : class$java$sql$Timestamp, new SqlDateSerializer());
        try {
            deserializerMap.put(class$java$sql$Date == null ? (class$java$sql$Date = SerializerFactory.class$("java.sql.Date")) : class$java$sql$Date, new SqlDateDeserializer(class$java$sql$Date == null ? (class$java$sql$Date = SerializerFactory.class$("java.sql.Date")) : class$java$sql$Date));
            deserializerMap.put(class$java$sql$Time == null ? (class$java$sql$Time = SerializerFactory.class$("java.sql.Time")) : class$java$sql$Time, new SqlDateDeserializer(class$java$sql$Time == null ? (class$java$sql$Time = SerializerFactory.class$("java.sql.Time")) : class$java$sql$Time));
            deserializerMap.put(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = SerializerFactory.class$("java.sql.Timestamp")) : class$java$sql$Timestamp, new SqlDateDeserializer(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = SerializerFactory.class$("java.sql.Timestamp")) : class$java$sql$Timestamp));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            Class<?> stackTrace = Class.forName("java.lang.StackTraceElement");
            deserializerMap.put(stackTrace, new StackTraceElementDeserializer());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

