/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.el;

import com.caucho.el.ArrayExpr;
import com.caucho.el.ELException;
import com.caucho.el.StaticMethodExpr;
import com.caucho.el.StringLiteral;
import com.caucho.el.VariableResolver;
import com.caucho.util.BeanUtil;
import com.caucho.util.IntMap;
import com.caucho.util.L10N;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Map;

public abstract class Expr {
    protected static WriteStream dbg = LogStream.open("/caucho.com/el/eval");
    protected static L10N L = new L10N(class$com$caucho$el$Expr == null ? (class$com$caucho$el$Expr = Expr.class$("com.caucho.el.Expr")) : class$com$caucho$el$Expr);
    private static final long DAY = 86400000L;
    static final int ADD = 1;
    static final int SUB = 2;
    static final int MUL = 3;
    static final int DIV = 4;
    static final int MOD = 5;
    static final int EQ = 6;
    static final int NE = 7;
    static final int LT = 8;
    static final int LE = 9;
    static final int GT = 10;
    static final int GE = 11;
    static final int AND = 12;
    static final int OR = 13;
    static final int NOT = 14;
    static final int MINUS = 15;
    static final int EMPTY = 16;
    static final int OBJECT = 0;
    static final int BOOLEAN = 1;
    static final int BYTE = 2;
    static final int SHORT = 3;
    static final int INT = 4;
    static final int LONG = 5;
    static final int FLOAT = 6;
    static final int DOUBLE = 7;
    static final int BOOLEAN_OBJ = 8;
    static final int BYTE_OBJ = 9;
    static final int SHORT_OBJ = 10;
    static final int INT_OBJ = 11;
    static final int LONG_OBJ = 12;
    static final int FLOAT_OBJ = 13;
    static final int DOUBLE_OBJ = 14;
    static final int STRING = 15;
    static final IntMap _typeMap = new IntMap();
    static /* synthetic */ Class class$com$caucho$el$Expr;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$String;

    public boolean isConstant() {
        return false;
    }

    public Expr createField(Expr field) {
        return new ArrayExpr(this, field);
    }

    public Expr createField(String field) {
        return this.createField(new StringLiteral(field));
    }

    public Expr createMethod(Expr[] args) {
        return new StaticMethodExpr(this, args);
    }

    public abstract Object evalObject(VariableResolver var1) throws ELException;

    public boolean evalBoolean(VariableResolver env) throws ELException {
        return Expr.toBoolean(this.evalObject(env));
    }

    public double evalDouble(VariableResolver env) throws ELException {
        return Expr.toDouble(this.evalObject(env));
    }

    public long evalLong(VariableResolver env) throws ELException {
        return Expr.toLong(this.evalObject(env));
    }

    public String evalString(VariableResolver env) throws ELException {
        return Expr.toString(this.evalObject(env));
    }

    public long evalPeriod(VariableResolver env) throws ELException {
        return Expr.toPeriod(this.evalObject(env));
    }

    public boolean print(WriteStream out, VariableResolver env, boolean escapeXml) throws IOException, ELException {
        Object obj = this.evalObject(env);
        if (obj == null) {
            return true;
        }
        if (escapeXml) {
            Expr.toStreamEscaped(out, obj);
            return false;
        }
        Expr.toStream(out, obj);
        return false;
    }

    public void printCreate(WriteStream os) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public static String toString(Object value) {
        if (value == null || value instanceof String) {
            return (String)value;
        }
        return value.toString();
    }

    public static boolean toBoolean(Object value) {
        if (value == null || value.equals("")) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return value.equals("true");
        }
        dbg.log(L.l("can't convert {0} to boolean.", value.getClass().getName()));
        return false;
    }

    public static double toDouble(Object value) {
        if (value == null) {
            return 0.0;
        }
        if (value instanceof Number) {
            double dValue = ((Number)value).doubleValue();
            if (Double.isNaN(dValue)) {
                return 0.0;
            }
            return dValue;
        }
        if (value.equals("")) {
            return 0.0;
        }
        if (value instanceof String) {
            double dValue = Double.parseDouble((String)value);
            if (Double.isNaN(dValue)) {
                return 0.0;
            }
            return dValue;
        }
        dbg.log(L.l("can't convert {0} to double.", value.getClass().getName()));
        return 0.0;
    }

    public static long toLong(Object value) throws ELException {
        if (value == null) {
            return 0L;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value.equals("")) {
            return 0L;
        }
        if (value instanceof String) {
            return Long.parseLong((String)value);
        }
        dbg.log(L.l("can't convert {0} to long.", value.getClass().getName()));
        return 0L;
    }

    public static long toPeriod(Object objValue) throws ELException {
        if (objValue == null) {
            return 0L;
        }
        if (objValue instanceof Number) {
            return ((Number)objValue).longValue();
        }
        if (objValue.equals("")) {
            return 0L;
        }
        if (!(objValue instanceof String)) {
            dbg.log(L.l("can't convert {0} to period.", objValue.getClass().getName()));
            return 0L;
        }
        String value = (String)objValue;
        long sign = 1L;
        long period = 0L;
        int i = 0;
        int length = value.length();
        if (length > 0 && value.charAt(i) == '-') {
            sign = -1L;
            ++i;
        }
        block9: while (i < length) {
            char ch;
            long delta = 0L;
            while (i < length && (ch = value.charAt(i)) >= '0' && ch <= '9') {
                delta = 10L * delta + (long)ch - 48L;
                ++i;
            }
            if (length <= i) {
                period += 1000L * delta;
                continue;
            }
            switch (value.charAt(i++)) {
                case 'S': 
                case 's': {
                    period += 1000L * delta;
                    continue block9;
                }
                case 'm': {
                    period += 60000L * delta;
                    continue block9;
                }
                case 'H': 
                case 'h': {
                    period += 3600000L * delta;
                    continue block9;
                }
                case 'D': 
                case 'd': {
                    period += 86400000L * delta;
                    continue block9;
                }
                case 'W': 
                case 'w': {
                    period += 604800000L * delta;
                    continue block9;
                }
                case 'M': {
                    period += 2592000000L * delta;
                    continue block9;
                }
                case 'Y': 
                case 'y': {
                    period += 31536000000L * delta;
                    continue block9;
                }
            }
            throw new ELException(L.l("unknown character `{0}' in period", value));
        }
        return sign * period;
    }

    public static void toStream(WriteStream out, Object value) throws IOException {
        if (value == null) {
            return;
        }
        if (value instanceof String) {
            out.print((String)value);
        } else {
            out.print(value.toString());
        }
    }

    public static void printEscapedString(WriteStream os, String string) throws IOException {
        block6: for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            switch (ch) {
                case '\\': {
                    os.print("\\\\");
                    continue block6;
                }
                case '\n': {
                    os.print("\\n");
                    continue block6;
                }
                case '\r': {
                    os.print("\\r");
                    continue block6;
                }
                case '\"': {
                    os.print("\\\"");
                    continue block6;
                }
                default: {
                    os.print(ch);
                }
            }
        }
    }

    public static void printEscaped(WriteStream os, ReadStream is) throws IOException {
        int ch;
        block6: while ((ch = is.readChar()) >= 0) {
            switch (ch) {
                case 92: {
                    os.print("\\\\");
                    continue block6;
                }
                case 10: {
                    os.print("\\n");
                    continue block6;
                }
                case 13: {
                    os.print("\\r");
                    continue block6;
                }
                case 34: {
                    os.print("\\\"");
                    continue block6;
                }
            }
            os.print((char)ch);
        }
    }

    public static void toStreamEscaped(WriteStream out, Object value) throws IOException {
        if (value == null) {
            return;
        }
        String string = value.toString();
        block7: for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            switch (ch) {
                case '<': {
                    out.print("&lt;");
                    continue block7;
                }
                case '>': {
                    out.print("&gt;");
                    continue block7;
                }
                case '&': {
                    out.print("&amp;");
                    continue block7;
                }
                case '\'': {
                    out.print("&#039;");
                    continue block7;
                }
                case '\"': {
                    out.print("&#034;");
                    continue block7;
                }
                default: {
                    out.print(ch);
                }
            }
        }
    }

    public static void setProperty(Object target, String property, Object value) throws ELException {
        if (target instanceof Map) {
            Map map = (Map)target;
            if (value != null) {
                map.put(property, value);
            } else {
                map.remove(property);
            }
        } else if (target != null) {
            Method method = null;
            try {
                method = BeanUtil.getSetMethod(target.getClass(), property);
            }
            catch (Exception e) {
                throw new ELException(e);
            }
            if (method == null) {
                throw new ELException(L.l("can't find property `{0}' in `{1}'", (Object)property, target.getClass()));
            }
            Class<?> type = method.getParameterTypes()[0];
            try {
                int code = _typeMap.get(type);
                switch (code) {
                    case 1: {
                        value = Expr.toBoolean(value) ? Boolean.TRUE : Boolean.FALSE;
                        break;
                    }
                    case 2: {
                        value = new Byte((byte)Expr.toLong(value));
                        break;
                    }
                    case 3: {
                        value = new Short((short)Expr.toLong(value));
                        break;
                    }
                    case 4: {
                        value = new Integer((int)Expr.toLong(value));
                        break;
                    }
                    case 5: {
                        value = new Long(Expr.toLong(value));
                        break;
                    }
                    case 6: {
                        value = new Float((float)Expr.toDouble(value));
                        break;
                    }
                    case 7: {
                        value = new Double(Expr.toDouble(value));
                        break;
                    }
                    case 8: {
                        if (value == null) break;
                        value = Expr.toBoolean(value) ? Boolean.TRUE : Boolean.FALSE;
                        break;
                    }
                    case 9: {
                        if (value == null) break;
                        value = new Byte((byte)Expr.toLong(value));
                        break;
                    }
                    case 10: {
                        if (value == null) break;
                        value = new Short((short)Expr.toLong(value));
                        break;
                    }
                    case 11: {
                        if (value == null) break;
                        value = new Integer((int)Expr.toLong(value));
                        break;
                    }
                    case 12: {
                        if (value == null) break;
                        value = new Long(Expr.toLong(value));
                        break;
                    }
                    case 13: {
                        if (value == null) break;
                        value = new Float((float)Expr.toDouble(value));
                        break;
                    }
                    case 14: {
                        if (value == null) break;
                        value = new Double(Expr.toDouble(value));
                        break;
                    }
                    case 15: {
                        if (value == null) break;
                        value = String.valueOf(value);
                        break;
                    }
                }
                method.invoke(target, value);
            }
            catch (Exception e) {
                throw new ELException(e);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        _typeMap.put(Boolean.TYPE, 1);
        _typeMap.put(Byte.TYPE, 2);
        _typeMap.put(Short.TYPE, 3);
        _typeMap.put(Integer.TYPE, 4);
        _typeMap.put(Long.TYPE, 5);
        _typeMap.put(Float.TYPE, 6);
        _typeMap.put(Double.TYPE, 7);
        _typeMap.put(class$java$lang$Boolean == null ? (class$java$lang$Boolean = Expr.class$("java.lang.Boolean")) : class$java$lang$Boolean, 8);
        _typeMap.put(class$java$lang$Byte == null ? (class$java$lang$Byte = Expr.class$("java.lang.Byte")) : class$java$lang$Byte, 9);
        _typeMap.put(class$java$lang$Short == null ? (class$java$lang$Short = Expr.class$("java.lang.Short")) : class$java$lang$Short, 10);
        _typeMap.put(class$java$lang$Integer == null ? (class$java$lang$Integer = Expr.class$("java.lang.Integer")) : class$java$lang$Integer, 11);
        _typeMap.put(class$java$lang$Long == null ? (class$java$lang$Long = Expr.class$("java.lang.Long")) : class$java$lang$Long, 12);
        _typeMap.put(class$java$lang$Float == null ? (class$java$lang$Float = Expr.class$("java.lang.Float")) : class$java$lang$Float, 13);
        _typeMap.put(class$java$lang$Double == null ? (class$java$lang$Double = Expr.class$("java.lang.Double")) : class$java$lang$Double, 14);
        _typeMap.put(class$java$lang$String == null ? (class$java$lang$String = Expr.class$("java.lang.String")) : class$java$lang$String, 15);
    }
}

