/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es;

import com.caucho.es.Call;
import com.caucho.es.ESBase;
import com.caucho.es.ESDate;
import com.caucho.es.ESException;
import com.caucho.es.ESId;
import com.caucho.es.ESNumber;
import com.caucho.es.ESObject;
import com.caucho.es.ESString;
import com.caucho.es.Global;
import com.caucho.es.Native;
import com.caucho.es.NativeWrapper;
import com.caucho.util.QDate;

class NativeDate
extends Native {
    static final int NEW = 2;
    static final int UTC = 3;
    static final int VALUE_OF = 4;
    static final int TO_STRING = 6;
    static final int TO_UTC_STRING = 7;
    static final int TO_ISO_STRING = 8;
    static final int TO_UTC_ISO_STRING = 9;
    static final int TO_ISO_DATE = 10;
    static final int TO_UTC_ISO_DATE = 11;
    static final int TO_LOCALE_STRING = 12;
    static final int UTC_FORMAT = 13;
    static final int FORMAT = 14;
    static final int PARSE_DATE = 15;
    static final int GET_FULL_YEAR = 20;
    static final int GET_UTC_FULL_YEAR = 21;
    static final int GET_MONTH = 22;
    static final int GET_UTC_MONTH = 23;
    static final int GET_DATE = 24;
    static final int GET_UTC_DATE = 25;
    static final int GET_DAY = 26;
    static final int GET_UTC_DAY = 27;
    static final int GET_HOURS = 28;
    static final int GET_UTC_HOURS = 29;
    static final int GET_MINUTES = 30;
    static final int GET_UTC_MINUTES = 31;
    static final int GET_SECONDS = 32;
    static final int GET_UTC_SECONDS = 33;
    static final int GET_MILLISECONDS = 34;
    static final int GET_UTC_MILLISECONDS = 35;
    static final int GET_TIMEZONE_OFFSET = 36;
    static final int SET_FULL_YEAR = 50;
    static final int SET_UTC_FULL_YEAR = 51;
    static final int SET_MONTH = 52;
    static final int SET_UTC_MONTH = 53;
    static final int SET_DATE = 54;
    static final int SET_UTC_DATE = 55;
    static final int SET_HOURS = 56;
    static final int SET_UTC_HOURS = 57;
    static final int SET_MINUTES = 58;
    static final int SET_UTC_MINUTES = 59;
    static final int SET_SECONDS = 60;
    static final int SET_UTC_SECONDS = 61;
    static final int SET_MILLISECONDS = 62;
    static final int SET_UTC_MILLISECONDS = 63;
    static final int GET_MONTH_NAME = 64;
    static final int GET_UTC_MONTH_NAME = 65;
    private static String[] monthNames = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    QDate cal;

    private NativeDate(String name, int n, int len, QDate cal) {
        super(name, len);
        this.n = n;
        this.cal = cal;
    }

    static ESObject create(Global resin) {
        QDate cal = new QDate();
        NativeDate nativeDate = new NativeDate("Date", 2, 7, cal);
        ESDate dateProto = new ESDate(Long.MAX_VALUE, (ESBase)resin.objProto);
        NativeWrapper date = new NativeWrapper(resin, nativeDate, dateProto, 13);
        nativeDate.newN = nativeDate.n;
        resin.dateProto = dateProto;
        NativeDate.put(dateProto, "toString", 6, 0, cal);
        NativeDate.put(dateProto, "getTime", 4, 0, cal);
        NativeDate.put(dateProto, "valueOf", 4, 0, cal);
        NativeDate.put(dateProto, "toUTCString", 7, 0, cal);
        NativeDate.put(dateProto, "toGMTString", 7, 0, cal);
        NativeDate.put(dateProto, "toLocalISO8601", 8, 0, cal);
        NativeDate.put(dateProto, "toISO8601", 9, 0, cal);
        NativeDate.put(dateProto, "format", 14, 0, cal);
        NativeDate.put(dateProto, "UTCFormat", 13, 0, cal);
        NativeDate.put(dateProto, "toLocaleString", 12, 0, cal);
        NativeDate.put(dateProto, "getUTCYear", 21, 0, cal);
        NativeDate.put(dateProto, "getUTCFullYear", 21, 0, cal);
        NativeDate.put(dateProto, "getUTCMonth", 23, 0, cal);
        NativeDate.put(dateProto, "getUTCDate", 25, 0, cal);
        NativeDate.put(dateProto, "getUTCDay", 27, 0, cal);
        NativeDate.put(dateProto, "getUTCHours", 29, 0, cal);
        NativeDate.put(dateProto, "getUTCMinutes", 31, 0, cal);
        NativeDate.put(dateProto, "getUTCSeconds", 33, 0, cal);
        NativeDate.put(dateProto, "getUTCMilliseconds", 35, 0, cal);
        NativeDate.put(dateProto, "setUTCYear", 51, 1, cal);
        NativeDate.put(dateProto, "setUTCFullYear", 51, 1, cal);
        NativeDate.put(dateProto, "setUTCMonth", 53, 2, cal);
        NativeDate.put(dateProto, "setUTCDate", 55, 3, cal);
        NativeDate.put(dateProto, "setUTCHours", 57, 4, cal);
        NativeDate.put(dateProto, "setUTCMinutes", 59, 3, cal);
        NativeDate.put(dateProto, "setUTCSeconds", 61, 2, cal);
        NativeDate.put(dateProto, "setUTCMilliseconds", 63, 1, cal);
        NativeDate.put(dateProto, "getYear", 20, 0, cal);
        NativeDate.put(dateProto, "getFullYear", 20, 0, cal);
        NativeDate.put(dateProto, "getMonth", 22, 0, cal);
        NativeDate.put(dateProto, "getMonthName", 64, 0, cal);
        NativeDate.put(dateProto, "getDate", 24, 0, cal);
        NativeDate.put(dateProto, "getDay", 26, 0, cal);
        NativeDate.put(dateProto, "getHours", 28, 0, cal);
        NativeDate.put(dateProto, "getMinutes", 30, 0, cal);
        NativeDate.put(dateProto, "getSeconds", 32, 0, cal);
        NativeDate.put(dateProto, "getMilliseconds", 34, 0, cal);
        NativeDate.put(dateProto, "getTimezoneOffset", 36, 0, cal);
        NativeDate.put(dateProto, "setYear", 50, 3, cal);
        NativeDate.put(dateProto, "setFullYear", 50, 3, cal);
        NativeDate.put(dateProto, "setMonth", 52, 2, cal);
        NativeDate.put(dateProto, "setDate", 54, 1, cal);
        NativeDate.put(dateProto, "setHours", 56, 4, cal);
        NativeDate.put(dateProto, "setMinutes", 58, 3, cal);
        NativeDate.put(dateProto, "setSeconds", 60, 2, cal);
        NativeDate.put(dateProto, "setMilliseconds", 62, 1, cal);
        NativeDate.put(date, "UTC", 3, 7, cal);
        NativeDate.put(date, "parse", 15, 1, cal);
        dateProto.setClean();
        date.setClean();
        return date;
    }

    private static void put(ESObject obj, String name, int n, int len, QDate cal) {
        obj.put(ESId.intern(name), (ESBase)new NativeDate(name, n, len, cal), 4);
    }

    public ESBase call(Call eval, int length) throws Throwable {
        long time = 0L;
        if (this.cal == null) {
            this.cal = new QDate();
        }
        QDate qDate = this.cal;
        synchronized (qDate) {
            int off = 0;
            switch (this.n) {
                case 2: {
                    return ESDate.create(this.create(eval, length, this.n));
                }
                case 3: {
                    return ESNumber.create(this.create(eval, length, this.n));
                }
                case 6: 
                case 7: {
                    ESBase error = this.calculate(eval.getArg(-1), 1, this.n);
                    if (error != null) {
                        return error;
                    }
                    return ESString.create(this.cal.printDate());
                }
                case 8: 
                case 9: {
                    ESBase error = this.calculate(eval.getArg(-1), 1, this.n);
                    if (error != null) {
                        return error;
                    }
                    return ESString.create(this.cal.printISO8601());
                }
                case 10: 
                case 11: {
                    ESBase error = this.calculate(eval.getArg(-1), 1, this.n);
                    if (error != null) {
                        return error;
                    }
                    return ESString.create(this.cal.printISO8601Date());
                }
                case 13: 
                case 14: {
                    ESBase error = this.calculate(eval.getArg(-1), 1, this.n);
                    if (error != null) {
                        return error;
                    }
                    return ESString.create(this.cal.format(eval.getArgString(0, length)));
                }
                case 12: {
                    ESBase error = this.calculate(eval.getArg(-1), 1, 6);
                    if (error != null) {
                        return error;
                    }
                    return ESString.create(this.cal.printLocaleDate());
                }
                case 4: {
                    if (!(eval.getArg(-1) instanceof ESDate)) {
                        throw new ESException("valueOf must be bound to date");
                    }
                    double value = ((ESDate)eval.getArg((int)-1)).time;
                    if (value > 8.64E15 || value < -8.64E15 || Double.isNaN(value)) {
                        value = Double.NaN;
                    }
                    return ESNumber.create(value);
                }
                case 15: {
                    if (length < 0) {
                        return ESNumber.NaN;
                    }
                    try {
                        long lvalue = this.cal.parseDate(eval.getArg(0).toStr().toString());
                        return ESNumber.create(this.millisToDouble(lvalue));
                    }
                    catch (Exception e) {
                        throw new ESException(e.toString());
                    }
                }
                case 20: 
                case 21: {
                    ESBase error = this.calculate(eval.getArg(-1), 1, this.n);
                    if (error != null) {
                        return error;
                    }
                    return ESNumber.create(this.cal.get(0));
                }
                case 22: 
                case 23: {
                    ESBase error = this.calculate(eval.getArg(-1), 1, this.n);
                    if (error != null) {
                        return error;
                    }
                    return ESNumber.create(this.cal.get(1));
                }
                case 64: 
                case 65: {
                    ESBase error = this.calculate(eval.getArg(-1), 1, this.n);
                    if (error != null) {
                        return error;
                    }
                    int month = (int)this.cal.get(1);
                    return ESString.create(monthNames[month]);
                }
                case 24: 
                case 25: {
                    ESBase error = this.calculate(eval.getArg(-1), 1, this.n);
                    if (error != null) {
                        return error;
                    }
                    return ESNumber.create((double)this.cal.get(2) + 1.0);
                }
                case 26: 
                case 27: {
                    ESBase error = this.calculate(eval.getArg(-1), 1, this.n);
                    if (error != null) {
                        return error;
                    }
                    return ESNumber.create(this.cal.get(3));
                }
                case 28: 
                case 29: {
                    ESBase error = this.calculate(eval.getArg(-1), 1, this.n);
                    if (error != null) {
                        return error;
                    }
                    return ESNumber.create(this.cal.get(5));
                }
                case 30: 
                case 31: {
                    ESBase error = this.calculate(eval.getArg(-1), 1, this.n);
                    if (error != null) {
                        return error;
                    }
                    return ESNumber.create(this.cal.get(6));
                }
                case 32: 
                case 33: {
                    ESBase error = this.calculate(eval.getArg(-1), 1, this.n);
                    if (error != null) {
                        return error;
                    }
                    return ESNumber.create(this.cal.get(7));
                }
                case 34: 
                case 35: {
                    ESBase error = this.calculate(eval.getArg(-1), 1, this.n);
                    if (error != null) {
                        return error;
                    }
                    return ESNumber.create(this.cal.get(8));
                }
                case 36: {
                    ESBase error = this.calculate(eval.getArg(-1), 1, this.n);
                    if (error != null) {
                        return error;
                    }
                    return ESNumber.create(this.cal.getZoneOffset() / 60000L);
                }
                case 54: 
                case 55: {
                    --off;
                }
                case 52: 
                case 53: {
                    --off;
                }
                case 50: 
                case 51: {
                    double value;
                    ESBase error = this.calculate(eval.getArg(-1), length, this.n);
                    if (error != null) {
                        return error;
                    }
                    if (0 <= off) {
                        this.cal.set(0, (long)eval.getArg(off).toNum());
                    }
                    if (0 <= off + 1 && off + 1 < length) {
                        value = eval.getArg(off + 1).toNum();
                        this.cal.set(1, (long)(Double.isNaN(value) ? 9.223372036854776E18 : value));
                    }
                    if (0 <= off + 2 && off + 2 < length) {
                        value = eval.getArg(off + 2).toNum();
                        this.cal.set(2, (long)(Double.isNaN(value) ? 9.223372036854776E18 : value - 1.0));
                    }
                    return this.create(eval.getArg(-1), this.n);
                }
                case 62: 
                case 63: {
                    --off;
                }
                case 60: 
                case 61: {
                    --off;
                }
                case 58: 
                case 59: {
                    --off;
                }
                case 56: 
                case 57: {
                    double value;
                    ESBase error = this.calculate(eval.getArg(-1), length, this.n);
                    if (error != null) {
                        return error;
                    }
                    if (0 <= off) {
                        value = eval.getArg(off).toNum();
                        this.cal.set(5, (long)(Double.isNaN(value) ? 9.223372036854776E18 : value));
                    }
                    if (0 <= off + 1 && off + 1 < length) {
                        value = eval.getArg(off + 1).toNum();
                        this.cal.set(6, (long)(Double.isNaN(value) ? 9.223372036854776E18 : value));
                    }
                    if (0 <= off + 2 && off + 2 < length) {
                        value = eval.getArg(off + 2).toNum();
                        this.cal.set(7, (long)(Double.isNaN(value) ? 9.223372036854776E18 : value));
                    }
                    if (0 <= off + 3 && off + 3 < length) {
                        value = eval.getArg(off + 3).toNum();
                        this.cal.set(8, (long)(Double.isNaN(value) ? 9.223372036854776E18 : value));
                    }
                    return this.create(eval.getArg(-1), this.n);
                }
            }
            throw new ESException("Unknown object function");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ESBase construct(Call eval, int length) throws Throwable {
        if (this.cal == null) {
            this.cal = new QDate();
        }
        if (this.n != 2) {
            return super.construct(eval, length);
        }
        QDate qDate = this.cal;
        synchronized (qDate) {
            return ESDate.create(this.create(eval, length, 2));
        }
    }

    private long create(Call eval, int length, int code) throws Throwable {
        boolean isLocal = (code & 1) == 0;
        long value = 0L;
        if (length == 0) {
            value = System.currentTimeMillis();
        } else if (length == 1) {
            value = (long)eval.getArg(0).toNum();
        } else if (length >= 3) {
            long year = (long)eval.getArg(0).toNum();
            long month = (long)eval.getArg(1).toNum();
            long day = (long)eval.getArg(2).toNum() - 1L;
            long hour = 0L;
            if (length >= 4) {
                hour = (long)eval.getArg(3).toNum();
            }
            long minute = 0L;
            if (length >= 5) {
                minute = (long)eval.getArg(4).toNum();
            }
            long second = 0L;
            if (length >= 6) {
                second = (long)eval.getArg(5).toNum();
            }
            long ms = 0L;
            if (length >= 7) {
                ms = (long)eval.getArg(6).toNum();
            }
            this.cal.setDate(year, month, day);
            this.cal.setTime(hour, minute, second, ms);
            value = this.cal.get(9);
            if (isLocal) {
                value -= this.cal.getZoneOffset();
            }
        } else {
            value = Long.MIN_VALUE;
        }
        return value;
    }

    private double millisToDouble(long millis) {
        double dvalue = millis;
        if (dvalue > 8.64E15 || dvalue < -8.64E15 || Double.isNaN(dvalue)) {
            dvalue = Double.NaN;
        }
        return dvalue;
    }

    private ESBase create(ESBase obj, int code) throws ESException {
        double dvalue;
        boolean isLocal = (code & 1) == 0;
        long value = this.cal.get(9);
        if (isLocal) {
            value -= this.cal.getZoneOffset();
        }
        if ((dvalue = (double)value) > 8.64E15 || dvalue < -8.64E15 || Double.isNaN(dvalue)) {
            dvalue = Double.NaN;
        }
        if (!(obj instanceof ESDate)) {
            return ESNumber.create(dvalue);
        }
        ESNumber newValue = ESNumber.create(dvalue);
        ((ESDate)obj).time = (long)dvalue;
        return newValue;
    }

    private ESBase calculate(ESBase arg, int length, int code) throws Throwable {
        boolean isLocal = (code & 1) == 0;
        double value = arg.toNum();
        if (Double.isNaN(value) || value > 8.64E15 || value < -8.64E15 || length < 1) {
            return ESNumber.NaN;
        }
        long time = (long)value;
        this.cal.calculate(time, isLocal);
        return null;
    }
}

