/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es;

import com.caucho.es.Call;
import com.caucho.es.ESBase;
import com.caucho.es.ESBoolean;
import com.caucho.es.ESException;
import com.caucho.es.ESGlobal;
import com.caucho.es.ESId;
import com.caucho.es.ESNumber;
import com.caucho.es.ESString;
import com.caucho.es.ESWrapperException;
import com.caucho.es.Global;
import com.caucho.es.Native;
import com.caucho.es.Script;
import com.caucho.es.parser.Parser;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.Vfs;
import java.io.IOException;

class NativeGlobal
extends Native {
    static final int EVAL = 2;
    static final int PARSE_INT = 3;
    static final int PARSE_FLOAT = 4;
    static final int ESCAPE = 5;
    static final int UNESCAPE = 6;
    static final int IS_NAN = 7;
    static final int IS_FINITE = 8;
    static final int PRINT = 9;
    static final int SYSTEM = 10;

    NativeGlobal(String name, int n, int len) {
        super(name, len);
        this.n = n;
    }

    static void create(Global resin) {
        NativeGlobal.put(resin, "eval", 2, 1);
        NativeGlobal.put(resin, "parseInt", 3, 2);
        NativeGlobal.put(resin, "parseFloat", 4, 1);
        NativeGlobal.put(resin, "escape", 5, 1);
        NativeGlobal.put(resin, "unescape", 6, 1);
        NativeGlobal.put(resin, "isNaN", 7, 1);
        NativeGlobal.put(resin, "isFinite", 8, 1);
        NativeGlobal.put(resin, "print", 9, 1);
        NativeGlobal.put(resin, "system", 10, 1);
    }

    private static void put(Global resin, String name, int n, int len) {
        ESId id = ESId.intern(name);
        resin.addProperty(id, new NativeGlobal(name, n, len));
    }

    public ESBase call(Call eval, int length) throws Throwable {
        switch (this.n) {
            case 2: {
                return this.eval(eval, length);
            }
            case 3: {
                return this.parseInt(eval, length);
            }
            case 4: {
                if (length < 1) {
                    return ESNumber.NaN;
                }
                return ESNumber.create(ESString.parseFloat(eval.getArg(0).toStr()));
            }
            case 5: {
                return NativeGlobal.escape(eval, length);
            }
            case 6: {
                return NativeGlobal.unescape(eval, length);
            }
            case 7: {
                if (length < 1) {
                    return esUndefined;
                }
                return ESBoolean.create(Double.isNaN(eval.getArg(0).toNum()));
            }
            case 8: {
                if (length < 1) {
                    return esUndefined;
                }
                double value = eval.getArg(0).toNum();
                if (Double.isNaN(value)) {
                    return ESBoolean.create(false);
                }
                if (value == Double.POSITIVE_INFINITY) {
                    return ESBoolean.create(false);
                }
                if (value == Double.NEGATIVE_INFINITY) {
                    return ESBoolean.create(false);
                }
                return ESBoolean.create(true);
            }
            case 9: {
                System.out.print(eval.getArg(0).toStr().toString());
                return esNull;
            }
            case 10: {
                String arg = eval.getArg(0).toStr().toString();
                String[] args = new String[3];
                try {
                    args[0] = "sh";
                    args[1] = "-c";
                    args[2] = arg;
                    Process process = Runtime.getRuntime().exec(args);
                    return ESNumber.create(process.waitFor());
                }
                catch (Exception e) {
                    throw new ESWrapperException(e);
                }
            }
        }
        throw new ESException("Unknown object function");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ESBase eval(Call eval, int length) throws Throwable {
        if (length < 1) {
            return esUndefined;
        }
        ESBase arg = eval.getArg(0);
        if (!(arg instanceof ESString)) {
            return arg;
        }
        String string = arg.toString();
        Global resin = Global.getGlobalProto();
        ESBase context = eval.getFunctionContext();
        Script script = null;
        ReadStream is = null;
        try {
            Parser parser = new Parser();
            is = Vfs.openString(string);
            script = parser.parseEval(is, "eval", 1);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        ESGlobal jsClass = script.initClass(resin, eval.getGlobal());
        return jsClass.call(2, eval.caller, 0);
    }

    private ESBase parseInt(Call eval, int length) throws Throwable {
        int i;
        if (length < 1) {
            return ESNumber.NaN;
        }
        ESString string = eval.getArg(0).toStr();
        int len = string.length();
        for (i = 0; i < len && Character.isSpaceChar(string.charAt(i)); ++i) {
        }
        int sign = 1;
        if (i < len && string.charAt(i) == '+') {
            ++i;
        } else if (i < len && string.charAt(i) == '-') {
            sign = -1;
            ++i;
        }
        int radix = 0;
        if (length > 1 && (radix = eval.getArg(1).toInt32()) != 0) {
            if (radix < 2 || radix > 36) {
                return ESNumber.NaN;
            }
            if (radix == 16 && i + 1 < length && string.charAt(i) == '0' && (string.charAt(i + 1) == 'x' || string.charAt(i + 1) == 'X')) {
                i += 2;
            }
        }
        if (radix == 0) {
            if (i >= len) {
                radix = 10;
            } else if (string.charAt(i) != '0') {
                radix = 10;
            } else if (i + 1 < len && (string.charAt(i + 1) == 'x' || string.charAt(i + 1) == 'X')) {
                radix = 16;
                i += 2;
            } else {
                radix = 8;
            }
        }
        long value = 0L;
        boolean hasDigit = false;
        while (i < len) {
            char ch = string.charAt(i);
            if (radix <= 10 && '0' <= ch && ch <= 48 + radix - 1) {
                value = (long)radix * value + (long)string.charAt(i) - 48L;
                hasDigit = true;
            } else if (radix > 10 && '0' <= ch && ch <= '9') {
                value = (long)radix * value + (long)string.charAt(i) - 48L;
                hasDigit = true;
            } else if (radix > 10 && 'a' <= ch && ch <= 97 + radix - 11) {
                value = (long)radix * value + (long)string.charAt(i) - 97L + 10L;
                hasDigit = true;
            } else {
                if (radix <= 10 || 'A' > ch || ch > 65 + radix - 11) break;
                value = (long)radix * value + (long)string.charAt(i) - 65L + 10L;
                hasDigit = true;
            }
            ++i;
        }
        if (hasDigit) {
            return ESNumber.create((double)sign * (double)value);
        }
        return ESNumber.NaN;
    }

    static ESBase escape(Call eval, int length) throws Throwable {
        if (length < 1) {
            return esUndefined;
        }
        ESString string = eval.getArg(0).toStr();
        StringBuffer sbuf = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ch == '@' || ch == '*' || ch == '.' || ch == '_' || ch == '+' || ch == '-' || ch == '/') {
                sbuf.append(ch);
                continue;
            }
            if (ch < '\u0100') {
                sbuf.append('%');
                sbuf.append(Integer.toHexString(ch >> 4));
                sbuf.append(Integer.toHexString(ch & 0xF));
                continue;
            }
            sbuf.append("%u");
            sbuf.append(Integer.toHexString(ch >> 12));
            sbuf.append(Integer.toHexString(ch >> 8 & 0xF));
            sbuf.append(Integer.toHexString(ch >> 4 & 0xF));
            sbuf.append(Integer.toHexString(ch & 0xF));
        }
        return ESString.create(sbuf.toString());
    }

    static ESBase unescape(Call eval, int length) throws Throwable {
        if (length < 1) {
            return esUndefined;
        }
        ESString string = eval.getArg(0).toStr();
        StringBuffer sbuf = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            if (ch == '%' && i + 2 < string.length()) {
                int j;
                int limit = 2;
                int start = 1;
                if (string.charAt(i + 1) == 'u') {
                    limit = 4;
                    start = 2;
                }
                int newCh = 0;
                for (j = 0; j < limit && i + j + start < string.length(); ++j) {
                    ch = string.charAt(i + j + start);
                    if (ch >= '0' && ch <= '9') {
                        newCh = 16 * newCh + ch - 48;
                        continue;
                    }
                    if (ch >= 'a' && ch <= 'f') {
                        newCh = 16 * newCh + ch - 97 + 10;
                        continue;
                    }
                    if (ch < 'A' || ch > 'F') break;
                    newCh = 16 * newCh + ch - 65 + 10;
                }
                if (j != limit) {
                    sbuf.append('%');
                    continue;
                }
                sbuf.append((char)newCh);
                i += limit + start - 1;
                continue;
            }
            sbuf.append(ch);
        }
        return ESString.create(sbuf.toString());
    }
}

