/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.es.parser;

import com.caucho.es.ESBase;
import com.caucho.es.ESBoolean;
import com.caucho.es.ESNumber;
import com.caucho.es.ESString;
import com.caucho.es.parser.Block;
import com.caucho.es.parser.Expr;
import java.io.IOException;

class LiteralExpr
extends Expr {
    private ESBase value;

    LiteralExpr(Block block, ESBase value) {
        super(block);
        if (value == null) {
            value = ESBase.esNull;
        }
        this.value = value;
        if (value instanceof ESNumber) {
            double dv = 0.0;
            try {
                dv = value.toNum();
            }
            catch (Throwable e) {
                // empty catch block
            }
            this.type = (double)((int)dv) == dv ? 4 : ((double)((long)dv) == dv ? 3 : 3);
        } else {
            this.type = value instanceof ESBoolean ? 5 : (value instanceof ESString ? 2 : 1);
        }
        if (this.value == null) {
            throw new RuntimeException();
        }
    }

    ESBase getLiteral() {
        return this.value;
    }

    boolean isSimple() {
        return true;
    }

    void printInt32Impl() throws IOException {
        try {
            this.cl.print(this.value.toInt32());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void printNumImpl() throws IOException {
        try {
            double v = this.value.toNum();
            if (Double.isInfinite(v)) {
                this.cl.print("Double.POSITIVE_INFINITY");
            } else if (Double.isInfinite(-v)) {
                this.cl.print("Double.NEGATIVE_INFINITY");
            } else if (Double.isNaN(v)) {
                this.cl.print("Double.NaN");
            } else if ((double)((long)v) == v) {
                this.cl.print("(" + (long)v + "L)");
            } else {
                this.cl.print("(" + v + "D)");
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    void printBooleanImpl() throws IOException {
        this.cl.print(this.value.toBoolean());
    }

    void printStringImpl() throws IOException {
        try {
            this.cl.print("\"");
            String s = this.value.toStr().toString();
            block8: for (int i = 0; i < s.length(); ++i) {
                char ch = s.charAt(i);
                switch (ch) {
                    case '\"': {
                        this.cl.print("\\\"");
                        continue block8;
                    }
                    case '\\': {
                        this.cl.print("\\\\");
                        continue block8;
                    }
                    case '\n': {
                        this.cl.print("\\n");
                        continue block8;
                    }
                    case '\r': {
                        this.cl.print("\\r");
                        continue block8;
                    }
                    default: {
                        this.cl.print(ch);
                    }
                }
            }
            this.cl.print("\"");
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    void printStr() throws IOException {
        try {
            this.printLiteral(this.value.toStr());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    void print() throws IOException {
        this.printLiteral(this.value);
    }

    void printImpl() throws IOException {
        this.printLiteral(this.value);
    }

    public String toString() {
        return "[LiteralExpr " + this.value.toString() + "]";
    }
}

