/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.http.admin;

import com.caucho.http.admin.HostAdmin;
import com.caucho.http.admin.ServerAdmin;
import com.caucho.server.http.Application;
import com.caucho.vfs.Path;
import javax.management.MBeanServer;
import javax.naming.Context;

public class ApplicationAdmin {
    private ServerAdmin serverAdmin;
    private Application app;

    public ApplicationAdmin(Application app) {
        if (app == null) {
            throw new NullPointerException();
        }
        this.app = app;
    }

    public String getContextPath() {
        return this.app.getContextPath();
    }

    public Path getAppDir() {
        return this.app.getAppDir();
    }

    public long getStartTime() {
        return this.app.getStartTime();
    }

    public ServerAdmin getServerAdmin() {
        return this.serverAdmin;
    }

    public void setServerAdmin(ServerAdmin admin) {
        this.serverAdmin = admin;
    }

    public HostAdmin getHostAdmin() {
        return this.app.getVirtualHost().getAdmin();
    }

    public Context getJndiContext() {
        return this.app.getJndiContext();
    }

    public MBeanServer getMBeanServer() {
        return this.app.getJMXServer();
    }

    public ClassLoader getClassLoader() {
        return this.app.getClassLoader();
    }

    public void clearCache() {
        this.app.getServer().clearCache();
    }

    public void invalidateCache(String url) {
        url = this.app.getContextPath() + url;
        this.app.getServer().invalidateCache(url);
    }

    public int getActiveSessionCount() {
        if (this.app.getSessionManager() == null) {
            return 0;
        }
        return this.app.getSessionManager().getActiveSessionCount();
    }

    public Application getApplication() {
        return this.app;
    }

    public void restart() {
        this.app.restart();
    }
}

