/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.http.distribution;

import com.caucho.util.Alarm;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.ReadWritePair;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.IOException;

public class DistributionServer {
    protected static WriteStream dbg = LogStream.open("/caucho.com/distribution");
    private String id;
    private int index;
    private String groupId;
    private String host;
    private int port;
    private boolean isBackup;
    private Path path;
    private DistributionServer[] group;
    private int groupIndex;
    private long liveTime = 10000L;
    private long deadTime = 10000L;
    private int timeout = 10000;
    private int activeCount;
    private ReadWritePair free;
    private long lastFailTime;
    private long lastFreeTime;

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int i) {
        this.index = i;
        if (this.id == null) {
            this.id = String.valueOf(this.index);
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isBackup() {
        return this.isBackup;
    }

    public void setBackup(boolean isBackup) {
        this.isBackup = isBackup;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public DistributionServer[] getGroup() {
        return this.group;
    }

    public void setGroup(DistributionServer[] group) {
        this.group = group;
    }

    public int getGroupIndex() {
        return this.groupIndex;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public long getLiveTime() {
        return this.liveTime;
    }

    public void setLiveTime(long liveTimeout) {
        this.liveTime = liveTimeout;
    }

    public long getDeadTime() {
        return this.deadTime;
    }

    public void setDeadTime(long deadTimeout) {
        this.deadTime = deadTimeout;
    }

    public void setGroupIndex(int index) {
        this.groupIndex = index;
    }

    public int getActiveCount() {
        return this.activeCount;
    }

    public void init() throws Exception {
        if (this.id == null) {
            this.id = "";
        }
        this.path = Vfs.lookup("tcp://" + this.host + ":" + this.port);
    }

    public boolean isDead() {
        long now = Alarm.getCurrentTime();
        return now < this.lastFailTime + this.deadTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReadWritePair openRecycle() {
        long now = Alarm.getCurrentTime();
        ReadWritePair pair = null;
        DistributionServer distributionServer = this;
        synchronized (distributionServer) {
            pair = this.free;
            this.free = null;
        }
        if (pair == null) {
            return null;
        }
        if (now < this.lastFreeTime + this.liveTime) {
            ++this.activeCount;
            return pair;
        }
        try {
            pair.getReadStream().close();
            pair.getWriteStream().close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return null;
    }

    public ReadWritePair open() {
        long now = Alarm.getCurrentTime();
        if (now < this.lastFailTime + this.deadTime) {
            return null;
        }
        try {
            ReadWritePair pair = this.path.openReadWrite();
            ReadStream rs = pair.getReadStream();
            rs.setAttribute("timeout", new Integer(this.getTimeout()));
            ++this.activeCount;
            return pair;
        }
        catch (IOException e) {
            this.lastFailTime = now;
            return null;
        }
    }

    public void wake() {
        this.lastFailTime = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void free(ReadWritePair pair) {
        DistributionServer distributionServer = this;
        synchronized (distributionServer) {
            --this.activeCount;
            if (this.free == null) {
                this.free = pair;
                this.lastFreeTime = Alarm.getCurrentTime();
                return;
            }
        }
        try {
            WriteStream ws = pair.getWriteStream();
            ws.close();
            ReadStream rs = pair.getReadStream();
            rs.close();
        }
        catch (IOException e) {
            dbg.log(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ReadWritePair pair;
        DistributionServer distributionServer = this;
        synchronized (distributionServer) {
            pair = this.free;
            this.free = null;
        }
        if (pair != null) {
            try {
                WriteStream ws = pair.getWriteStream();
                ws.close();
                ReadStream rs = pair.getReadStream();
                rs.close();
            }
            catch (IOException e) {
                dbg.log(e);
            }
        }
    }

    public String toString() {
        return "[DistributedServer id=" + this.id + " index=" + this.index + " host=" + this.host + ":" + this.port + " group=" + this.groupId + "]";
    }
}

