/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.http.security;

import com.caucho.http.security.NullAuthenticator;
import com.caucho.http.security.ServletAuthenticator;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.security.Principal;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AbstractLogin {
    protected static WriteStream dbg = LogStream.open("/caucho.com/http/security");
    protected ServletAuthenticator auth;

    public void setAuthenticator(ServletAuthenticator auth) {
        this.auth = auth;
    }

    public ServletAuthenticator getAuthenticator() {
        return this.auth;
    }

    public void init() throws ServletException {
        if (this.auth == null) {
            this.auth = new NullAuthenticator();
        }
    }

    public String getAuthType() {
        return "none";
    }

    public Principal authenticate(HttpServletRequest request, HttpServletResponse response, ServletContext application) throws ServletException, IOException {
        return this.getUserPrincipal(request, response, application);
    }

    public Principal getUserPrincipal(HttpServletRequest request, HttpServletResponse response, ServletContext application) throws ServletException {
        return this.auth.getUserPrincipal(request, response, application);
    }

    public boolean isUserInRole(HttpServletRequest request, HttpServletResponse response, ServletContext application, Principal user, String role) throws ServletException {
        return this.auth.isUserInRole(request, response, application, user, role);
    }

    public void logout(HttpServletRequest request, HttpServletResponse response, ServletContext application) throws ServletException {
        Principal principal = this.getUserPrincipal(request, response, application);
        if (principal != null) {
            this.auth.logout(request, response, application, principal);
        }
    }
}

