/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.http.security;

import com.caucho.http.security.AbstractConstraint;
import com.caucho.util.InetNetwork;
import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class IPConstraint
extends AbstractConstraint {
    private ArrayList _networkList;

    public IPConstraint() {
    }

    public IPConstraint(String network) {
        if (network != null) {
            this.addIPNetwork(network);
        }
    }

    public void addIPNetwork(String network) {
        if (this._networkList == null) {
            this._networkList = new ArrayList();
        }
        this._networkList.add(InetNetwork.create(network));
    }

    public boolean isAuthorized(HttpServletRequest request, HttpServletResponse response, ServletContext application) throws ServletException, IOException {
        if (this._networkList == null) {
            return false;
        }
        String remoteAddr = request.getRemoteAddr();
        long addr = 0L;
        if (remoteAddr != null) {
            char ch;
            int len = remoteAddr.length();
            int i = 0;
            while (i < len && (ch = remoteAddr.charAt(i)) >= '0' && ch <= '9') {
                int digit = 0;
                while (i < len && (ch = remoteAddr.charAt(i)) >= '0' && ch <= '9') {
                    digit = 10 * digit + ch - 48;
                    ++i;
                }
                addr = 256L * addr + (long)digit;
                if (ch != '.') continue;
                ++i;
            }
        }
        for (int i = 0; i < this._networkList.size(); ++i) {
            InetNetwork net = (InetNetwork)this._networkList.get(i);
            if (!net.isMatch(addr)) continue;
            return true;
        }
        response.sendError(403, "Forbidden IP Address");
        return false;
    }
}

