/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.http.security;

import com.caucho.http.security.AbstractConstraint;
import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RoleConstraint
extends AbstractConstraint {
    private String[] roles;

    public void addRoleName(String role) {
        if (this.roles == null) {
            this.roles = new String[]{role};
        } else {
            String[] newRoles = new String[this.roles.length + 1];
            System.arraycopy(this.roles, 0, newRoles, 0, this.roles.length);
            newRoles[this.roles.length] = role;
            this.roles = newRoles;
        }
    }

    public boolean needsAuthentication() {
        return true;
    }

    public boolean isAuthorized(HttpServletRequest request, HttpServletResponse response, ServletContext application) throws ServletException, IOException {
        if (this.roles == null) {
            return true;
        }
        for (int i = 0; i < this.roles.length; ++i) {
            if (this.roles[i].equals("*")) {
                return true;
            }
            if (!request.isUserInRole(this.roles[i])) continue;
            return true;
        }
        response.sendError(403, null);
        return false;
    }
}

