/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.http.security;

import com.caucho.http.security.AbstractAuthenticator;
import com.caucho.server.http.BasicPrincipal;
import com.caucho.util.Alarm;
import com.caucho.util.Registry;
import com.caucho.util.RegistryNode;
import com.caucho.vfs.Path;
import java.security.Principal;
import java.util.Hashtable;
import java.util.Iterator;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class XmlAuthenticator
extends AbstractAuthenticator {
    private Path path;
    private Hashtable userMap = new Hashtable();
    private long lastModified;
    private long lastLength;
    private long lastCheck;

    public void setPath(Path path) {
        this.path = path;
    }

    public Path getPath() {
        return this.path;
    }

    public void addUser(String userParam) {
        String roles;
        String password;
        int p1 = userParam.indexOf(58);
        if (p1 < 0) {
            return;
        }
        String name = userParam.substring(0, p1);
        int p2 = userParam.indexOf(58, p1 + 1);
        if (p2 < 0) {
            password = userParam.substring(p1 + 1);
            roles = "user";
        } else {
            password = userParam.substring(p1 + 1, p2);
            roles = userParam.substring(p2 + 1);
        }
        User user = new User(name, password, new BasicPrincipal(name));
        user.addRoles(roles);
        this.userMap.put(name, user);
    }

    public synchronized void init() throws ServletException {
        super.init();
        if (this.path == null) {
            return;
        }
        try {
            Registry root = Registry.parse(this.path);
            RegistryNode registry = root.getTop();
            registry = registry.lookup("authenticator");
            if (registry == null) {
                throw new ServletException("missing auth");
            }
            Iterator iter = registry.select("user");
            while (iter.hasNext()) {
                RegistryNode node = (RegistryNode)iter.next();
                String name = node.getString("name", null);
                String password = node.getString("password", null);
                User user = new User(name, password, new BasicPrincipal(name));
                Iterator roleIter = node.select("role");
                while (roleIter.hasNext()) {
                    RegistryNode roleNode = (RegistryNode)roleIter.next();
                    String role = roleNode.getValue();
                    if (role == null || role.equals("")) continue;
                    user.addRoles(role);
                }
                this.userMap.put(name, user);
            }
            this.lastCheck = Alarm.getCurrentTime();
            this.lastModified = this.path.getLastModified();
            this.lastLength = this.path.getLength();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected Principal loginImpl(HttpServletRequest request, HttpServletResponse response, ServletContext application, String userName, String password) throws ServletException {
        if (this.isModified()) {
            this.init();
        }
        if (userName == null) {
            return null;
        }
        User user = (User)this.userMap.get(userName);
        if (user == null) {
            return null;
        }
        if (user.getPassword().equals(password)) {
            return user.getPrincipal();
        }
        return null;
    }

    protected String getDigestPassword(HttpServletRequest request, HttpServletResponse response, ServletContext application, String userName, String realm) throws ServletException {
        User user;
        if (this.isModified()) {
            this.init();
        }
        if ((user = (User)this.userMap.get(userName)) == null) {
            return null;
        }
        return user.getPassword();
    }

    public boolean isUserInRole(HttpServletRequest request, HttpServletResponse response, ServletContext application, Principal principal, String role) throws ServletException {
        if (principal == null) {
            return false;
        }
        String name = principal.getName();
        User user = (User)this.userMap.get(name);
        if (user == null) {
            return false;
        }
        String[] roles = user.getRoles();
        for (int i = roles.length - 1; i >= 0; --i) {
            if (!roles[i].equals(role)) continue;
            return true;
        }
        return false;
    }

    private boolean isModified() {
        if (this.path == null) {
            return false;
        }
        if (Alarm.getCurrentTime() < this.lastCheck + 5000L) {
            return false;
        }
        if (this.lastModified != this.path.getLastModified()) {
            return true;
        }
        if (this.lastLength != this.path.getLength()) {
            return true;
        }
        this.lastCheck = Alarm.getCurrentTime();
        return false;
    }

    static class User {
        private String name;
        private String password;
        private Principal principal;
        private String[] roles = new String[0];

        User(String name, String password, Principal principal) {
            this.name = name;
            this.password = password;
            this.principal = principal;
        }

        String getName() {
            return this.name;
        }

        String getPassword() {
            return this.password;
        }

        Principal getPrincipal() {
            return this.principal;
        }

        void addRoles(String roles) {
            int head = 0;
            int length = roles.length();
            while (head < length) {
                int tail;
                char ch;
                while (head < length && ((ch = roles.charAt(head)) == ' ' || ch == ',')) {
                    ++head;
                }
                if (head >= length) {
                    return;
                }
                for (tail = head; tail < length && (ch = roles.charAt(tail)) != ' ' && ch != ','; ++tail) {
                }
                String role = roles.substring(head, tail);
                this.addRole(role);
                head = tail;
            }
        }

        void addRole(String role) {
            String[] newRoles = new String[this.roles.length + 1];
            System.arraycopy(this.roles, 0, newRoles, 0, this.roles.length);
            newRoles[this.roles.length] = role;
            this.roles = newRoles;
        }

        String[] getRoles() {
            return this.roles;
        }
    }
}

