/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.http.server;

import com.caucho.hessian.mux.MuxInputStream;
import com.caucho.hessian.mux.MuxOutputStream;
import com.caucho.hessian.mux.MuxServer;
import com.caucho.http.server.MuxResponse;
import com.caucho.http.server.MuxStreamImpl;
import com.caucho.server.Connection;
import com.caucho.server.http.InvocationKey;
import com.caucho.server.http.Request;
import com.caucho.server.http.ServletServer;
import com.caucho.util.ByteBuffer;
import com.caucho.util.CharBuffer;
import com.caucho.util.CharSegment;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.servlet.ServletInputStream;

public class MuxRequest
extends Request {
    private static WriteStream dbg = LogStream.open("/caucho.com/http/mux");
    private MuxServer muxServer;
    private MuxInputStream in;
    private MuxOutputStream out;
    private MuxStreamImpl muxStreamImpl;
    private ReadStream readStream;
    private WriteStream writeStream;
    private InvocationKey invocationKey = new InvocationKey();
    private ByteBuffer uriBuffer = new ByteBuffer();
    private CharBuffer methodBuffer = new CharBuffer();
    private String uri;
    private String method;

    MuxRequest(ServletServer server) {
        super(server);
        this.response = new MuxResponse(this);
        this.readStream = new ReadStream();
        this.readStream.setReuseBuffer(true);
        this.writeStream = new WriteStream();
        this.writeStream.setReuseBuffer(true);
        ((MuxResponse)this.response).init(this, this.writeStream);
        this.muxStreamImpl = new MuxStreamImpl();
        this.in = new MuxInputStream();
        this.out = new MuxOutputStream();
    }

    public void handleConnection(Connection conn) throws IOException {
        this.setConnection(conn);
        ReadStream rawRead = conn.getReadStream();
        WriteStream rawWrite = conn.getWriteStream();
        if (dbg.canWrite()) {
            dbg.println("[" + conn.getId() + "] start connection");
        }
        this.muxServer = new MuxServer(rawRead, rawWrite, false);
        while (this.muxServer.readRequest(this.in, this.out)) {
            this.handleRequest(this.in, this.out);
        }
        if (dbg.canWrite()) {
            dbg.println("[" + conn.getId() + "] close connection");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRequest(MuxInputStream in, MuxOutputStream out) throws IOException {
        char ch;
        int i;
        this.muxStreamImpl.init(in, out);
        this.readStream.init(this.muxStreamImpl, null);
        this.writeStream.init(this.muxStreamImpl);
        String url = in.getURL();
        String method = "GET";
        this.methodBuffer.clear();
        if (method == null) {
            this.methodBuffer.append("POST");
        } else {
            this.methodBuffer.append(method);
        }
        this.uriBuffer.clear();
        int length = url.length();
        for (i = 0; i < length && url.charAt(i) != ':'; ++i) {
        }
        i += 3;
        while (i < length && url.charAt(i) != '/') {
            ++i;
        }
        while (i < length && (ch = url.charAt(i)) != '?') {
            this.uriBuffer.append(ch);
            ++i;
        }
        try {
            this.start(this.readStream);
            this.setAttribute("caucho.hmux", this.muxServer);
            this.invocationKey.init(this.getHost(), this.getServerPort(), this.uriBuffer.getBuffer(), this.uriBuffer.getLength(), false);
            this.server.serviceTop(this.invocationKey, this, this.response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.response.finish(false);
            this.writeStream.close();
        }
    }

    protected boolean isTop() {
        return true;
    }

    protected boolean checkLogin() {
        return true;
    }

    public String getScheme() {
        return "hmux";
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.hasInputStream) {
            return this.is;
        }
        this.hasInputStream = true;
        this.is.init(this.readStream);
        return this.is;
    }

    public CharSegment getMethodBuffer() {
        return this.methodBuffer;
    }

    CharBuffer getHost() {
        return null;
    }

    public byte[] getUriBuffer() {
        return this.uriBuffer.getBuffer();
    }

    public int getUriLength() {
        return this.uriBuffer.getLength();
    }

    public CharSegment getProtocolBuffer() {
        return null;
    }

    public Enumeration getHeaderNames() {
        return null;
    }

    public CharSegment getHeaderBuffer(String key) {
        return null;
    }

    public CharSegment getHeaderBuffer(char[] buf, int length) {
        return null;
    }

    public void getHeaderBuffers(ArrayList values, String key) {
    }

    public void setHeader(String key, String value) {
    }

    public String getServerName() {
        return null;
    }

    public int getServerPort() {
        return 0;
    }

    public String getRemoteAddr() {
        return null;
    }

    public void getRemoteAddr(CharBuffer cb) {
    }

    public String getRemoteHost() {
        return null;
    }
}

