/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.http.session;

import com.caucho.http.distribution.BackingContext;
import com.caucho.http.distribution.DistributionServer;
import com.caucho.http.distribution.FileStore;
import com.caucho.http.distribution.JdbcStore;
import com.caucho.http.distribution.ObjectBacking;
import com.caucho.http.distribution.RingStore;
import com.caucho.http.distribution.Store;
import com.caucho.http.session.SessionFactory;
import com.caucho.http.session.SessionImpl;
import com.caucho.server.http.Application;
import com.caucho.server.http.ServletServer;
import com.caucho.server.http.VirtualHost;
import com.caucho.sql.DBPool;
import com.caucho.util.Alarm;
import com.caucho.util.BeanUtil;
import com.caucho.util.CharBuffer;
import com.caucho.util.LruCache;
import com.caucho.util.RegistryNode;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadWritePair;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

public class SessionManager
implements BackingContext {
    protected static WriteStream dbg = LogStream.open("/caucho.com/http/session");
    static HashMap sessionConfigElements = new HashMap();
    static int[] decode;
    private Application app;
    private ServletServer server;
    private SessionFactory sessionFactory;
    private LruCache sessions;
    private int totalSessions;
    private Iterator sessionIter;
    private ArrayList sessionList = new ArrayList();
    private int sessionCount;
    private boolean enableSessionCookies;
    private boolean enableSessionUrls;
    private boolean _isInvalidateAfterListener;
    private long sessionTimeout;
    private int cookieVersion;
    private String cookieName;
    private String cookieDomain;
    private long cookieMaxAge;
    private boolean reuseSessionId;
    private int cookieLength = Integer.MAX_VALUE;
    private int distributedPort;
    private Store sessionStore;
    private boolean alwaysLoadSession;
    private boolean alwaysSaveSession;
    private boolean saveOnShutdown;
    private boolean distributedRing;
    private Path persistentPath;
    private long lastDistributedFail;
    private ReadWritePair distributedPair;
    private ArrayList listeners;
    private ArrayList activationListeners;
    private ArrayList attributeListeners;
    private boolean ignoreSerializationErrors = false;
    private int srunIndex;
    private boolean isClosed;
    private String distributionId;
    private DistributionServer[] _srunGroup;

    public SessionManager(Application app, RegistryNode registry) throws Exception {
        RegistryNode factory;
        this.app = app;
        this.server = app.getVirtualHost().getServer();
        this.srunIndex = this.server.getSrunIndex();
        VirtualHost host = app.getVirtualHost();
        String name = host.getServerName();
        if (name == null || name.equals("")) {
            name = host.getName();
        }
        if (name == null || name.equals("")) {
            name = "default";
        }
        this.distributionId = name + app.getContextPath();
        int sessionMax = registry.getInt("session-config/session-max", 4096);
        this.sessions = new LruCache(sessionMax);
        this.sessionIter = this.sessions.values();
        this.sessionTimeout = 60000L * (long)registry.getInt("session-config/session-timeout", 30);
        if (this.sessionTimeout <= 0L) {
            this.sessionTimeout = 0x3FFFFFFFFFFFFFFFL;
        }
        if (this.sessionTimeout < 5000L) {
            this.sessionTimeout = 5000L;
        }
        this.cookieName = this.server.getSessionCookie();
        this.enableSessionCookies = registry.getBoolean("session-config/enable-cookies", true);
        this.enableSessionUrls = registry.getBoolean("session-config/enable-url-rewriting", true);
        this.cookieVersion = registry.getInt("session-config/cookie-version", 0);
        this.cookieDomain = registry.getString("session-config/cookie-domain", null);
        this.cookieMaxAge = registry.getPeriod("session-config/cookie-max-age", -1L);
        this.cookieLength = registry.getInt("session-config/cookie-length", Integer.MAX_VALUE);
        this._isInvalidateAfterListener = registry.getBoolean("session-config/invalidate-after-listener", false);
        if (this.cookieLength < 7) {
            this.cookieLength = 7;
        } else if (this.cookieLength > 12) {
            this.cookieLength = 12;
        }
        this.reuseSessionId = registry.getBoolean("session-config/reuse-session-id", true);
        if (this.cookieMaxAge < this.sessionTimeout) {
            this.cookieMaxAge = -1L;
        }
        if ((factory = registry.lookup("session-config/session-factory")) != null) {
            HashMap variableMap = app.getPathVariableMap();
            Path appDir = app.getAppDir();
            Object obj = BeanUtil.createBean(factory, variableMap, appDir);
            this.sessionFactory = (SessionFactory)obj;
        } else {
            this.sessionFactory = new SessionFactory();
        }
        this.sessionFactory.setSessionManager(this);
        this.sessionFactory.init();
        String backingPath = registry.getString("session-config/backing-path", "WEB-INF/sessions");
        String path = null;
        RegistryNode store = registry.lookup("session-config/file-store");
        if (store != null) {
            path = store.getValue();
            if ((path = store.getString("directory", path)) == null) {
                throw Application.error(store, "file-store expects directory");
            }
            backingPath = path = path.trim();
        }
        if ((store = registry.lookup("session-config/jdbc-store")) != null) {
            name = store.getValue();
            if ((name = store.getString("data-source", name)) == null || name.equals("")) {
                name = "jdbc/db-pool";
            }
            DBPool source = DBPool.getPool(name);
            JdbcStore jdbcStore = new JdbcStore();
            jdbcStore.setDataSource(source);
            this.sessionStore = jdbcStore;
            jdbcStore.setTableName(store.getString("table-name", null));
            jdbcStore.setBlobType(store.getString("blob-type", null));
        }
        this.distributedRing = registry.getBoolean("session-config/tcp-store", false);
        this.alwaysLoadSession = registry.getBoolean("session-config/always-load-session", false);
        this.alwaysSaveSession = registry.getBoolean("session-config/always-save-session", false);
        this.saveOnShutdown = registry.getBoolean("session-config/save-on-shutdown", false);
        this.ignoreSerializationErrors = registry.getBoolean("session-config/ignore-serialization-errors", false);
        if (this.saveOnShutdown && this.alwaysSaveSession) {
            throw Application.error(registry, "always-save-session and save-on-shutdown not allowed together.");
        }
        this.persistentPath = app.lookupPath(backingPath);
        if (this.distributedRing) {
            DistributionServer distServer = this.server.getDistributionServer();
            if (distServer != null) {
                this.sessionStore = new RingStore(this.distributionId, distServer);
            }
            this.alwaysLoadSession = false;
        }
        if (path != null) {
            FileStore fileStore = new FileStore();
            fileStore.setPath(this.persistentPath);
            this.sessionStore = fileStore;
        }
        if (this.sessionStore != null) {
            this.sessionStore.setBackingManager(this);
            this.sessionStore.setPrefix(this.distributionId);
        }
        Iterator iter = registry.select("session-config");
        while (iter.hasNext()) {
            RegistryNode node = (RegistryNode)iter.next();
            Iterator iter2 = node.iterator();
            while (iter2.hasNext()) {
                RegistryNode subnode = (RegistryNode)iter2.next();
                if (sessionConfigElements.get(subnode.getName()) != null) continue;
                throw Application.error(subnode, "unexpected element at `" + subnode.getName() + "'");
            }
        }
        DistributionServer srun = app.getServer().getDistributionServer();
        this._srunGroup = srun != null ? srun.getGroup() : new DistributionServer[0];
        app.getServer().setDistributedObjectContext(this.distributionId, this);
    }

    public void init() throws Exception {
        if (this.sessionStore != null) {
            this.cleanBacking();
            this.sessionStore.init();
        }
    }

    public WriteStream getDebug() {
        return dbg;
    }

    Application getApplication() {
        return this.app;
    }

    ServletServer getServer() {
        return this.server;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory factory) {
        this.sessionFactory = factory;
    }

    Store getSessionStore() {
        return this.sessionStore;
    }

    boolean getAlwaysSaveSession() {
        return this.alwaysSaveSession;
    }

    public int getActiveSessionCount() {
        if (this.sessions == null) {
            return -1;
        }
        return this.sessions.size();
    }

    public void addListener(HttpSessionListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(listener);
    }

    ArrayList getListeners() {
        return this.listeners;
    }

    public void addActivationListener(HttpSessionActivationListener listener) {
        if (this.activationListeners == null) {
            this.activationListeners = new ArrayList();
        }
        this.activationListeners.add(listener);
    }

    ArrayList getActivationListeners() {
        return this.activationListeners;
    }

    public void addAttributeListener(HttpSessionAttributeListener listener) {
        if (this.attributeListeners == null) {
            this.attributeListeners = new ArrayList();
        }
        this.attributeListeners.add(listener);
    }

    ArrayList getAttributeListeners() {
        return this.attributeListeners;
    }

    boolean getSaveOnShutdown() {
        return this.saveOnShutdown;
    }

    boolean getIgnoreSerializationErrors() {
        return this.ignoreSerializationErrors;
    }

    public boolean reuseSessionId() {
        return this.reuseSessionId;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public String getDistributionId() {
        return this.distributionId;
    }

    public boolean isInvalidateAfterListener() {
        return this._isInvalidateAfterListener;
    }

    public void setInvalidateAfterListener(boolean value) {
        this._isInvalidateAfterListener = value;
    }

    private void cleanDistSession() {
        long maxAge = 172800000L;
        long now = Alarm.getCurrentTime();
        if (this.persistentPath == null) {
            return;
        }
        try {
            char prefix = (char)(97 + this.srunIndex);
            Iterator iter = this.persistentPath.iterator();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                if (name.charAt(0) != prefix) continue;
                try {
                    Path subdir = this.persistentPath.lookup(name);
                    Iterator subiter = subdir.iterator();
                    while (subiter.hasNext()) {
                        try {
                            Path path = subdir.lookup(name);
                            long lastModified = path.getLastModified();
                            if (maxAge + lastModified < now) {
                                path.remove();
                                continue;
                            }
                            ++this.totalSessions;
                        }
                        catch (IOException e) {}
                    }
                }
                catch (IOException e) {
                }
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public ObjectBacking getBacking(String id) {
        Path path = this.getSessionPath(id);
        ObjectBacking backing = new ObjectBacking(id, path, this.sessionStore);
        SessionImpl session = (SessionImpl)this.sessions.get(id);
        backing.setObject(session);
        return backing;
    }

    public ObjectBacking createBacking(String id) {
        return this.app.getServer().getDistributedObjectBacking(this.distributionId, id);
    }

    void cleanBacking() {
        if (this.persistentPath == null) {
            return;
        }
        long sessionTimeout = this.getSessionTimeout();
        try {
            long now = Alarm.getCurrentTime();
            for (int hash = 0; hash < 32; ++hash) {
                CharBuffer cb = CharBuffer.allocate();
                if (this.srunIndex >= 0) {
                    cb.append((char)(97 + this.srunIndex));
                }
                cb.append(hash & 0x1F);
                Path path = this.persistentPath.lookup(cb.close());
                if (!path.isDirectory()) continue;
                String[] list = path.list();
                for (int i = 0; list != null && i < list.length; ++i) {
                    long lastModified;
                    Path sessionPath = path.lookup(list[i]);
                    if (!sessionPath.isFile() || !sessionPath.canRead() || (lastModified = sessionPath.getLastModified()) + sessionTimeout >= now) continue;
                    if (dbg.canWrite()) {
                        dbg.log("timeout file session: " + sessionPath);
                    }
                    sessionPath.remove();
                }
            }
        }
        catch (IOException e) {
            dbg.log(e);
        }
    }

    private Path getSessionPath(String id) {
        int hashCode = id.hashCode();
        CharBuffer cb = CharBuffer.allocate();
        if (this.srunIndex >= 0) {
            cb.append((char)(97 + this.srunIndex));
        }
        cb.append(hashCode & 0x1F);
        String dir = cb.close();
        Path subpath = this.persistentPath.lookup(dir);
        try {
            subpath.mkdirs();
        }
        catch (IOException e) {
            // empty catch block
        }
        return subpath.lookup(id);
    }

    public Iterator getSessionPaths(int index) {
        DistributionServer srun = this.server.getDistributionServer(index);
        return new SessionIterator(this.srunIndex, srun);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionImpl createSession(String oldId, long now, int sessionGroup, HttpServletRequest request) {
        SessionImpl session;
        String id = oldId;
        if (id == null || id.length() < 4 || !this.isInSessionGroup(id) || !this.reuseSessionId()) {
            id = this.createSessionId(sessionGroup, request, true);
        }
        if ((session = this.create(id, now)) == null) {
            return null;
        }
        this.handleCreateListeners(session);
        SessionImpl sessionImpl = session;
        synchronized (sessionImpl) {
            if (this.sessionStore != null && id.equals(oldId)) {
                this.load(session, now);
            }
        }
        return session;
    }

    public String createSessionId(int sessionGroup, HttpServletRequest request) {
        return this.createSessionId(sessionGroup, request, false);
    }

    public String createSessionId(int sessionGroup, HttpServletRequest request, boolean create) {
        String id;
        do {
            CharBuffer cb = CharBuffer.allocate();
            int index = this.srunIndex;
            if (sessionGroup >= 0) {
                index = sessionGroup;
            }
            if (index < 0) {
                index = 0;
            }
            cb.append(SessionManager.convert(index));
            long random = this.server.getRandomLong();
            for (int length = this.cookieLength - 1; length > 0; --length) {
                cb.append(SessionManager.convert(random));
                random >>= 6;
            }
            id = cb.close();
        } while (create && this.getSession(id, 0L, create) != null);
        if (id == null || id.equals("")) {
            throw new RuntimeException();
        }
        return id;
    }

    private static char convert(long code) {
        if ((code &= 0x3FL) < 26L) {
            return (char)(97L + code);
        }
        if (code < 52L) {
            return (char)(65L + code - 26L);
        }
        if (code < 62L) {
            return (char)(48L + code - 52L);
        }
        if (code == 62L) {
            return '_';
        }
        return '-';
    }

    static int decode(int code) {
        return decode[code & 0x7F];
    }

    long getSessionTimeout() {
        return this.sessionTimeout;
    }

    public boolean enableSessionCookies() {
        return this.enableSessionCookies;
    }

    public boolean enableSessionUrls() {
        return this.enableSessionUrls;
    }

    public String getCookieName() {
        return this.cookieName;
    }

    public int getCookieVersion() {
        return this.cookieVersion;
    }

    public String getCookieDomain() {
        return this.cookieDomain;
    }

    public long getCookieMaxAge() {
        return this.cookieMaxAge;
    }

    public SessionImpl getSession(String key, long now, boolean create) {
        boolean isNew = false;
        boolean killSession = false;
        SessionImpl session = (SessionImpl)this.sessions.get(key);
        if (session != null && !session.getId().equals(key)) {
            session = null;
        }
        if (session == null && now > 0L && this.sessionStore != null) {
            if (!this.isInSessionGroup(key)) {
                return null;
            }
            session = this.create(key, now);
            isNew = true;
        }
        if (session == null) {
            return null;
        }
        if (isNew) {
            killSession = !this.load(session, now);
        } else if (this.sessionStore != null && now > 0L && (this.alwaysLoadSession || session.needsLoad())) {
            this.load(session, now);
        } else if (now > 0L) {
            session.setAccess(now);
        }
        if (!(!killSession || create && this.reuseSessionId)) {
            session.setClosed();
            this.sessions.remove(key);
            return null;
        }
        if (isNew) {
            this.handleCreateListeners(session);
        }
        return session;
    }

    private boolean isInSessionGroup(String id) {
        int group = id.charAt(0) - 97;
        if (this._srunGroup.length == 0) {
            return true;
        }
        for (int i = this._srunGroup.length - 1; i >= 0; --i) {
            if (group != this._srunGroup[i].getIndex()) continue;
            return true;
        }
        return false;
    }

    private SessionImpl create(String key, long now) {
        SessionImpl session = null;
        try {
            session = (SessionImpl)this.sessions.get(key);
            if (session == null) {
                session = this.sessionFactory.create(key, now);
                session = (SessionImpl)this.sessions.putIfNew(key, session);
            }
        }
        catch (ServletException e) {
            dbg.log(e);
            return null;
        }
        return session;
    }

    private void handleCreateListeners(SessionImpl session) {
        if (this.listeners != null) {
            HttpSessionEvent event = new HttpSessionEvent((HttpSession)session);
            for (int i = 0; i < this.listeners.size(); ++i) {
                HttpSessionListener listener = (HttpSessionListener)this.listeners.get(i);
                listener.sessionCreated(event);
            }
        }
    }

    private boolean load(SessionImpl session, long now) {
        try {
            session.setNeedsLoad(false);
            if (now <= 0L) {
                return false;
            }
            if (this.sessionStore.load(session)) {
                ArrayList listeners = this.getActivationListeners();
                for (int i = 0; listeners != null && i < listeners.size(); ++i) {
                    HttpSessionEvent event = new HttpSessionEvent((HttpSession)session);
                    HttpSessionActivationListener listener = (HttpSessionActivationListener)listeners.get(i);
                    listener.sessionDidActivate(event);
                }
                session.setAccess(now);
                return true;
            }
            session.create(now);
        }
        catch (Exception e) {
            dbg.log(e);
            session.reset(now);
        }
        return false;
    }

    void addSession(SessionImpl session) {
        this.sessions.put(session.getId(), session);
    }

    public void removeSession(SessionImpl session) {
        this.sessions.remove(session.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrementSessionCount() {
        LruCache lruCache = this.sessions;
        synchronized (lruCache) {
            --this.sessionCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int timeout(long now) {
        SessionImpl session;
        this.sessionList.clear();
        int liveSessions = 0;
        LruCache lruCache = this.sessions;
        synchronized (lruCache) {
            this.sessionIter = this.sessions.values(this.sessionIter);
            while (this.sessionIter.hasNext()) {
                session = (SessionImpl)this.sessionIter.next();
                if (session.accessTime + session.maxInactiveInterval < now) {
                    this.sessionList.add(session);
                    continue;
                }
                ++liveSessions;
            }
        }
        for (int i = 0; i < this.sessionList.size(); ++i) {
            session = (SessionImpl)this.sessionList.get(i);
            if (session.getSrunIndex() == this.srunIndex || this.srunIndex < 0) {
                session.invalidate();
                continue;
            }
            this.sessions.remove(session.getId());
        }
        return liveSessions;
    }

    public void cron(long now) {
        this.timeout(now);
        this.cleanBacking();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        SessionImpl session;
        this.isClosed = true;
        this.sessionList.clear();
        ArrayList<SessionImpl> list = new ArrayList<SessionImpl>();
        LruCache sessions = this.sessions;
        boolean isError = false;
        LruCache lruCache = sessions;
        synchronized (lruCache) {
            this.sessionIter = sessions.values(this.sessionIter);
            while (this.sessionIter.hasNext()) {
                session = (SessionImpl)this.sessionIter.next();
                if (!session.isValid()) continue;
                list.add(session);
            }
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            session = (SessionImpl)list.get(i);
            if (dbg.canWrite()) {
                dbg.log("close session " + session.getId());
            }
            try {
                if (session.isValid && session.store != null) {
                    SessionImpl sessionImpl = session;
                    synchronized (sessionImpl) {
                        session.store.storeOnShutdown(session);
                    }
                }
                sessions.remove(session.getId());
                continue;
            }
            catch (Throwable e) {
                if (!isError) {
                    this.app.log("Can't store session.", e);
                }
                isError = true;
            }
        }
        this.sessions = null;
        Store store = this.sessionStore;
        this.sessionStore = null;
        if (store != null) {
            store.destroy();
        }
        this.app.getServer().removeDistributedObjectContext(this.distributionId);
    }

    int getSrunIndex() {
        return this.srunIndex;
    }

    static {
        sessionConfigElements.put("session-max", "session-max");
        sessionConfigElements.put("session-timeout", "session-timeout");
        sessionConfigElements.put("enable-cookies", "enable-cookies");
        sessionConfigElements.put("enable-url-rewriting", "enable-url-rewriting");
        sessionConfigElements.put("cookie-version", "cookie-version");
        sessionConfigElements.put("cookie-domain", "cookie-domain");
        sessionConfigElements.put("cookie-max-age", "cookie-max-age");
        sessionConfigElements.put("cookie-length", "cookie-length");
        sessionConfigElements.put("file-store", "file-store");
        sessionConfigElements.put("jdbc-store", "jdbc-store");
        sessionConfigElements.put("tcp-store", "tcp-store");
        sessionConfigElements.put("always-load-session", "always-load-session");
        sessionConfigElements.put("always-save-session", "always-save-session");
        sessionConfigElements.put("save-on-shutdown", "save-on-shutdown");
        sessionConfigElements.put("ignore-serialization-errors", "ignore-serialization-errors");
        sessionConfigElements.put("reuse-session-id", "reuse-session-id");
        sessionConfigElements.put("backing-path", "backing-path");
        sessionConfigElements.put("invalidate-after-listener", "invalidate-after-listener");
        decode = new int[128];
        for (int i = 0; i < 64; ++i) {
            SessionManager.decode[SessionManager.convert((long)((long)i))] = i;
        }
    }

    class SessionIterator
    implements Iterator {
        Path root;
        Path dir;
        String[] dirs;
        int dirIndex;
        int selfIndex;
        char selfCode;
        int srunIndex;
        DistributionServer srun;
        DistributionServer[] srunList;
        DistributionServer[] group;
        int srunLength;
        String[] files;
        int fileIndex;
        String prefix;

        SessionIterator(int selfIndex, DistributionServer srun) {
            this.root = SessionManager.this.persistentPath;
            try {
                this.dirs = this.root.list();
            }
            catch (IOException e) {
                e.printStackTrace();
                this.dirs = new String[0];
            }
            this.selfIndex = selfIndex;
            this.selfCode = SessionManager.convert(selfIndex);
            this.srun = srun;
            this.srunList = SessionManager.this.server.getDistributionServerList();
            this.group = srun.getGroup();
            this.srunIndex = srun.getIndex();
            this.srunLength = this.group.length;
            this.dirIndex = 0;
            Object obj = this.next();
            if (obj != null) {
                --this.fileIndex;
            }
        }

        public boolean hasNext() {
            Object obj = this.next();
            if (obj != null) {
                --this.fileIndex;
            }
            return obj != null;
        }

        public Object next() {
            while (this.files != null && this.fileIndex < this.files.length) {
                String fileName;
                if (!this.fileNameMatches(fileName = this.files[this.fileIndex++])) continue;
                return this.dir.lookup(fileName);
            }
            while (this.dirIndex < this.dirs.length) {
                block7: {
                    String name = this.dirs[this.dirIndex];
                    if (name != null && name.length() >= 1 && name.charAt(0) == this.selfCode) {
                        this.dir = this.root.lookup(name);
                        if (this.dir.isDirectory()) {
                            try {
                                this.files = this.dir.list();
                                this.fileIndex = 0;
                            }
                            catch (IOException e) {
                                break block7;
                            }
                            while (this.files != null && this.fileIndex < this.files.length) {
                                String fileName;
                                if (!this.fileNameMatches(fileName = this.files[this.fileIndex++])) continue;
                                ++this.dirIndex;
                                return this.dir.lookup(fileName);
                            }
                        }
                    }
                }
                ++this.dirIndex;
            }
            return null;
        }

        private boolean fileNameMatches(String fileName) {
            if (fileName.length() < 2) {
                return false;
            }
            int ownerSrun = SessionManager.decode(fileName.charAt(0));
            if (ownerSrun == this.srunIndex) {
                return true;
            }
            if (this.srunList.length <= ownerSrun) {
                return false;
            }
            DistributionServer[] group = this.srunList[ownerSrun].getGroup();
            int groupIndex = this.srunList[ownerSrun].getGroupIndex();
            int groupLength = group.length;
            if (groupLength < 2) {
                return false;
            }
            int delta = SessionManager.decode(fileName.charAt(1)) % (groupLength - 1);
            DistributionServer backup = group[(groupIndex + delta + 1) % groupLength];
            return backup == this.srun;
        }

        public void remove() {
        }
    }
}

