/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.java;

import com.caucho.java.JavaCompiler;
import com.caucho.util.CauchoSystem;
import com.caucho.util.SimpleClassLoader;
import com.caucho.vfs.IOExceptionWrapper;
import com.caucho.vfs.Path;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;

public abstract class AbstractGenerator {
    private String fullClassName;
    private String packageName;
    private String className;
    private ClassLoader parentLoader;
    private ClassLoader loader;
    private WriteStream os;
    private int indentDepth;
    private boolean startLine = true;
    private Path searchPath;
    private Path workPath;
    private String initMethod = "_caucho_init";
    private String isModifiedMethod = "_caucho_is_modified";
    static /* synthetic */ Class class$com$caucho$vfs$Path;

    public void setSearchPath(Path path) {
        this.searchPath = path;
    }

    public Path getSearchPath() {
        return this.searchPath;
    }

    public void setFullClassName(String fullClassName) {
        this.fullClassName = fullClassName;
        int p = fullClassName.lastIndexOf(46);
        if (p > 0) {
            this.packageName = fullClassName.substring(0, p);
            this.className = fullClassName.substring(p + 1);
        } else {
            this.packageName = "";
            this.className = fullClassName;
        }
    }

    public String getFullClassName() {
        return this.fullClassName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getClassName() {
        return this.className;
    }

    public void setParentLoader(ClassLoader loader) {
        this.parentLoader = loader;
    }

    public void setLoader(ClassLoader loader) {
        this.loader = loader;
    }

    public ClassLoader getParentLoader() {
        if (this.parentLoader == null) {
            this.parentLoader = CauchoSystem.getContextClassLoader();
        }
        return this.parentLoader;
    }

    public void setClassDir(Path workPath) {
        this.workPath = workPath;
    }

    public Path getClassDir() {
        if (this.workPath == null) {
            return CauchoSystem.getWorkPath();
        }
        return this.workPath;
    }

    public Class preload() throws IOException {
        return this.loadClass(true);
    }

    public void generate() throws Exception {
        String className = this.getFullClassName();
        String javaPathName = className.replace('.', '/') + ".java";
        String classPathName = className.replace('.', '/') + ".class";
        Path javaPath = this.getClassDir().lookup(javaPathName);
        Path classPath = this.getClassDir().lookup(classPathName);
        try {
            classPath.remove();
        }
        catch (IOException e) {
            // empty catch block
        }
        javaPath.getParent().mkdirs();
        this.os = javaPath.openWrite();
        this.generateJava();
        this.os.close();
    }

    public Class compile() throws Exception {
        this.compileJava();
        return this.loadClass(false);
    }

    protected abstract void generateJava() throws Exception;

    protected void printDepends(ArrayList depends) throws IOException {
        this.println();
        this.println("private static com.caucho.vfs.Depend []_caucho_depend;");
        this.println();
        this.println("public static void " + this.initMethod + "(com.caucho.vfs.Path path)");
        this.println("{");
        this.pushDepth();
        this.println("_caucho_depend = new com.caucho.vfs.Depend[" + depends.size() + "];");
        for (int i = 0; i < depends.size(); ++i) {
            Path path = (Path)depends.get(i);
            this.print("_caucho_depend[" + i + "] = new com.caucho.vfs.Depend(");
            String relativePath = this.searchPath.lookup(path.getRelativePath()).getRelativePath();
            this.print("path.lookup(\"" + relativePath + "\"), ");
            this.println(path.getLastModified() + "L, " + path.getLength() + ");");
            this.println("_caucho_depend[" + i + "].setRequireSource(true);");
        }
        this.popDepth();
        this.println("}");
        this.println();
        this.println("public static boolean " + this.isModifiedMethod + "()");
        this.println("{");
        this.pushDepth();
        this.printVersionChange();
        this.println("for (int i = _caucho_depend.length - 1; i >= 0; i--) {");
        this.println("  if (_caucho_depend[i].isModified())");
        this.println("    return true;");
        this.println("}");
        this.println();
        this.println("return false;");
        this.popDepth();
        this.println("}");
    }

    protected void printVersionChange() throws IOException {
        this.println("if (com.caucho.util.CauchoSystem.getVersionId() != " + CauchoSystem.getVersionId() + ")");
        this.println("  return true;");
    }

    protected void printMethodHeader(Method method) throws IOException {
        this.printMethodHeader(method.getName(), method.getParameterTypes(), method.getReturnType(), method.getExceptionTypes());
    }

    protected void printMethodHeader(String name, Method method) throws IOException {
        this.printMethodHeader(name, method.getParameterTypes(), method.getReturnType(), method.getExceptionTypes());
    }

    protected void printMethodHeader(String methodName, Class[] parameters, Class returnType, Class[] exn) throws IOException {
        int i;
        this.println();
        this.print("public ");
        this.printClass(returnType);
        this.print(" ");
        this.print(methodName);
        this.print("(");
        for (i = 0; i < parameters.length; ++i) {
            if (i != 0) {
                this.print(", ");
            }
            this.printClass(parameters[i]);
            this.print(" a" + i);
        }
        this.println(")");
        if (exn != null && exn.length > 0) {
            this.print("  throws ");
            this.printClass(exn[0]);
            for (i = 1; i < exn.length; ++i) {
                this.print(", ");
                this.printClass(exn[i]);
            }
            this.println();
        }
    }

    protected void printClass(Class cl) throws IOException {
        if (!cl.isArray()) {
            this.print(cl.getName());
        } else {
            this.printClass(cl.getComponentType());
            this.print("[]");
        }
    }

    private void compileJava() throws IOException, ClassNotFoundException {
        JavaCompiler compiler = JavaCompiler.create(this.getParentLoader());
        compiler.setClassLoader(this.getParentLoader());
        compiler.setClassDir(this.getClassDir());
        compiler.compile(this.getFullClassName().replace('.', '/') + ".java", null);
    }

    public Class loadClass(boolean preload) throws IOException {
        try {
            ClassLoader loader = !preload && this.loader != null ? this.loader : SimpleClassLoader.create(this.getParentLoader(), this.getClassDir(), this.getFullClassName());
            Class cl = CauchoSystem.loadClass(this.getFullClassName(), false, loader);
            if (cl == null) {
                return null;
            }
            if (!preload) {
                return cl;
            }
            Method method = cl.getMethod(this.initMethod, class$com$caucho$vfs$Path == null ? (class$com$caucho$vfs$Path = AbstractGenerator.class$("com.caucho.vfs.Path")) : class$com$caucho$vfs$Path);
            method.invoke(null, this.getSearchPath());
            method = cl.getMethod(this.isModifiedMethod, new Class[0]);
            Boolean value = (Boolean)method.invoke(null, new Object[0]);
            if (value.booleanValue()) {
                return null;
            }
            loader = this.loader != null ? this.loader : SimpleClassLoader.create(this.getParentLoader(), this.getClassDir(), this.getFullClassName());
            return CauchoSystem.loadClass(this.getFullClassName(), false, loader);
        }
        catch (Throwable e) {
            if (!preload) {
                throw new IOExceptionWrapper(e);
            }
            return null;
        }
    }

    public void pushDepth() {
        this.indentDepth += 2;
    }

    public void popDepth() {
        this.indentDepth -= 2;
    }

    public void print(int ch) throws IOException {
        if (this.startLine) {
            this.printIndent();
        }
        this.os.print(ch);
    }

    public void print(String s) throws IOException {
        if (this.startLine) {
            this.printIndent();
        }
        this.os.print(s);
    }

    public void printStr(String s) throws IOException {
        block6: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\\': {
                    this.os.print("\\\\");
                    continue block6;
                }
                case '\n': {
                    this.os.print("\\n");
                    continue block6;
                }
                case '\r': {
                    this.os.print("\\r");
                    continue block6;
                }
                case '\"': {
                    this.os.print("\\\"");
                    continue block6;
                }
                default: {
                    this.os.print(ch);
                }
            }
        }
    }

    public void println() throws IOException {
        this.os.println();
        this.startLine = true;
    }

    public void println(String s) throws IOException {
        this.print(s);
        this.println();
    }

    public void printIndent() throws IOException {
        this.startLine = false;
        for (int i = 0; i < this.indentDepth; ++i) {
            this.os.print(' ');
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

