/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.java;

import com.caucho.java.CompileClassNotFound;
import com.caucho.java.JavaCompiler;
import com.caucho.regexp.Regexp;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.util.DynamicClassLoader;
import com.caucho.vfs.Depend;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.HashMap;

public class CompilingClassLoader
extends DynamicClassLoader {
    private static WriteStream dbg = LogStream.open("/caucho.com/java/loader");
    private static WriteStream log = LogStream.open("/log/java/loader");
    private Path sourceDir;
    private Path classDir;
    private ArrayList args;
    private String encoding;
    private ArrayList dependList;
    private HashMap excludedDirectories = new HashMap();

    protected CompilingClassLoader(ClassLoader parent) {
        super(parent);
        this.excludedDirectories.put("CVS", "CVS");
    }

    public static CompilingClassLoader create(ClassLoader parent, Path classDir, Path sourceDir, String args, String encoding) {
        CompilingClassLoader loader;
        block4: {
            if (classDir.getScheme().equals("http") || classDir.getScheme().equals("https")) {
                throw new RuntimeException("compiling class loader can't be http.  Use compile=false.");
            }
            loader = new CompilingClassLoader(parent);
            loader.sourceDir = sourceDir;
            loader.classDir = classDir;
            loader.encoding = encoding;
            loader.addCodeBasePath(classDir.getFullPath());
            try {
                if (args != null) {
                    loader.args = new Regexp("[\\s,]+").split(args);
                }
            }
            catch (Exception e) {
                if (!dbg.canWrite()) break block4;
                dbg.log(e);
            }
        }
        return loader;
    }

    public static CompilingClassLoader create(ClassLoader parent, Path classDir, Path sourceDir, String encoding) {
        return CompilingClassLoader.create(parent, classDir, sourceDir, null, encoding);
    }

    protected boolean isModifiedInt() {
        if (super.isModifiedInt()) {
            return true;
        }
        if (this.dependList == null) {
            return false;
        }
        for (int i = 0; i < this.dependList.size(); ++i) {
            Depend depend = (Depend)this.dependList.get(i);
            if (!depend.isModified()) continue;
            return true;
        }
        return false;
    }

    protected void makeAllInt() throws IOException, ClassNotFoundException {
        if (this.sourceDir.isDirectory() && !this.classDir.isDirectory()) {
            this.classDir.mkdirs();
        }
        String classPath = this.getTop().getClassPath();
        String sourcePath = this.prefixClassPath(classPath);
        this.makeAll(this.getTop(), "", this.sourceDir, this.classDir, sourcePath);
    }

    private void makeAll(DynamicClassLoader top, String name, Path sourceDir, Path classDir, String sourcePath) throws IOException, ClassNotFoundException {
        String[] list;
        try {
            list = sourceDir.list();
        }
        catch (IOException e) {
            return;
        }
        for (int i = 0; list != null && i < list.length; ++i) {
            if (list[i].startsWith(".") || this.excludedDirectories.get(list[i]) != null) continue;
            Path subSource = sourceDir.lookup(list[i]);
            if (subSource.isDirectory()) {
                this.makeAll(top, name + list[i] + "/", subSource, classDir.lookup(list[i]), sourcePath);
                continue;
            }
            if (!list[i].endsWith(".java")) continue;
            String prefix = list[i].substring(0, list[i].length() - 5);
            Path subClass = classDir.lookup(prefix + ".class");
            if (subSource.getLastModified() <= subClass.getLastModified()) continue;
            this.compileClass(top, subSource, subClass, sourcePath, true);
        }
    }

    protected DynamicClassLoader.Entry getClassEntry(String name) throws ClassNotFoundException {
        DynamicClassLoader.Entry entry;
        Path classFile = this.classDir.lookup(name.replace('.', '/') + ".class");
        String javaName = name.replace('.', '/') + ".java";
        Path javaFile = this.sourceDir.lookup(javaName);
        if (javaFile.getLastModified() < classFile.getLastModified() && (entry = this.loadClass(name, javaFile, classFile)) != null) {
            return entry;
        }
        if (!javaFile.canRead()) {
            return null;
        }
        try {
            classFile.remove();
        }
        catch (IOException e) {
            // empty catch block
        }
        String sourcePath = this.prefixClassPath(this.top.getSourcePath());
        if (CauchoSystem.isWindows() && !this.checkSource(this.sourceDir, javaName)) {
            return null;
        }
        this.compileClass(this.top, javaFile, classFile, sourcePath, false);
        DynamicClassLoader.Entry entry2 = this.loadClass(name, javaFile, classFile);
        if (entry2 != null) {
            return entry2;
        }
        if (javaFile.exists()) {
            throw new CompileClassNotFound("compiling " + name + " didn't produce a .class");
        }
        return null;
    }

    boolean checkSource(Path sourceDir, String javaName) {
        try {
            while (javaName != null && !javaName.equals("")) {
                int i;
                String head;
                int p = javaName.indexOf(47);
                if (p >= 0) {
                    head = javaName.substring(0, p);
                    javaName = javaName.substring(p + 1);
                } else {
                    head = javaName;
                    javaName = null;
                }
                String[] names = sourceDir.list();
                for (i = 0; i < names.length && !names[i].equals(head); ++i) {
                }
                if (i == names.length) {
                    return false;
                }
                sourceDir = sourceDir.lookup(head);
            }
        }
        catch (IOException e) {
            if (dbg.canWrite()) {
                dbg.log(e);
            }
            return false;
        }
        return true;
    }

    private DynamicClassLoader.Entry loadClass(String className, Path javaFile, Path classFile) {
        long length = classFile.getLength();
        DynamicClassLoader.Entry entry = new DynamicClassLoader.Entry(this, className, javaFile, classFile, this.classDir);
        Class cl = null;
        try {
            cl = this.loadClass(entry);
        }
        catch (Exception e) {
            try {
                if (javaFile.canRead()) {
                    classFile.remove();
                }
            }
            catch (IOException e1) {
                // empty catch block
            }
        }
        if (cl != null) {
            return entry;
        }
        return null;
    }

    private void compileClass(DynamicClassLoader top, Path javaSource, Path javaClass, String sourcePath, boolean isMake) throws ClassNotFoundException {
        try {
            String source;
            log.log("Compiling " + javaSource);
            JavaCompiler compiler = JavaCompiler.create(this);
            compiler.setClassDir(this.classDir);
            compiler.setSourceDir(this.sourceDir);
            if (this.encoding != null) {
                compiler.setEncoding(this.encoding);
            }
            compiler.setArgs(this.args);
            compiler.setCompileParent(!isMake);
            String prefix = this.sourceDir.getPath();
            String full = javaSource.getPath();
            if (full.startsWith(prefix)) {
                source = full.substring(prefix.length());
                if (source.startsWith("/")) {
                    source = source.substring(1);
                }
            } else {
                source = javaSource.getPath();
            }
            if (javaSource.canRead() && javaClass.exists()) {
                javaClass.remove();
            }
            compiler.compile(source, null);
        }
        catch (Exception e) {
            this.addDepend(javaSource);
            throw new CompileClassNotFound(e);
        }
    }

    private void addDepend(Path path) {
        Depend dep;
        if (this.dependList == null) {
            this.dependList = new ArrayList();
        }
        if (!this.dependList.contains(dep = new Depend(path))) {
            this.dependList.add(dep);
        }
    }

    protected Path getPath(String name) {
        Path path = this.classDir.lookup(name);
        if (path != null && path.exists()) {
            return path;
        }
        path = this.sourceDir.lookup(name);
        if (path != null && path.exists()) {
            return path;
        }
        return null;
    }

    protected String getClassPath(String head) {
        CharBuffer cb = new CharBuffer();
        if (!this.classDir.getScheme().equals("file")) {
            return head;
        }
        try {
            if (!this.classDir.isDirectory() && this.sourceDir.isDirectory()) {
                try {
                    this.classDir.mkdirs();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            cb.append(head);
            if (this.classDir.isDirectory()) {
                if (cb.length() > 0) {
                    cb.append(CauchoSystem.getPathSeparatorChar());
                }
                cb.append(this.classDir.getNativePath());
            }
            if (!this.classDir.equals(this.sourceDir)) {
                if (cb.length() > 0) {
                    cb.append(CauchoSystem.getPathSeparatorChar());
                }
                cb.append(this.sourceDir.getNativePath());
            }
            return cb.close();
        }
        catch (AccessControlException e) {
            dbg.log(String.valueOf(e));
            return head;
        }
    }

    protected String prefixClassPath(String tail) {
        CharBuffer cb = new CharBuffer();
        if (!this.classDir.isDirectory() && this.sourceDir.isDirectory()) {
            try {
                this.classDir.mkdirs();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.classDir.isDirectory()) {
            if (cb.length() > 0) {
                cb.append(CauchoSystem.getPathSeparatorChar());
            }
            cb.append(this.classDir.getNativePath());
        }
        if (!this.classDir.equals(this.sourceDir)) {
            if (cb.length() > 0) {
                cb.append(CauchoSystem.getPathSeparatorChar());
            }
            cb.append(this.sourceDir.getNativePath());
        }
        if (cb.length() > 0) {
            cb.append(CauchoSystem.getPathSeparatorChar());
        }
        cb.append(tail);
        return cb.close();
    }

    protected String getSourcePath(String head) {
        return this.getClassPath(head);
    }

    public String toString() {
        if (this.classDir.equals(this.sourceDir)) {
            return "[CompilingClassLoader src:" + this.sourceDir + "]";
        }
        return "[CompilingClassLoader src:" + this.sourceDir + " class:" + this.classDir + "]";
    }
}

