/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp;

import com.caucho.java.JavaCompiler;
import com.caucho.jsp.Page;
import com.caucho.server.http.Application;
import com.caucho.server.http.CauchoApplication;
import com.caucho.server.http.CauchoRequest;
import com.caucho.server.http.CauchoResponse;
import com.caucho.util.CacheListener;
import com.caucho.util.CauchoSystem;
import com.caucho.util.DynamicClassLoader;
import com.caucho.util.LruCache;
import com.caucho.util.Registry;
import com.caucho.util.RegistryException;
import com.caucho.util.RegistryNode;
import com.caucho.vfs.JarPath;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.MemoryPath;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.Iterator;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;

public abstract class PageManager {
    private static WriteStream dbg = LogStream.open("/caucho.com/jsp");
    private Application application;
    private Path classDir;
    private long updateInterval = 1000L;
    private boolean isAdapter;
    private boolean omitInitLog;
    private LruCache cache;
    protected boolean autoCompile = true;

    Path getClassDir() {
        if (this.classDir != null) {
            return this.classDir;
        }
        Path appDir = this.application.getAppDir();
        if (appDir instanceof MemoryPath) {
            String workPathName = "./" + this.application.getHost() + this.application.getContextPath();
            Path path = CauchoSystem.getWorkPath().lookup(workPathName);
            return path;
        }
        return appDir.lookup("WEB-INF/work");
    }

    PageManager(ServletContext context) throws RegistryException {
        this.application = (Application)context;
        this.classDir = this.application.getWorkDir();
        RegistryNode config = this.application.getRegistry();
        long interval = 15000L;
        int jspMax = Registry.getInt("/caucho.com/jsp/jsp-max", 1024);
        if (config != null) {
            interval = config.getPeriod("class-update-interval", 15000L);
            interval = config.getPeriod("jsp/jsp-update-interval", interval);
            jspMax = config.getInt("jsp/jsp-max", jspMax);
        }
        this.autoCompile = Registry.getBoolean("/caucho.com/jsp/auto-compile", true);
        if (config != null) {
            this.autoCompile = config.getBoolean("/jsp/auto-compile", this.autoCompile);
        }
        this.omitInitLog = Registry.getBoolean("/caucho.com/jsp/disable-init-log", true);
        if (config != null) {
            this.omitInitLog = config.getBoolean("/jsp/disable-init-log", this.omitInitLog);
        }
        this.cache = new LruCache(jspMax);
        if (interval < 0L) {
            interval = 0L;
        }
        this.updateInterval = interval;
    }

    String getPackagePrefix() {
        return Registry.getString("/caucho.com/jsp/package-prefix", "");
    }

    CauchoApplication getApplication() {
        return this.application;
    }

    Page getPage(CauchoRequest req, CauchoResponse res) throws Exception {
        Path subcontext;
        String servletPath = req.getPageServletPath();
        if (servletPath == null) {
            servletPath = "/";
        }
        String uri = req.getPageURI();
        Path appDir = this.application.getAppDir();
        String jspPath = (String)req.getAttribute("caucho.jsp.jsp-file");
        if (jspPath != null) {
            req.removeAttribute("caucho.jsp.jsp-file");
            Path subcontext2 = this.getPagePath(jspPath);
            return this.getPage(req, res, jspPath, subcontext2);
        }
        String pathInfo = req.getPagePathInfo();
        if (servletPath != null && !servletPath.equals("")) {
            try {
                Page page = this.getPage(req, res, servletPath, null);
                if (page != null) {
                    return page;
                }
            }
            catch (Throwable e) {
                dbg.log(e);
            }
        }
        if ((subcontext = this.getPagePath(servletPath)) != null) {
            return this.getPage(req, res, servletPath, subcontext);
        }
        if (pathInfo == null) {
            String realPath = this.application.getRealPath(servletPath);
            subcontext = appDir.lookupNative(realPath);
            return this.getPage(req, res, servletPath, subcontext);
        }
        subcontext = this.getPagePath(servletPath + pathInfo);
        if (subcontext != null) {
            return this.getPage(req, res, servletPath + pathInfo, subcontext);
        }
        if (servletPath != null && !servletPath.equals("")) {
            return null;
        }
        subcontext = this.getPagePath(pathInfo);
        if (subcontext != null) {
            return this.getPage(req, res, pathInfo, subcontext);
        }
        subcontext = this.getPagePath(uri);
        return this.getPage(req, res, uri, subcontext);
    }

    private Path getPagePath(String pathName) {
        String name;
        URL url;
        String realPath;
        Path appDir = this.application.getAppDir();
        Path path = appDir.lookupNative(realPath = this.application.getRealPath(pathName));
        if (path.isFile() && path.canRead()) {
            return path;
        }
        DynamicClassLoader loader = this.application.getClassLoader();
        if (loader != null) {
            url = this.application.getClassLoader().getResource(pathName);
            name = url != null ? url.toString() : null;
            path = null;
            if (url != null && (name.endsWith(".jar") || name.endsWith(".zip"))) {
                path = new JarPath(Vfs.lookup(url.toString())).lookup(pathName);
            } else if (url != null) {
                path = Vfs.lookup(url.toString());
            }
            if (path != null && path.isFile() && path.canRead()) {
                return path;
            }
        }
        name = (url = ClassLoader.getSystemResource(pathName)) != null ? url.toString() : null;
        path = null;
        if (url != null && (name.endsWith(".jar") || name.endsWith(".zip"))) {
            path = new JarPath(Vfs.lookup(url.toString())).lookup(pathName);
        } else if (url != null) {
            path = Vfs.lookup(url.toString());
        }
        if (path != null && path.isFile() && path.canRead()) {
            return path;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Page getPage(CauchoRequest req, CauchoResponse res, String uri, Path path) throws Exception {
        LruCache cache = this.cache;
        if (cache == null) {
            throw new ServletException("Attempted JSP page generation during application shutdown/reload.");
        }
        Entry entry = (Entry)cache.get(uri);
        if (entry == null) {
            LruCache lruCache = cache;
            synchronized (lruCache) {
                entry = (Entry)cache.get(uri);
                if (entry == null) {
                    entry = new Entry();
                    cache.put(uri, entry);
                }
            }
        }
        Page page = entry.getPage();
        ServletConfig config = (ServletConfig)req.getAttribute("caucho.jsp.servlet-config");
        if (page != null && !page.cauchoIsModified() && config == null) {
            return page;
        }
        Entry entry2 = entry;
        synchronized (entry2) {
            int p;
            page = entry.getPage();
            if (page != null && !page.cauchoIsModified() && config == null) {
                return page;
            }
            if (page != null && !page.isDead()) {
                page.setDead();
                try {
                    page.destroy();
                }
                catch (Exception e) {
                    dbg.log(e);
                }
            }
            if (dbg.canWrite()) {
                dbg.println("uri:" + req.getPageURI() + "(cp:" + this.application.getContextPath() + ",sp:" + req.getPageServletPath() + ",pi:" + req.getPagePathInfo() + ",app:" + this.application.getAppDir() + ") -> " + path);
            }
            Path appDir = this.getApplication().getAppDir();
            String uriPwd = uri != null ? ((p = uri.lastIndexOf(47)) <= 0 ? "/" : uri.substring(0, p + 1)) : "/";
            String className = JavaCompiler.mangleName(uri);
            uri = req.getContextPath() + uri;
            try {
                page = this.createPage(path, uri, className, uriPwd, req);
            }
            catch (FileNotFoundException e) {
                res.sendError(404);
                throw e;
            }
            if (page == null) {
                return null;
            }
            if (!this.autoCompile) {
                page._caucho_setNeverModified(true);
            }
            page._caucho_setUpdateInterval(this.updateInterval);
            if (config == null) {
                entry.setPage(page);
            }
            return page;
        }
    }

    abstract Page createPage(Path var1, String var2, String var3, String var4, CauchoRequest var5) throws Exception;

    void killPage(CauchoRequest request, CauchoResponse response, Page page) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroy() {
        LruCache cache = this.cache;
        this.cache = null;
        if (cache == null) {
            return;
        }
        LruCache lruCache = cache;
        synchronized (lruCache) {
            Iterator iter = cache.values();
            while (iter.hasNext()) {
                Entry entry = (Entry)iter.next();
                Page page = entry != null ? entry.getPage() : null;
                try {
                    if (page == null || page.isDead()) continue;
                    page.destroy();
                }
                catch (Exception e) {
                    if (!dbg.canWrite()) continue;
                    dbg.log(e);
                }
            }
        }
    }

    static class Entry
    implements CacheListener {
        private static WriteStream dbg = LogStream.open("/caucho.com/jsp");
        Page page;

        Entry() {
        }

        void setPage(Page page) {
            this.page = page;
        }

        Page getPage() {
            return this.page;
        }

        public void removeEvent() {
            if (this.page != null && !this.page.isDead()) {
                if (dbg.canWrite()) {
                    dbg.log("dropping page " + this.page);
                }
                this.page.setDead();
                this.page.destroy();
                this.page = null;
            }
        }
    }
}

