/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp;

import com.caucho.jsp.Page;
import com.caucho.server.http.CauchoResponse;
import com.caucho.util.Alarm;
import com.caucho.vfs.Path;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

class StaticPage
extends Page {
    private Path cacheEntry;
    private long lastModified;
    private int contentLength;
    private boolean hasSession;

    StaticPage(Path path, boolean hasSession) throws IOException {
        this.cacheEntry = path;
        this.lastModified = Alarm.getCurrentTime();
        this.contentLength = (int)this.cacheEntry.getLength();
        this.hasSession = hasSession;
    }

    public boolean _caucho_isModified() {
        return !this.cacheEntry.exists() || super._caucho_isModified();
    }

    void _caucho_setUncacheable() {
        this.lastModified = 0L;
    }

    public long getLastModified(HttpServletRequest request) {
        return this.lastModified;
    }

    public void service(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        this._caucho_init(req, res);
        if (this.hasSession) {
            req.getSession();
            res.setHeader("Cache-Control", "private");
        }
        res.setContentLength(this.contentLength);
        ((CauchoResponse)response).getStream().writeFile(this.cacheEntry);
    }

    public void destroy() {
        try {
            this.cacheEntry.remove();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String toString() {
        return "[StaticPage " + this.cacheEntry + "]";
    }
}

