/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp;

import com.caucho.jsp.JspManager;
import com.caucho.jsp.Page;
import com.caucho.jsp.PageManager;
import com.caucho.jsp.QJspFactory;
import com.caucho.jsp.XslManager;
import com.caucho.jsp.XtpPage;
import com.caucho.server.http.CauchoRequest;
import com.caucho.util.RegistryException;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.WriteStream;
import java.util.HashMap;
import javax.servlet.ServletContext;
import javax.servlet.jsp.JspFactory;

public class XtpManager
extends PageManager {
    private static WriteStream dbg = LogStream.open("/caucho.com/xtp/manager");
    private static HashMap managerCache = new HashMap();
    private boolean strictXml;
    private boolean toLower = true;
    private boolean entitiesAsText = true;
    private XslManager xslManager;
    private JspManager jspManager;
    private String defaultStylesheet = "default.xsl";

    XtpManager(ServletContext context) throws RegistryException {
        super(context);
        if (JspFactory.getDefaultFactory() == null) {
            JspFactory.setDefaultFactory((JspFactory)new QJspFactory());
        }
        this.xslManager = new XslManager(context);
        this.jspManager = new JspManager(context);
    }

    public String getDefaultStylesheet() {
        return this.defaultStylesheet;
    }

    public void setDefaultStylesheet(String stylesheet) {
        this.defaultStylesheet = stylesheet;
    }

    public void setStrictXml(boolean strictXml) {
        this.strictXml = strictXml;
    }

    public void setStrictXsl(boolean strictXsl) {
        this.xslManager.setStrictXsl(strictXsl);
    }

    public void setToLower(boolean toLower) {
        this.toLower = toLower;
    }

    public void setEntitiesAsText(boolean entitiesAsText) {
        this.entitiesAsText = entitiesAsText;
    }

    public static synchronized XtpManager getManager(ServletContext context) throws RegistryException {
        XtpManager manager = (XtpManager)managerCache.get(context);
        if (manager == null) {
            manager = new XtpManager(context);
            managerCache.put(context, manager);
        }
        return manager;
    }

    Page createPage(Path path, String uri, String className, String uriPwd, CauchoRequest req) throws Exception {
        if (path == null || !path.canRead() || path.isDirectory()) {
            return null;
        }
        XtpPage xtpPage = new XtpPage(path, uri, className, uriPwd, req, this.xslManager, this.strictXml);
        xtpPage.setManager(this.jspManager);
        xtpPage.setHtmlToLower(this.toLower);
        return xtpPage;
    }
}

