/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp.el;

import com.caucho.el.ELException;
import com.caucho.el.Expr;
import com.caucho.el.VariableResolver;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;

public class ImplicitFieldExpr
extends Expr {
    private int _index;
    private Expr _field;

    public ImplicitFieldExpr(int index, Expr field) {
        this._index = index;
        this._field = field;
    }

    public Object evalObject(VariableResolver env) throws ELException {
        Object fieldValue = this._field.evalObject(env);
        if (fieldValue == null) {
            return null;
        }
        String fieldString = ImplicitFieldExpr.toString(fieldValue);
        PageContext page = (PageContext)env;
        switch (this._index) {
            case 2: {
                return page.getServletContext().getAttribute(fieldString);
            }
            case 3: {
                return page.getSession().getAttribute(fieldString);
            }
            case 4: {
                return page.getRequest().getAttribute(fieldString);
            }
            case 5: {
                return page.getAttribute(fieldString);
            }
            case 6: {
                return page.getRequest().getParameter(fieldString);
            }
            case 7: {
                return page.getRequest().getParameterValues(fieldString);
            }
            case 9: {
                return ((HttpServletRequest)page.getRequest()).getHeader(fieldString);
            }
            case 10: {
                Enumeration e = ((HttpServletRequest)page.getRequest()).getHeaders(fieldString);
                if (e == null) {
                    return null;
                }
                if (!e.hasMoreElements()) {
                    return null;
                }
                ArrayList list = new ArrayList();
                while (e.hasMoreElements()) {
                    list.add(e.nextElement());
                }
                return list.toArray(new String[list.size()]);
            }
            case 8: {
                return page.getServletContext().getInitParameter(fieldString);
            }
            case 11: {
                Cookie[] cookies = ((HttpServletRequest)page.getRequest()).getCookies();
                if (cookies == null) {
                    return null;
                }
                for (int i = 0; i < cookies.length; ++i) {
                    if (!cookies[i].getName().equals(fieldString)) continue;
                    return cookies[i];
                }
                return null;
            }
        }
        throw new UnsupportedOperationException();
    }

    public void printCreate(WriteStream os) throws IOException {
        os.print("new com.caucho.jsp.el.ImplicitFieldExpr(");
        os.print(this._index);
        os.print(", ");
        this._field.printCreate(os);
        os.print(")");
    }

    public static class AttributeMap
    extends AbstractMap {
        private PageContext _pageContext;
        private int _scope;
        private EntrySet _entrySet;

        AttributeMap(PageContext pageContext, int scope) {
            this._pageContext = pageContext;
            this._scope = scope;
        }

        public Object get(Object key) {
            return this._pageContext.getAttribute((String)key, this._scope);
        }

        public Object put(Object key, Object value) {
            this._pageContext.setAttribute((String)key, value, this._scope);
            return null;
        }

        public Set entrySet() {
            if (this._entrySet == null) {
                this._entrySet = new EntrySet();
            }
            return this._entrySet;
        }

        public class EntryIterator
        implements Iterator,
        Map.Entry {
            Enumeration _e;
            String _name;
            Object _value;

            EntryIterator() {
                this._e = AttributeMap.this._pageContext.getAttributeNamesInScope(AttributeMap.this._scope);
            }

            public boolean hasNext() {
                return this._e.hasMoreElements();
            }

            public Object next() {
                this._name = (String)this._e.nextElement();
                this._value = AttributeMap.this._pageContext.getAttribute(this._name, AttributeMap.this._scope);
                return this;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public Object getKey() {
                return this._name;
            }

            public Object getValue() {
                return this._value;
            }

            public Object setValue(Object value) {
                AttributeMap.this._pageContext.setAttribute(this._name, value, AttributeMap.this._scope);
                Object oldValue = this._value;
                this._value = value;
                return oldValue;
            }

            public int hashCode() {
                return this._name.hashCode();
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof EntryIterator)) {
                    return false;
                }
                EntryIterator entry = (EntryIterator)obj;
                return this._name.equals(entry._name) && (this._value == null && entry._value == null || this._value != null && this._value.equals(entry._value));
            }
        }

        public class EntrySet
        extends AbstractSet {
            public int size() {
                Enumeration e = AttributeMap.this._pageContext.getAttributeNamesInScope(AttributeMap.this._scope);
                int i = 0;
                while (e.hasMoreElements()) {
                    e.nextElement();
                    ++i;
                }
                return i;
            }

            public Iterator iterator() {
                return new EntryIterator();
            }
        }
    }
}

