/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jstl.rt;

import com.caucho.jstl.NameValueTag;
import com.caucho.jstl.rt.CoreSetTag;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;

public class CoreUrlTag
extends TagSupport
implements NameValueTag {
    private static L10N L;
    private static String[] _shortEncoding;
    private String _value;
    private String _context;
    private String _var;
    private String _scope;
    private CharBuffer _url;
    static /* synthetic */ Class class$com$caucho$jstl$rt$CoreUrlTag;

    public void setValue(String value) {
        this._value = value;
    }

    public void setContext(String context) {
        this._context = context;
    }

    public void setVar(String var) {
        this._var = var;
    }

    public void setScope(String scope) {
        this._scope = scope;
    }

    public void addParam(String name, String value) {
        CoreUrlTag.addParam(this._url, name, value);
    }

    public int doStartTag() throws JspException {
        String value = this._value;
        String context = this._context;
        this._url = CoreUrlTag.normalizeURL(this.pageContext, value, context);
        return 1;
    }

    public int doEndTag() throws JspException {
        String value = CoreUrlTag.encodeURL(this.pageContext, this._url);
        try {
            if (this._var == null) {
                JspWriter out = this.pageContext.getOut();
                out.print(value);
            } else {
                CoreSetTag.setValue(this.pageContext, this._var, this._scope, value);
            }
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
        return 6;
    }

    public static CharBuffer normalizeURL(PageContext pageContext, String url, String context) throws JspException {
        CharBuffer value = CharBuffer.allocate();
        if (value == null || value.equals("")) {
            throw new JspTagException(L.l("url may not be null"));
        }
        int slash = url.indexOf(47);
        int colon = url.indexOf(58);
        if (colon > 0 && colon < slash) {
            value.append(url);
        } else if (slash == 0) {
            HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
            if (context != null) {
                value.append(context);
                value.append(url);
            } else {
                value.append(request.getContextPath());
                value.append(url);
            }
        } else {
            HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
            String servletPath = request.getServletPath();
            String pathInfo = request.getPathInfo();
            if (context != null) {
                value.append(context);
            } else {
                value.append(request.getContextPath());
            }
            if (servletPath != null && pathInfo != null) {
                value.append(servletPath);
                value.append(pathInfo);
            } else if (servletPath != null) {
                value.append(servletPath);
            } else {
                value.append(pathInfo);
            }
            int p = value.lastIndexOf('/');
            value.setLength(p + 1);
            value.append(url);
        }
        return value;
    }

    public static CharBuffer addParam(CharBuffer url, String name, String value) {
        if (url.indexOf('?') < 0) {
            url.append('?');
        } else {
            url.append('&');
        }
        CoreUrlTag.addEncodedString(url, name);
        url.append('=');
        CoreUrlTag.addEncodedString(url, value);
        return url;
    }

    public static CharBuffer addEncodedString(CharBuffer cb, String value) {
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            int d2;
            int d1;
            char ch = value.charAt(i);
            if (ch < '\u0080') {
                cb.append(_shortEncoding[ch]);
                continue;
            }
            if (ch < '\u0800') {
                d1 = 192 + (ch >> 6 & 0x1F);
                d2 = 128 + (ch & 0x3F);
                cb.append('%');
                cb.append(CoreUrlTag.hex(d1 >> 4));
                cb.append(CoreUrlTag.hex(d1 & 0xF));
                cb.append('%');
                cb.append(CoreUrlTag.hex(d2 >> 4));
                cb.append(CoreUrlTag.hex(d2 & 0xF));
                continue;
            }
            d1 = 224 + (ch >> 12 & 0xF);
            d2 = 128 + (ch >> 6 & 0x3F);
            int d3 = 128 + (ch & 0x3F);
            cb.append('%');
            cb.append(CoreUrlTag.hex(d1 >> 4));
            cb.append(CoreUrlTag.hex(d1 & 0xF));
            cb.append('%');
            cb.append(CoreUrlTag.hex(d2 >> 4));
            cb.append(CoreUrlTag.hex(d2 & 0xF));
            cb.append('%');
            cb.append(CoreUrlTag.hex(d3 >> 4));
            cb.append(CoreUrlTag.hex(d3 & 0xF));
        }
        return cb;
    }

    public static String encodeURL(PageContext pageContext, CharBuffer url) {
        String value = url.toString();
        if (value.startsWith("/")) {
            return ((HttpServletResponse)pageContext.getResponse()).encodeURL(value);
        }
        return value;
    }

    private static char hex(int d) {
        if ((d &= 0xF) < 10) {
            return (char)(48 + d);
        }
        return (char)(65 + d - 10);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        int i;
        L = new L10N(class$com$caucho$jstl$rt$CoreUrlTag == null ? (class$com$caucho$jstl$rt$CoreUrlTag = CoreUrlTag.class$("com.caucho.jstl.rt.CoreUrlTag")) : class$com$caucho$jstl$rt$CoreUrlTag);
        _shortEncoding = new String[128];
        for (i = 0; i < _shortEncoding.length; ++i) {
            CoreUrlTag._shortEncoding[i] = "%" + CoreUrlTag.hex(i / 16) + CoreUrlTag.hex(i);
        }
        for (i = 97; i <= 122; ++i) {
            CoreUrlTag._shortEncoding[i] = String.valueOf((char)i);
        }
        for (i = 65; i <= 90; ++i) {
            CoreUrlTag._shortEncoding[i] = String.valueOf((char)i);
        }
        for (i = 48; i <= 57; ++i) {
            CoreUrlTag._shortEncoding[i] = String.valueOf((char)i);
        }
        CoreUrlTag._shortEncoding[32] = "+";
        CoreUrlTag._shortEncoding[45] = "-";
        CoreUrlTag._shortEncoding[95] = "_";
        CoreUrlTag._shortEncoding[46] = ".";
        CoreUrlTag._shortEncoding[33] = "!";
        CoreUrlTag._shortEncoding[126] = "~";
        CoreUrlTag._shortEncoding[39] = "'";
    }
}

