/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jstl.rt;

import com.caucho.jstl.rt.SqlQueryTag;
import com.caucho.util.L10N;
import com.caucho.vfs.LogStream;
import com.caucho.vfs.WriteStream;
import java.sql.Connection;
import java.sql.SQLException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.TagSupport;
import javax.servlet.jsp.tagext.TryCatchFinally;
import javax.sql.DataSource;

public class SqlTransactionTag
extends TagSupport
implements TryCatchFinally {
    private static WriteStream dbg = LogStream.open("/caucho.com/jsp/jstl/sql");
    private static L10N L = new L10N(class$com$caucho$jstl$rt$SqlTransactionTag == null ? (class$com$caucho$jstl$rt$SqlTransactionTag = SqlTransactionTag.class$("com.caucho.jstl.rt.SqlTransactionTag")) : class$com$caucho$jstl$rt$SqlTransactionTag);
    private Object _dataSource;
    private String _isolation;
    private Connection _conn;
    private int _oldIsolation;
    static /* synthetic */ Class class$com$caucho$jstl$rt$SqlTransactionTag;

    public void setDataSource(Object dataSource) {
        this._dataSource = dataSource;
    }

    public void setIsolation(String isolation) {
        this._isolation = isolation;
    }

    public int doStartTag() throws JspException {
        if (this.pageContext.getAttribute("caucho.jstl.sql.conn") != null) {
            throw new JspTagException(L.l("nexted sql:transaction are forbidden"));
        }
        try {
            DataSource ds = SqlQueryTag.getDataSource(this.pageContext, this._dataSource);
            int isolationCode = -1;
            if (this._isolation != null) {
                if (this._isolation.equals("read_committed")) {
                    isolationCode = 2;
                } else if (this._isolation.equals("read_uncommitted")) {
                    isolationCode = 1;
                } else if (this._isolation.equals("repeatable_read")) {
                    isolationCode = 4;
                } else if (this._isolation.equals("serializable")) {
                    isolationCode = 8;
                } else {
                    throw new JspTagException(L.l("unknown sql:transaction isolation ~{0}'", this._isolation));
                }
            }
            this._conn = ds.getConnection();
            this._oldIsolation = this._conn.getTransactionIsolation();
            this._conn.setAutoCommit(false);
            if (this._isolation != null && isolationCode != this._oldIsolation) {
                this._conn.setTransactionIsolation(isolationCode);
            }
            this.pageContext.setAttribute("caucho.jstl.sql.conn", (Object)this._conn);
        }
        catch (JspException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JspException((Throwable)e);
        }
        return 6;
    }

    public void doCatch(Throwable t) throws Throwable {
        if (this._conn != null) {
            this._conn.rollback();
        }
        throw t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFinally() {
        block10: {
            try {
                this.pageContext.removeAttribute("caucho.jstl.sql.conn");
                if (this._conn == null) break block10;
                Connection conn = this._conn;
                this._conn = null;
                try {
                    conn.commit();
                    Object var3_3 = null;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    try {
                        conn.setTransactionIsolation(this._oldIsolation);
                    }
                    catch (SQLException e) {
                        // empty catch block
                    }
                    try {
                        conn.close();
                    }
                    catch (SQLException e) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    conn.setTransactionIsolation(this._oldIsolation);
                }
                catch (SQLException e) {
                    // empty catch block
                }
                try {
                    conn.close();
                }
                catch (SQLException e) {}
            }
            catch (Exception e) {
                dbg.log(e);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

