/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.http.session.SessionImpl;
import com.caucho.http.session.SessionManager;
import com.caucho.server.http.AbstractRequest;
import com.caucho.server.http.Application;
import com.caucho.server.http.CauchoApplication;
import com.caucho.server.http.CauchoRequest;
import com.caucho.server.http.CauchoResponse;
import com.caucho.server.http.Form;
import com.caucho.server.http.QServletInputStream;
import com.caucho.server.http.RequestAdapter;
import com.caucho.util.FreeList;
import com.caucho.vfs.BufferedReaderAdapter;
import com.caucho.vfs.Encoding;
import com.caucho.vfs.ReadStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

class DispatchRequest
extends RequestAdapter {
    private static final FreeList _freeList = new FreeList(32);
    private Form formParser = new Form();
    private Application application;
    private HashMap form;
    private Hashtable headers;
    protected ReadStream readStream;
    protected QServletInputStream is;
    private BufferedReaderAdapter bufferedReader;
    private String method;
    private String uri;
    private String servletPath;
    private String pathInfo;
    private String queryString;
    private String addedQuery;
    private SessionImpl session;
    private String pageUri;
    private String pageContextPath;
    private String pageServletPath;
    private String pagePathInfo;
    private String pageQueryString;

    protected DispatchRequest() {
    }

    public static DispatchRequest createDispatch() {
        DispatchRequest req = (DispatchRequest)_freeList.allocate();
        if (req == null) {
            req = new DispatchRequest();
        }
        return req;
    }

    void init(Application application, HttpServletRequest request, CauchoResponse response, String method, String uri, String servletPath, String pathInfo, String queryString, String addedQuery) throws ServletException {
        super.init(request, response, application);
        this.application = application;
        this.form = null;
        this.headers = null;
        this.readStream = null;
        this.is = null;
        this.bufferedReader = null;
        this.method = method;
        this.uri = uri;
        this.servletPath = servletPath;
        this.pathInfo = pathInfo;
        this.queryString = queryString;
        this.addedQuery = addedQuery;
        this.pageUri = null;
        this.pageContextPath = null;
        this.pageServletPath = null;
        this.pagePathInfo = null;
        this.pageQueryString = null;
        this.session = null;
    }

    void setStream(ReadStream readStream) {
        this.readStream = readStream;
    }

    public Application getApplication() {
        return this.application;
    }

    public CauchoApplication getCauchoApplication() {
        return this.application;
    }

    public String getMethod() {
        return this.method;
    }

    public String getRequestURI() {
        return this.uri;
    }

    void setPageURI(String uri) {
        this.pageUri = uri;
    }

    public String getPageURI() {
        return this.pageUri;
    }

    public String getContextPath() {
        return this.application.getContextPath();
    }

    void setPageContextPath(String contextPath) {
        this.pageContextPath = contextPath;
    }

    public String getPageContextPath() {
        return this.pageContextPath;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public String getPageServletPath() {
        return this.pageServletPath;
    }

    void setPageServletPath(String servletPath) {
        this.pageServletPath = servletPath;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getPagePathInfo() {
        return this.pagePathInfo;
    }

    void setPagePathInfo(String pathInfo) {
        this.pagePathInfo = pathInfo;
    }

    public String getQueryString() {
        return this.queryString;
    }

    void setPageQueryString(String queryString) {
        this.pageQueryString = queryString;
    }

    public String getPageQueryString() {
        return this.pageQueryString;
    }

    public String getHeader(String key) {
        String value = null;
        if (this.headers != null) {
            value = (String)this.headers.get(key);
        }
        if (value != null) {
            return value;
        }
        if (key.equalsIgnoreCase("If-Modified-Since") || key.equalsIgnoreCase("If-None-Match")) {
            return null;
        }
        return this.request.getHeader(key);
    }

    public void setHeader(String key, String value) {
        if (this.headers == null) {
            this.headers = new Hashtable();
        }
        this.headers.put(key, value);
    }

    public Map getParameterMap() {
        if (this.form == null) {
            this.form = this.parseQuery();
        }
        return this.form;
    }

    public Enumeration getParameterNames() {
        if (this.form == null) {
            this.form = this.parseQuery();
        }
        return Collections.enumeration(this.form.keySet());
    }

    public String[] getParameterValues(String name) {
        if (this.form == null) {
            this.form = this.parseQuery();
        }
        return (String[])this.form.get(name);
    }

    public String getParameter(String name) {
        String[] values = this.getParameterValues(name);
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }

    private HashMap parseQuery() {
        HashMap<String, String[]> table = new HashMap<String, String[]>();
        String defaultEncoding = this.application.getCharEncoding();
        String charEncoding = this.getCharacterEncoding();
        if (charEncoding == null) {
            charEncoding = defaultEncoding;
        }
        String javaEncoding = Encoding.getJavaName(charEncoding);
        if (this.addedQuery != null) {
            try {
                this.formParser.parseQueryString(table, this.addedQuery, javaEncoding);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        Enumeration enumeration = this.request.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String[] oldValues = this.request.getParameterValues(key);
            String[] newValues = (String[])table.get(key);
            if (newValues == null) {
                table.put(key, oldValues);
                continue;
            }
            String[] next = new String[oldValues.length + newValues.length];
            System.arraycopy(newValues, 0, next, 0, newValues.length);
            System.arraycopy(oldValues, 0, next, newValues.length, oldValues.length);
            table.put(key, next);
        }
        return table;
    }

    public String getRealPath(String path) {
        return this.application.getRealPath(path);
    }

    public String getPathTranslated() {
        if (this.pathInfo != null) {
            return this.getRealPath(this.pathInfo);
        }
        return null;
    }

    public ReadStream getStream() throws IOException {
        if (this.readStream == null && this.request instanceof AbstractRequest) {
            return ((AbstractRequest)this.request).getStream();
        }
        return this.readStream;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.readStream == null) {
            return this.request.getInputStream();
        }
        if (this.is == null) {
            this.is = new QServletInputStream();
        }
        this.is.init(this.readStream);
        return this.is;
    }

    public BufferedReader getReader() throws IOException {
        if (this.readStream == null) {
            return this.request.getReader();
        }
        if (this.bufferedReader == null) {
            this.bufferedReader = new BufferedReaderAdapter(this.getStream());
        }
        this.bufferedReader.init(this.getStream());
        return this.bufferedReader;
    }

    public HttpSession getSession(boolean create) {
        SessionManager manager = this.application.getSessionManager();
        this.setVaryCookie(manager.getCookieName());
        if (this.session != null && this.session.isValid()) {
            this.setHasCookie();
            return this.session;
        }
        if (!(this.request instanceof CauchoRequest) || this.getApplication() == ((CauchoRequest)this.request).getCauchoApplication()) {
            HttpSession hSession = this.request.getSession(create);
            if (hSession != null) {
                this.setHasCookie();
            }
            return hSession;
        }
        boolean hasOldSession = this.session != null;
        this.session = this.createSession(create, hasOldSession);
        if (this.session != null) {
            this.setHasCookie();
        }
        return this.session;
    }

    public void finish() {
        if (this.session != null && this.request instanceof CauchoRequest && this.getApplication() != ((CauchoRequest)this.request).getCauchoApplication()) {
            this.session.finish();
        }
    }

    public static void free(DispatchRequest req) {
        req.free();
        _freeList.free(req);
    }

    protected void free() {
        this.application = null;
        this.session = null;
        super.free();
    }
}

