/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.jsp.Page;
import com.caucho.jsp.QServlet;
import com.caucho.server.http.CauchoRequest;
import com.caucho.server.http.CauchoResponse;
import com.caucho.server.http.FilterChainBase;
import com.caucho.server.http.QServletConfig;
import com.caucho.server.http.RequestAdapter;
import com.caucho.server.http.ResponseAdapter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.SingleThreadModel;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FilterChainPage
extends FilterChainBase {
    private QServlet servlet;
    private String jspFile;
    private QServletConfig config;
    private Page page;
    private boolean isSingleThread;

    FilterChainPage(QServlet servlet) {
        this.servlet = servlet;
    }

    FilterChainPage(QServlet servlet, String jspFile, QServletConfig config) {
        this.servlet = servlet;
        this.jspFile = jspFile;
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doFilter(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        CauchoRequest req;
        CauchoResponse res;
        ResponseAdapter resAdapt = null;
        if (response instanceof CauchoResponse) {
            res = (CauchoResponse)response;
        } else {
            resAdapt = ResponseAdapter.create((HttpServletResponse)response);
            res = resAdapt;
        }
        if (request instanceof CauchoRequest) {
            req = (CauchoRequest)request;
        } else {
            RequestAdapter reqAdapt = new RequestAdapter();
            reqAdapt.init((HttpServletRequest)request, res, this.application);
            reqAdapt.setApplication(this.application);
            req = reqAdapt;
        }
        if (this.page == null || this.page.cauchoIsModified()) {
            try {
                if (this.jspFile != null) {
                    req.setAttribute("caucho.jsp.jsp-file", this.jspFile);
                    req.setAttribute("caucho.jsp.servlet-config", this.config);
                }
                this.servlet.killPage(req, res, this.page);
                this.page = this.servlet.getPage(req, res);
                this.isSingleThread = this.page instanceof SingleThreadModel;
            }
            catch (ServletException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        }
        if (this.page == null) {
            if (req.getAttribute("javax.servlet.include.request_uri") != null) throw new FileNotFoundException(req.getPageURI());
            res.sendError(404);
        } else {
            int p;
            String queryString = req.getPageQueryString();
            String precompile = null;
            if (queryString != null && (p = queryString.indexOf("jsp_precompile")) >= 0) {
                int offset = p + "jsp_precompile".length();
                precompile = offset < queryString.length() && queryString.charAt(offset) == '=' ? queryString.substring(offset + 1) : "";
            }
            if (precompile != null) {
                if (precompile.equals("") || precompile.equals("\"true\"") || precompile.equals("true")) {
                    PrintWriter pw = res.getWriter();
                    pw.println("Precompiled page.");
                    return;
                }
                if (!precompile.equals("\"false\"") && !precompile.equals("false")) {
                    throw new ServletException(L.l("Illegal jsp_precompile value `{0}'", precompile));
                }
            }
            if (this.isSingleThread) {
                Page page = this.page;
                synchronized (page) {
                    this.page.subservice(req, res);
                }
            } else {
                this.page.subservice(req, res);
            }
            if (res.getChain() != null) {
                this.handleChain((ServletRequest)req, res);
            }
        }
        if (resAdapt == null) return;
        resAdapt.close();
    }
}

