/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.server.http.CauchoResponse;
import com.caucho.server.http.FilterChainBase;
import com.caucho.server.http.QServletConfig;
import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;

public class FilterChainServlet
extends FilterChainBase {
    protected QServletConfig config;
    protected Servlet servlet;

    FilterChainServlet(QServletConfig config, Servlet servlet) {
        this.config = config;
        this.servlet = servlet;
        if (servlet == null) {
            throw new NullPointerException();
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        CauchoResponse res;
        if (this.servlet == null) {
            try {
                this.servlet = this.config.loadServlet(false);
            }
            catch (ServletException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        }
        try {
            this.servlet.service(request, response);
        }
        catch (UnavailableException e) {
            this.config.setInitException((ServletException)((Object)e));
            this.application.killServlet(this.servlet, this.config);
            this.servlet = null;
            throw e;
        }
        if (response instanceof CauchoResponse && (res = (CauchoResponse)response).getChain() != null) {
            this.handleChain(request, res);
        }
    }
}

